/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA.Apps;

import Clazz.jq_Method;
import Compil3r.Analysis.IPA.PAResultSelector;
import Compil3r.Analysis.IPA.PAResults;
import Compil3r.Analysis.IPSSA.IPSSABuilder;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.Utils.AnalysisObjectSpec;
import Compil3r.Analysis.IPSSA.Utils.ReachabilityTrace;
import Util.Assert;
import java.util.Collection;
import java.util.Iterator;
import org.sf.javabdd.TypedBDDFactory;

public abstract class ReachabilityTracerApp
extends IPSSABuilder.Application {
    private static boolean _verbose = false;
    protected String _def1_str;
    protected String _def2_str;

    private static final void usage(String[] stringArray) {
        System.err.print("Invalid parameters: ");
        int n = 0;
        while (n < stringArray.length) {
            System.err.print(stringArray[n] + ' ');
            ++n;
        }
        System.err.println("");
        System.exit(1);
    }

    protected abstract void printPath(String var1, String var2);

    protected void parseParams(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length < 2) {
            ReachabilityTracerApp.usage(stringArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("->")) {
                this._def1_str = stringBuffer.toString();
                stringBuffer.setLength(0);
            } else {
                stringBuffer.append(string);
                stringBuffer.append(" ");
            }
            ++n;
        }
        this._def2_str = stringBuffer.toString();
    }

    public void run() {
        this.printPath(this._def1_str, this._def2_str);
    }

    ReachabilityTracerApp(IPSSABuilder iPSSABuilder, String string, String[] stringArray) {
        super(iPSSABuilder, string, stringArray);
    }

    public static class PAReachabilityTracerApp
    extends ReachabilityTracerApp {
        private PAResults _pa;

        public void initialize() {
        }

        protected void printPath(String string, String string2) {
            TypedBDDFactory.TypedBDD typedBDD;
            TypedBDDFactory.TypedBDD typedBDD2;
            System.err.println("In printPath(" + string + ", " + string2 + ')');
            boolean bl = false;
            if (this._builder != null) {
                bl = true;
            }
            Assert._assert(bl);
            this._pa = this._builder.getPAResults();
            PAResultSelector pAResultSelector = new PAResultSelector(this._pa);
            try {
                typedBDD2 = AnalysisObjectSpec.PAObjectSpec.create(pAResultSelector, string).getBDD();
                typedBDD = AnalysisObjectSpec.PAObjectSpec.create(pAResultSelector, string2).getBDD();
            }
            catch (AnalysisObjectSpec.UnknownAnalysisObjectExeption unknownAnalysisObjectExeption) {
                System.err.println(unknownAnalysisObjectExeption);
                return;
            }
            pAResultSelector.collectReachabilityTraces(typedBDD2, typedBDD);
        }

        public void test() {
            TypedBDDFactory.TypedBDD typedBDD;
            TypedBDDFactory.TypedBDD typedBDD2;
            boolean bl = false;
            if (this._builder != null) {
                bl = true;
            }
            Assert._assert(bl);
            this._pa = this._builder.getPAResults();
            boolean bl2 = false;
            if (this._pa != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            PAResultSelector pAResultSelector = new PAResultSelector(this._pa);
            try {
                typedBDD2 = AnalysisObjectSpec.PAObjectSpec.create(pAResultSelector, "return Main/TT getF").getBDD();
                typedBDD = AnalysisObjectSpec.PAObjectSpec.create(pAResultSelector, "param Main/TT setF 1").getBDD();
            }
            catch (AnalysisObjectSpec.UnknownAnalysisObjectExeption unknownAnalysisObjectExeption) {
                System.err.println(unknownAnalysisObjectExeption);
                return;
            }
            pAResultSelector.collectReachabilityTraces(typedBDD2, typedBDD);
        }

        public PAReachabilityTracerApp() {
            this(null, null, null);
        }

        PAReachabilityTracerApp(IPSSABuilder iPSSABuilder, String string, String[] stringArray) {
            super(iPSSABuilder, string, stringArray);
        }
    }

    public static class IPSSAReachabilityTracerApp
    extends ReachabilityTracerApp {
        protected void printPath(String string, String string2) {
            SSADefinition sSADefinition;
            SSADefinition sSADefinition2;
            System.err.println("In printPath(" + string + ", " + string2 + ')');
            try {
                sSADefinition2 = AnalysisObjectSpec.IPSSAObjectSpec.create(this._builder, string).getDefinition();
                sSADefinition = AnalysisObjectSpec.IPSSAObjectSpec.create(this._builder, string2).getDefinition();
            }
            catch (AnalysisObjectSpec.UnknownAnalysisObjectExeption unknownAnalysisObjectExeption) {
                System.err.println(unknownAnalysisObjectExeption);
                return;
            }
            boolean bl = false;
            if (sSADefinition2 != null) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (sSADefinition != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            jq_Method jq_Method2 = sSADefinition2.getMethod();
            jq_Method jq_Method3 = sSADefinition.getMethod();
            if (_verbose) {
                System.err.println("Computing all paths between " + string + " in " + jq_Method2 + " and " + string2 + " in " + jq_Method3);
            }
            this.printPath(sSADefinition2, sSADefinition);
        }

        protected void printPath(SSADefinition sSADefinition, SSADefinition sSADefinition2) {
            System.err.println("Calculating paths between " + sSADefinition + " and " + sSADefinition2);
            Collection collection = ReachabilityTrace.Algorithms.collectReachabilityTraces(sSADefinition, sSADefinition2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ReachabilityTrace reachabilityTrace = (ReachabilityTrace)iterator.next();
                System.out.println("\t" + reachabilityTrace.toString());
            }
        }

        public IPSSAReachabilityTracerApp() {
            this(null, null, null);
        }

        IPSSAReachabilityTracerApp(IPSSABuilder iPSSABuilder, String string, String[] stringArray) {
            super(iPSSABuilder, string, stringArray);
        }
    }
}

