/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPA;

import Clazz.jq_Class;
import Clazz.jq_FakeInstanceMethod;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.Bytecodes;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Run_Time.Arrays;
import UTF.Utf8;
import Util.Assert;
import Util.Convert;
import Util.IO.ByteSequence;
import Util.IO.Textualizable;
import Util.IO.Textualizer;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class ProgramLocation
implements Textualizable {
    protected final jq_Method m;

    public jq_Class getContainingClass() {
        return this.m.getDeclaringClass();
    }

    public jq_Method getMethod() {
        return this.m;
    }

    public Utf8 getSourceFile() {
        return this.getContainingClass().getSourceFile();
    }

    public int getLineNumber() {
        return this.m.getLineNumber(this.getBytecodeIndex());
    }

    public String toStringLong() {
        return "" + this.getContainingClass() + '.' + this.getMethod().getName() + '(' + this.getSourceFile() + ':' + this.getLineNumber() + ')';
    }

    public abstract int getID();

    public abstract int getBytecodeIndex();

    public abstract jq_Type getResultType();

    public abstract void write(Textualizer var1) throws IOException;

    public void writeEdges(Textualizer textualizer) throws IOException {
    }

    public void addEdge(String string, Textualizable textualizable) {
    }

    public abstract boolean isCall();

    public abstract jq_Method getTargetMethod();

    public abstract jq_Type[] getParamTypes();

    public abstract jq_Type getReturnType();

    public abstract boolean isSingleTarget();

    public abstract boolean isInterfaceCall();

    public abstract byte getInvocationType();

    public static ProgramLocation read(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        if (string.equals("null")) {
            return null;
        }
        if (string.equals("fake")) {
            String string2 = stringTokenizer.nextToken().replace('_', ' ');
            jq_Method jq_Method2 = (jq_Method)jq_FakeInstanceMethod.read(stringTokenizer);
            if (jq_Method2 == null) {
                return null;
            }
            return new FakeProgramLocation(jq_Method2, string2);
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        jq_Method jq_Method3 = (jq_Method)jq_Method.read(stringTokenizer);
        if (jq_Method3 == null) {
            return null;
        }
        if (string.equals("bc")) {
            return new BCProgramLocation(jq_Method3, n);
        }
        if (string.equals("quad")) {
            if (jq_Method3.getBytecode() == null) {
                return null;
            }
            ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method3);
            QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
            while (quadIterator.hasNext()) {
                Quad quad = quadIterator.nextQuad();
                if (quad.getID() != n) continue;
                return new QuadProgramLocation(jq_Method3, quad);
            }
        }
        return null;
    }

    protected ProgramLocation(jq_Method jq_Method2) {
        this.m = jq_Method2;
    }

    public static class QuadProgramLocation
    extends ProgramLocation {
        private final Quad q;

        public Quad getQuad() {
            return this.q;
        }

        public int getID() {
            return this.q.getID();
        }

        public int getBytecodeIndex() {
            Map map = CodeCache.getBCMap(this.m);
            Integer n = (Integer)map.get(this.q);
            return n;
        }

        public jq_Type getResultType() {
            return this.q.getDefinedRegisters().getRegisterOperand(0).getType();
        }

        public boolean isCall() {
            return this.q.getOperator() instanceof Operator.Invoke;
        }

        public jq_Method getTargetMethod() {
            Assert._assert(this.isCall());
            return Operator.Invoke.getMethod(this.q).getMethod();
        }

        public jq_Type[] getParamTypes() {
            Assert._assert(this.isCall());
            jq_Type[] jq_TypeArray = Operator.Invoke.getMethod(this.q).getMethod().getParamTypes();
            if (jq_TypeArray.length != Operator.Invoke.getParamList(this.q).length()) {
                jq_TypeArray = new jq_Type[Operator.Invoke.getParamList(this.q).length()];
                int n = 0;
                while (n < jq_TypeArray.length) {
                    jq_TypeArray[n] = Operator.Invoke.getParamList(this.q).get(n).getType();
                    ++n;
                }
            }
            return jq_TypeArray;
        }

        public jq_Type getReturnType() {
            Assert._assert(this.isCall());
            return Operator.Invoke.getMethod(this.q).getMethod().getReturnType();
        }

        public boolean isSingleTarget() {
            if (this.isInterfaceCall()) {
                return false;
            }
            if (!((Operator.Invoke)this.q.getOperator()).isVirtual()) {
                return true;
            }
            jq_InstanceMethod jq_InstanceMethod2 = (jq_InstanceMethod)Operator.Invoke.getMethod(this.q).getMethod();
            jq_InstanceMethod2.getDeclaringClass().load();
            if (jq_InstanceMethod2.getDeclaringClass().isFinal()) {
                return true;
            }
            jq_InstanceMethod2.getDeclaringClass().prepare();
            if (!jq_InstanceMethod2.isLoaded()) {
                if (!(jq_InstanceMethod2 = jq_InstanceMethod2.resolve1()).isLoaded()) {
                    return false;
                }
                Operator.Invoke.getMethod(this.q).setMethod(jq_InstanceMethod2);
            }
            return !jq_InstanceMethod2.isVirtual();
        }

        public boolean isInterfaceCall() {
            return this.q.getOperator() instanceof Operator.Invoke.InvokeInterface;
        }

        public int hashCode() {
            return this.q == null ? -1 : this.q.hashCode();
        }

        public boolean equals(QuadProgramLocation quadProgramLocation) {
            boolean bl = false;
            if (this.q == quadProgramLocation.q) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof QuadProgramLocation) {
                return this.equals((QuadProgramLocation)object);
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m.getName());
            stringBuffer.append("() quad ");
            stringBuffer.append(this.q == null ? -1 : this.q.getID());
            if (this.q.getOperator() instanceof Operator.Invoke) {
                stringBuffer.append(" => ");
                stringBuffer.append(Operator.Invoke.getMethod(this.q).getMethod().getName());
                stringBuffer.append("()");
                if (this.isSingleTarget()) {
                    stringBuffer.append("*");
                }
            }
            return stringBuffer.toString();
        }

        public byte getInvocationType() {
            if (this.q.getOperator() instanceof Operator.Invoke.InvokeVirtual) {
                return 0;
            }
            if (this.q.getOperator() instanceof Operator.Invoke.InvokeStatic) {
                jq_Method jq_Method2 = Operator.Invoke.getMethod(this.q).getMethod();
                if (jq_Method2 instanceof jq_InstanceMethod) {
                    return 2;
                }
                return 1;
            }
            Assert._assert(this.q.getOperator() instanceof Operator.Invoke.InvokeInterface);
            return 3;
        }

        public void write(Textualizer textualizer) throws IOException {
            textualizer.writeBytes("quad " + this.q.getID() + ' ');
            textualizer.writeObject(this.m);
        }

        public QuadProgramLocation(jq_Method jq_Method2, Quad quad) {
            super(jq_Method2);
            this.q = quad;
        }
    }

    public static class BCProgramLocation
    extends ProgramLocation {
        final int bcIndex;

        public int getID() {
            return this.bcIndex;
        }

        public int getBytecodeIndex() {
            return this.bcIndex;
        }

        public byte getBytecode() {
            byte[] byArray = this.m.getBytecode();
            return byArray[this.bcIndex];
        }

        public jq_Type getResultType() {
            ByteSequence byteSequence = new ByteSequence(this.m.getBytecode(), this.bcIndex, 8);
            try {
                Bytecodes.Instruction instruction = Bytecodes.Instruction.readInstruction(this.getContainingClass().getCP(), byteSequence);
                if (!(instruction instanceof Bytecodes.TypedInstruction)) {
                    return null;
                }
                return ((Bytecodes.TypedInstruction)((Object)instruction)).getType();
            }
            catch (IOException iOException) {
                Assert.UNREACHABLE();
                return null;
            }
        }

        public boolean isCall() {
            switch (this.getBytecode()) {
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -59: {
                    return true;
                }
            }
            return false;
        }

        public jq_Method getTargetMethod() {
            jq_Class jq_Class2 = this.m.getDeclaringClass();
            byte[] byArray = this.m.getBytecode();
            char c = Convert.twoBytesToChar(byArray, this.bcIndex + 1);
            switch (byArray[this.bcIndex]) {
                case -74: 
                case -73: 
                case -71: {
                    return jq_Class2.getCPasInstanceMethod(c);
                }
                case -72: {
                    return jq_Class2.getCPasStaticMethod(c);
                }
                case -59: {
                    return Arrays._multinewarray;
                }
            }
            return null;
        }

        public jq_Type[] getParamTypes() {
            return this.getTargetMethod().getParamTypes();
        }

        public jq_Type getReturnType() {
            return this.getTargetMethod().getReturnType();
        }

        public boolean isSingleTarget() {
            switch (this.getBytecode()) {
                case -73: 
                case -72: 
                case -59: {
                    return true;
                }
            }
            return false;
        }

        public boolean isInterfaceCall() {
            boolean bl = false;
            if (this.getBytecode() == 185) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.m.hashCode() ^ this.bcIndex;
        }

        public boolean equals(BCProgramLocation bCProgramLocation) {
            boolean bl = false;
            if (this.bcIndex == bCProgramLocation.bcIndex && this.m == bCProgramLocation.m) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof BCProgramLocation) {
                return this.equals((BCProgramLocation)object);
            }
            return false;
        }

        public String toString() {
            String string = this.m.getName() + "() @ " + this.bcIndex;
            return string;
        }

        public byte getInvocationType() {
            switch (this.getBytecode()) {
                case -74: {
                    return 0;
                }
                case -73: {
                    return 2;
                }
                case -71: {
                    return 3;
                }
                case -72: 
                case -59: {
                    return 1;
                }
            }
            return -1;
        }

        public void write(Textualizer textualizer) throws IOException {
            textualizer.writeBytes("bc " + this.bcIndex + ' ');
            textualizer.writeObject(this.m);
        }

        public BCProgramLocation(jq_Method jq_Method2, int n) {
            super(jq_Method2);
            this.bcIndex = n;
        }
    }

    public static class FakeProgramLocation
    extends ProgramLocation {
        String label;

        public void write(Textualizer textualizer) throws IOException {
            textualizer.writeBytes("fake " + this.label.replace(' ', '_') + ' ');
            textualizer.writeObject(this.m);
        }

        public String toString() {
            String string = this.m.getName() + "() '" + this.label + '\'';
            return string;
        }

        public int getID() {
            return -1;
        }

        public int getBytecodeIndex() {
            return -1;
        }

        public jq_Type getResultType() {
            return null;
        }

        public boolean isCall() {
            return false;
        }

        public jq_Method getTargetMethod() {
            return null;
        }

        public jq_Type[] getParamTypes() {
            return null;
        }

        public jq_Type getReturnType() {
            return null;
        }

        public boolean isSingleTarget() {
            return false;
        }

        public boolean isInterfaceCall() {
            return false;
        }

        public byte getInvocationType() {
            return -1;
        }

        public FakeProgramLocation(jq_Method jq_Method2, String string) {
            super(jq_Method2);
            this.label = string;
        }
    }
}

