/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPA;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_Reference;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.LoadedCallGraph;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Main.HostedVM;
import Util.Collections.GenericMultiMap;
import Util.Collections.MultiMap;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.Graphs.SCCPathNumbering;
import Util.Graphs.Traversals;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectCreationGraph
extends QuadVisitor.EmptyVisitor
implements ControlFlowGraphVisitor,
BasicBlockVisitor,
Graph {
    boolean TRACE;
    PrintStream out;
    boolean MERGE_SITES;
    jq_Method currentMethod;
    Set roots;
    MultiMap succ;
    MultiMap pred;

    public Set getAllNodes() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.succ.keySet());
        hashSet.addAll(this.pred.keySet());
        return hashSet;
    }

    public Collection getRoots() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.succ.keySet());
        hashSet.removeAll(this.succ.values());
        hashSet.addAll(this.roots);
        while (true) {
            HashSet hashSet2 = new HashSet(this.succ.keySet());
            hashSet2.removeAll(Traversals.reversePostOrder(this.getNavigator(), hashSet));
            if (hashSet2.isEmpty()) break;
            Object k = hashSet2.iterator().next();
            if (this.TRACE) {
                System.out.println("Breaking cycle: choosing " + k);
            }
            hashSet.add(k);
        }
        if (this.TRACE) {
            System.out.println("Roots = " + this.roots);
        }
        return hashSet;
    }

    public Navigator getNavigator() {
        return new Nav();
    }

    public void visitMethodSummary(MethodSummary methodSummary) {
        Iterator iterator = methodSummary.nodeIterator();
        while (iterator.hasNext()) {
            MethodSummary.Node node = (MethodSummary.Node)iterator.next();
            this.visitNode(node);
        }
    }

    public void visitNode(MethodSummary.Node node) {
        jq_Reference jq_Reference2;
        if ((node instanceof MethodSummary.ConcreteTypeNode || node instanceof MethodSummary.UnknownTypeNode || node instanceof MethodSummary.ConcreteObjectNode) && (jq_Reference2 = node.getDeclaredType()) != null) {
            jq_Class jq_Class2 = this.currentMethod.isStatic() ? null : this.currentMethod.getDeclaringClass();
            this.addEdge((jq_Reference)jq_Class2, node, jq_Reference2);
        }
    }

    public void visitCFG(ControlFlowGraph controlFlowGraph) {
        this.currentMethod = controlFlowGraph.getMethod();
        controlFlowGraph.visitBasicBlocks(this);
    }

    public void visitBasicBlock(BasicBlock basicBlock) {
        basicBlock.visitQuads(this);
    }

    public void visitNew(Quad quad) {
        jq_Class jq_Class2 = this.currentMethod.isStatic() ? null : this.currentMethod.getDeclaringClass();
        jq_Reference jq_Reference2 = (jq_Reference)Operator.New.getType(quad).getType();
        ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.currentMethod, quad);
        this.addEdge((jq_Reference)jq_Class2, quadProgramLocation, jq_Reference2);
    }

    public void visitNewArray(Quad quad) {
        jq_Class jq_Class2 = this.currentMethod.isStatic() ? null : this.currentMethod.getDeclaringClass();
        jq_Reference jq_Reference2 = (jq_Reference)Operator.NewArray.getType(quad).getType();
        ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.currentMethod, quad);
        this.addEdge((jq_Reference)jq_Class2, quadProgramLocation, jq_Reference2);
    }

    public void addRoot(jq_Class jq_Class2) {
        if (this.TRACE) {
            this.out.println("Adding root " + jq_Class2);
        }
        this.roots.add(jq_Class2);
    }

    public void addEdge(jq_Reference jq_Reference2, MethodSummary.Node node, jq_Reference jq_Reference3) {
        if (this.MERGE_SITES || node == null) {
            if (this.TRACE) {
                this.out.println("Adding edge " + jq_Reference2 + " -> " + jq_Reference3);
            }
            this.succ.add(jq_Reference2, jq_Reference3);
            this.pred.add(jq_Reference3, jq_Reference2);
        } else {
            if (this.TRACE) {
                this.out.println("Adding edge " + jq_Reference2 + " -> " + node + " -> " + jq_Reference3);
            }
            this.succ.add(jq_Reference2, node);
            this.succ.add(node, jq_Reference3);
            this.pred.add(jq_Reference3, node);
            this.pred.add(node, jq_Reference2);
        }
    }

    public void addEdge(jq_Reference jq_Reference2, ProgramLocation programLocation, jq_Reference jq_Reference3) {
        if (this.MERGE_SITES || programLocation == null) {
            if (this.TRACE) {
                this.out.println("Adding edge " + jq_Reference2 + " -> " + jq_Reference3);
            }
            this.succ.add(jq_Reference2, jq_Reference3);
            this.pred.add(jq_Reference3, jq_Reference2);
        } else {
            if (this.TRACE) {
                this.out.println("Adding edge " + jq_Reference2 + " -> " + programLocation + " -> " + jq_Reference3);
            }
            this.succ.add(jq_Reference2, programLocation);
            this.succ.add(programLocation, jq_Reference3);
            this.pred.add(jq_Reference3, programLocation);
            this.pred.add(programLocation, jq_Reference2);
        }
    }

    public void handleCallGraph(CallGraph callGraph) {
        this.addRoot(null);
        int n = 0;
        Iterator iterator = callGraph.getAllMethods().iterator();
        while (iterator.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)iterator.next();
            if (jq_Method2.getBytecode() != null) {
                ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
                this.visitCFG(controlFlowGraph);
                if (n % 100 == 0) {
                    System.out.print("Visited methods: " + n + '\r');
                }
            }
            ++n;
        }
        System.out.println("Visited methods: " + n);
    }

    public static void main(String[] stringArray) throws IOException {
        HostedVM.initialize();
        CodeCache.AlwaysMap = true;
        ObjectCreationGraph objectCreationGraph = new ObjectCreationGraph();
        String string = System.getProperty("callgraph", "callgraph");
        System.out.println("Loading from callgraph \"" + string + '\"');
        LoadedCallGraph loadedCallGraph = new LoadedCallGraph(string);
        objectCreationGraph.handleCallGraph(loadedCallGraph);
        SCCPathNumbering sCCPathNumbering = new SCCPathNumbering();
        BigInteger bigInteger = sCCPathNumbering.countPaths(objectCreationGraph);
        System.out.println("Number of paths: " + ((Number)bigInteger).longValue());
        Object object = Traversals.reversePostOrder(objectCreationGraph.getNavigator(), null).iterator();
        while (object.hasNext()) {
            Object e = object.next();
            long l = sCCPathNumbering.numberOfPathsTo(e).longValue();
            if (l <= 1L) continue;
            System.out.println(l + " paths to " + e);
        }
        object = new DataOutputStream(new FileOutputStream("creation_graph.dot"));
        sCCPathNumbering.dotGraph((DataOutput)object, objectCreationGraph.getRoots(), objectCreationGraph.getNavigator());
        ((FilterOutputStream)object).close();
    }

    private final /* synthetic */ void this() {
        this.TRACE = false;
        this.out = System.out;
        this.MERGE_SITES = System.getProperty("os.merge", "no").equals("no") ^ true;
        this.roots = new HashSet();
        this.succ = new GenericMultiMap();
        this.pred = new GenericMultiMap();
    }

    public ObjectCreationGraph() {
        this.this();
    }

    class Nav
    implements Navigator {
        public Collection next(Object object) {
            return ObjectCreationGraph.this.succ.getValues(object);
        }

        public Collection prev(Object object) {
            return ObjectCreationGraph.this.pred.getValues(object);
        }

        Nav() {
        }
    }
}

