/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPA;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.LoadedCallGraph;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Main.Helper;
import Util.Assert;
import Util.Graphs.SCCTopSortedGraph;
import Util.Graphs.SCComponent;
import Util.Graphs.Traversals;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LoopAnalysis
implements ControlFlowGraphVisitor {
    CallGraph cg;
    jq_Method caller;
    Set visitedMethods;
    Set loopMethods;
    Set loopBB;
    InvokeVisitor invoke_visitor;

    public static void main(String[] stringArray) throws IOException {
        jq_Class jq_Class2 = (jq_Class)Helper.load(stringArray[0]);
        CodeCache.AlwaysMap = true;
        LoadedCallGraph loadedCallGraph = new LoadedCallGraph("callgraph");
        LoopAnalysis loopAnalysis = new LoopAnalysis(loadedCallGraph);
        Helper.runPass(jq_Class2, (ControlFlowGraphVisitor)loopAnalysis);
        System.out.println("Visited methods: " + loopAnalysis.visitedMethods);
        System.out.println("Loop methods: " + loopAnalysis.loopMethods);
        System.out.println("Loop BB: " + loopAnalysis.loopBB);
    }

    public void visitCFG(ControlFlowGraph controlFlowGraph) {
        this.caller = controlFlowGraph.getMethod();
        if (this.visitedMethods.contains(this.caller)) {
            return;
        }
        this.visitedMethods.add(this.caller);
        Set set = SCComponent.buildSCC(controlFlowGraph);
        SCCTopSortedGraph sCCTopSortedGraph = SCCTopSortedGraph.topSort(set);
        Iterator iterator = Traversals.reversePostOrder(sCCTopSortedGraph.getNavigator(), set).iterator();
        while (iterator.hasNext()) {
            SCComponent sCComponent = (SCComponent)iterator.next();
            if (!sCComponent.isLoop()) continue;
            Iterator iterator2 = sCComponent.nodeSet().iterator();
            while (iterator2.hasNext()) {
                BasicBlock basicBlock = (BasicBlock)iterator2.next();
                this.loopBB.add(basicBlock);
                if (this.cg == null) continue;
                basicBlock.visitQuads(this.invoke_visitor);
            }
        }
    }

    public boolean isInLoop(jq_Method jq_Method2, BasicBlock basicBlock) {
        if (this.loopMethods.contains(jq_Method2)) {
            return true;
        }
        if (!this.visitedMethods.contains(jq_Method2)) {
            this.visitCFG(CodeCache.getCode(jq_Method2));
            if (this.loopMethods.contains(jq_Method2)) {
                return true;
            }
        }
        return this.loopBB.contains(basicBlock);
    }

    private final /* synthetic */ void this() {
        this.visitedMethods = new HashSet();
        this.loopMethods = new HashSet();
        this.loopBB = new HashSet();
        this.invoke_visitor = new InvokeVisitor();
    }

    public LoopAnalysis() {
        this.this();
    }

    public LoopAnalysis(CallGraph callGraph) {
        this.this();
        this.cg = callGraph;
    }

    public class InvokeVisitor
    extends QuadVisitor.EmptyVisitor {
        public void visitInvoke(Quad quad) {
            super.visitInvoke(quad);
            boolean bl = false;
            if (LoopAnalysis.this.caller != null) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (quad != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            ProgramLocation programLocation = new ProgramLocation.QuadProgramLocation(LoopAnalysis.this.caller, quad);
            LinkedList<ProgramLocation.QuadProgramLocation> linkedList = new LinkedList<ProgramLocation.QuadProgramLocation>();
            linkedList.add((ProgramLocation.QuadProgramLocation)programLocation);
            while (!linkedList.isEmpty()) {
                programLocation = (ProgramLocation)linkedList.removeFirst();
                Collection collection = LoopAnalysis.this.cg.getTargetMethods(programLocation);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    jq_Method jq_Method2 = (jq_Method)iterator.next();
                    boolean bl3 = LoopAnalysis.this.loopMethods.add(jq_Method2);
                    if (!bl3) continue;
                    linkedList.addAll(LoopAnalysis.this.cg.getCallSites(jq_Method2));
                }
            }
        }
    }
}

