/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.FlowInsensitive;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_FakeInstanceMethod;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Analysis.IPA.LoopAnalysis;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BytecodeToQuad;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.JSRInfo;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Compil3r.Quad.RegisterFactory;
import Main.HostedVM;
import Memory.Address;
import Run_Time.Arrays;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import Scheduler.jq_Thread;
import Util.Assert;
import Util.Collections.FilterIterator;
import Util.Collections.FlattenedCollection;
import Util.Collections.HashCodeComparator;
import Util.Collections.IdentityHashCodeWrapper;
import Util.Collections.IndexMap;
import Util.Collections.MultiMap;
import Util.Collections.Pair;
import Util.Collections.SetFactory;
import Util.Collections.SortedArraySet;
import Util.Graphs.Navigator;
import Util.IO.Textualizable;
import Util.IO.Textualizer;
import Util.Strings;
import Util.Templates.List;
import Util.Templates.ListIterator;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MethodSummary {
    public static PrintStream out = System.out;
    public static boolean TRACE_INTRA;
    public static boolean TRACE_INTER;
    public static boolean TRACE_INST;
    public static final boolean IGNORE_INSTANCE_FIELDS = false;
    public static final boolean IGNORE_STATIC_FIELDS = false;
    public static final boolean VERIFY_ASSERTIONS = false;
    public static final boolean USE_IDENTITY_HASHCODE = false;
    public static final boolean DETERMINISTIC = true;
    public static final boolean SPLIT_THREADS = true;
    public static HashMap summary_cache;
    public static HashMap clone_cache;
    public static final boolean USE_PARAMETER_MAP = true;
    public static boolean CACHE_BUILDER;
    public static final boolean UNIFY_ACCESS_PATHS = false;
    public static final boolean DUMP_DOTGRAPH;
    private static HashMap fakeCache;
    private static HashSet identityMethods;
    public static String fakeCloneName;
    final jq_Method method;
    final ParamNode[] params;
    final Map nodes;
    final Set returned;
    final Set thrown;
    GlobalNode global;
    final Set calls;
    final Map callToRVN;
    final Map callToTEN;
    final Map castMap;
    final Set castPredecessors;
    final Map sync_ops;
    BuildMethodSummary builder;
    final Map passedParamToNodes;

    public static MethodSummary getSummary(ControlFlowGraph controlFlowGraph) {
        MethodSummary methodSummary = (MethodSummary)summary_cache.get(controlFlowGraph);
        if (methodSummary == null) {
            if (TRACE_INTER) {
                out.println("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
            }
            if (TRACE_INTER) {
                out.println("Building summary for " + controlFlowGraph.getMethod());
            }
            try {
                BuildMethodSummary buildMethodSummary = new BuildMethodSummary(controlFlowGraph);
                methodSummary = buildMethodSummary.getSummary();
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Runtime exception when getting method summary for " + controlFlowGraph.getMethod());
                throw runtimeException;
            }
            catch (Error error) {
                System.err.println("Error when getting method summary for " + controlFlowGraph.getMethod());
                throw error;
            }
            summary_cache.put(controlFlowGraph, methodSummary);
            if (TRACE_INTER) {
                out.println("Summary for " + controlFlowGraph.getMethod() + ':');
            }
            if (TRACE_INTER) {
                out.println(methodSummary);
            }
            if (TRACE_INTER) {
                out.println("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
            }
        }
        return methodSummary;
    }

    public static MethodSummary getSummary(jq_Method jq_Method2) {
        MethodSummary methodSummary = MethodSummary.fakeMethodSummary(jq_Method2);
        if (methodSummary != null) {
            return methodSummary;
        }
        if (jq_Method2.getBytecode() == null) {
            return null;
        }
        return MethodSummary.getSummary(CodeCache.getCode(jq_Method2));
    }

    public static void clearSummaryCache() {
        summary_cache.clear();
        ConcreteTypeNode.FACTORY.clear();
        UnknownTypeNode.FACTORY.clear();
        GlobalNode.GLOBAL = new GlobalNode(null);
    }

    public static MethodSummary getSummary(ControlFlowGraph controlFlowGraph, CallSite callSite) {
        MethodSummary methodSummary;
        if (clone_cache != null && (methodSummary = (MethodSummary)clone_cache.get(new Pair(controlFlowGraph, callSite))) != null) {
            return methodSummary;
        }
        return MethodSummary.getSummary(controlFlowGraph);
    }

    public GlobalNode getGlobal() {
        return this.global;
    }

    public ParamNode getParamNode(int n) {
        return this.params[n];
    }

    public int getNumOfParams() {
        return this.params.length;
    }

    public Set getCalls() {
        return this.calls;
    }

    public void getNodesThatCall(PassedParameter passedParameter, Set set) {
        Set set2 = (Set)this.passedParamToNodes.get(passedParameter);
        if (set2 == null) {
            return;
        }
        set.addAll(set2);
    }

    public Set getNodesThatCall(ProgramLocation programLocation, int n) {
        return this.getNodesThatCall(new PassedParameter(programLocation, n));
    }

    public Set getNodesThatCall(PassedParameter passedParameter) {
        Set set = (Set)this.passedParamToNodes.get(passedParameter);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public void mergeGlobal() {
        if (this.global == null) {
            return;
        }
        Set<GlobalNode> set = Collections.singleton(GlobalNode.GLOBAL);
        this.global.replaceBy(set, true);
        this.nodes.remove(this.global);
        this.unifyAccessPaths(new LinkedHashSet<GlobalNode>(set));
        this.global = null;
    }

    public static boolean addToMultiMap(HashMap hashMap, Object object, Object object2) {
        Set set = (Set)hashMap.get(object);
        if (set == null) {
            set = NodeSet.FACTORY.makeSet();
            hashMap.put(object, set);
        }
        return set.add(object2);
    }

    public static boolean addToMultiMap(HashMap hashMap, Object object, Set set) {
        Set set2 = (Set)hashMap.get(object);
        if (set2 == null) {
            set2 = NodeSet.FACTORY.makeSet();
            hashMap.put(object, set2);
        }
        return set2.addAll(set);
    }

    static Set get_mapping(HashMap hashMap, Node node) {
        Set set = (Set)hashMap.get(node);
        if (set != null) {
            return set;
        }
        set = NodeSet.FACTORY.makeSet();
        set.add(node);
        return set;
    }

    public MethodSummary copy() {
        Object object;
        Object object2;
        LinkedHashMap linkedHashMap;
        Object object3;
        Object object4;
        ParamNode[] paramNodeArray;
        Object object5;
        Object object6;
        if (TRACE_INTRA) {
            out.println("Copying summary: " + this);
        }
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        Object object7 = this.nodeIterator();
        while (object7.hasNext()) {
            object6 = (Node)object7.next();
            object5 = ((Node)object6).copy();
            hashMap.put((Node)object6, (Node)object5);
        }
        object7 = this.nodeIterator();
        while (object7.hasNext()) {
            object6 = (Node)object7.next();
            object5 = (Node)hashMap.get(object6);
            ((Node)object5).update(hashMap);
        }
        object7 = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
        object7.addAll(this.calls);
        object6 = NodeSet.FACTORY.makeSet();
        object5 = this.returned.iterator();
        while (object5.hasNext()) {
            paramNodeArray = (Node)object5.next();
            object4 = (Node)hashMap.get(paramNodeArray);
            if (paramNodeArray instanceof UnknownTypeNode) {
                object4 = paramNodeArray;
            }
            boolean bl = false;
            if (object4 != null) {
                bl = true;
            }
            Assert._assert(bl);
            object6.add(object4);
        }
        object5 = NodeSet.FACTORY.makeSet();
        paramNodeArray = this.thrown.iterator();
        while (paramNodeArray.hasNext()) {
            object4 = (Node)paramNodeArray.next();
            object3 = (Node)hashMap.get(object4);
            if (object4 instanceof UnknownTypeNode) {
                object3 = object4;
            }
            boolean bl = false;
            if (object3 != null) {
                bl = true;
            }
            Assert._assert(bl);
            object5.add(object3);
        }
        paramNodeArray = new ParamNode[this.params.length];
        int n = 0;
        while (n < paramNodeArray.length) {
            if (this.params[n] != null) {
                paramNodeArray[n] = (ParamNode)hashMap.get(this.params[n]);
            }
            ++n;
        }
        HashMap hashMap2 = new HashMap();
        object3 = this.callToRVN.entrySet().iterator();
        while (object3.hasNext()) {
            linkedHashMap = object3.next();
            object2 = (ProgramLocation)linkedHashMap.getKey();
            object = linkedHashMap.getValue();
            if (object != null) {
                object = hashMap.get(object);
                boolean bl = false;
                if (object != null) {
                    bl = true;
                }
                Assert._assert(bl, ((Object)linkedHashMap).toString());
            }
            hashMap2.put((ProgramLocation)object2, object);
        }
        object3 = new HashMap();
        linkedHashMap = this.callToTEN.entrySet().iterator();
        while (linkedHashMap.hasNext()) {
            object2 = (Map.Entry)linkedHashMap.next();
            object = (ProgramLocation)object2.getKey();
            Object v = object2.getValue();
            if (v != null) {
                v = hashMap.get(v);
                boolean bl = false;
                if (v != null) {
                    bl = true;
                }
                Assert._assert(bl, object2.toString());
            }
            ((HashMap)object3).put(object, v);
        }
        linkedHashMap = new LinkedHashMap();
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            boolean bl = false;
            if (object.getValue() != GlobalNode.GLOBAL) {
                bl = true;
            }
            Assert._assert(bl);
            Assert._assert(object.getValue() instanceof UnknownTypeNode ^ true);
            linkedHashMap.put(object.getValue(), object.getValue());
        }
        object2 = null;
        object2 = new HashMap(this.passedParamToNodes);
        Node.updateMap(hashMap, object2.entrySet().iterator(), (Map)object2);
        object = new MethodSummary(this.builder, this.method, paramNodeArray, (Set)object7, hashMap2, (Map)object3, this.castMap, this.castPredecessors, (Map)object2, this.sync_ops, (Set)object6, (Set)object5, linkedHashMap);
        return object;
    }

    public void unifyAccessPaths(Set set) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object = set.iterator();
        while (object.hasNext()) {
            linkedList.add(object.next());
        }
        while (!linkedList.isEmpty()) {
            FieldNode fieldNode;
            Map.Entry entry;
            object = (Node)linkedList.removeFirst();
            if (object instanceof UnknownTypeNode) continue;
            this.unifyAccessPathEdges((Node)object);
            Iterator iterator = ((Node)object).getAccessPathEdges().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                fieldNode = (FieldNode)entry.getValue();
                boolean bl = false;
                if (fieldNode != null) {
                    bl = true;
                }
                Assert._assert(bl);
                if (set.contains(fieldNode)) continue;
                linkedList.add(fieldNode);
                set.add(fieldNode);
            }
            iterator = ((Node)object).getNonEscapingEdges().iterator();
            while (iterator.hasNext()) {
                Object object2;
                entry = (Map.Entry)iterator.next();
                fieldNode = entry.getValue();
                if (fieldNode instanceof Node) {
                    object2 = fieldNode;
                    boolean bl = false;
                    if (object2 != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    if (set.contains(object2)) continue;
                    linkedList.add(object2);
                    set.add(object2);
                    continue;
                }
                object2 = NodeSet.FACTORY.makeSet((Set)((Object)fieldNode));
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    boolean bl = false;
                    if (e != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    if (!set.contains(e)) continue;
                    iterator2.remove();
                }
                if (object2.isEmpty()) continue;
                linkedList.addAll((Collection<Object>)object2);
                set.addAll(object2);
            }
        }
    }

    public void unifyAccessPathEdges(Node node) {
        if (node instanceof UnknownTypeNode) {
            return;
        }
        if (TRACE_INTRA) {
            out.println("Unifying access path edges from: " + node);
        }
        if (node.accessPathEdges != null) {
            Iterator iterator = node.accessPathEdges.entrySet().iterator();
            while (iterator.hasNext()) {
                FieldNode fieldNode;
                Map.Entry entry = iterator.next();
                jq_Field jq_Field2 = (jq_Field)entry.getKey();
                Object v = entry.getValue();
                boolean bl = false;
                if (v != null) {
                    bl = true;
                }
                Assert._assert(bl);
                if (v instanceof FieldNode) {
                    fieldNode = (FieldNode)v;
                    continue;
                }
                Set set = NodeSet.FACTORY.makeSet((Set)v);
                if (set.size() == 0) {
                    iterator.remove();
                    continue;
                }
                if (set.size() == 1) {
                    fieldNode = (FieldNode)set.iterator().next();
                    entry.setValue(fieldNode);
                    continue;
                }
                if (TRACE_INTRA) {
                    out.println("Node " + node + " has duplicate access path edges on field " + jq_Field2 + ": " + set);
                }
                fieldNode = FieldNode.unify(jq_Field2, set);
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    FieldNode fieldNode2 = (FieldNode)iterator2.next();
                    if (this.returned.contains(fieldNode2)) {
                        this.returned.remove(fieldNode2);
                        this.returned.add(fieldNode);
                    }
                    if (this.thrown.contains(fieldNode2)) {
                        this.thrown.remove(fieldNode2);
                        this.thrown.add(fieldNode);
                    }
                    this.nodes.remove(fieldNode2);
                }
                this.nodes.put(fieldNode, fieldNode);
                entry.setValue(fieldNode);
            }
        }
    }

    public static void instantiate(MethodSummary methodSummary, ProgramLocation programLocation, MethodSummary methodSummary2, boolean bl) {
        Object object;
        Object object2;
        Set<Object> set;
        Object object3;
        Object object4;
        methodSummary2 = methodSummary2.copy();
        if (TRACE_INST) {
            out.println("Instantiating " + methodSummary2 + " into " + methodSummary + ", mc=" + programLocation + " remove call=" + bl);
        }
        Assert._assert(methodSummary.calls.contains(programLocation));
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (TRACE_INST) {
            out.println("Adding global node to map: " + GlobalNode.GLOBAL.toString_long());
        }
        hashMap.put(GlobalNode.GLOBAL, GlobalNode.GLOBAL);
        if (TRACE_INST) {
            out.println("Initializing map with " + methodSummary2.params.length + " parameters");
        }
        int n = 0;
        while (n < methodSummary2.params.length) {
            object4 = methodSummary2.params[n];
            if (object4 != null) {
                object3 = new PassedParameter(programLocation, n);
                set = methodSummary.getNodesThatCall((PassedParameter)object3);
                if (TRACE_INST) {
                    out.println("Adding param node to map: " + ((ParamNode)object4).toString_long() + " maps to " + set);
                }
                hashMap.put(object4, set);
                if (bl) {
                    if (TRACE_INST) {
                        out.println("Removing " + object4 + " from nodes " + set);
                    }
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        object = (Node)object2.next();
                        ((Node)object).passedParameters.remove(object3);
                    }
                    methodSummary.passedParamToNodes.remove(object3);
                }
            }
            ++n;
        }
        if (TRACE_INST) {
            out.println("Adding all callee calls: " + methodSummary2.calls);
        }
        methodSummary.calls.addAll(methodSummary2.calls);
        Iterator iterator = methodSummary2.callToRVN.entrySet().iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = (ProgramLocation)object4.getKey();
            set = object4.getValue();
            if (TRACE_INST) {
                out.println("Adding rvn for callee call: " + set);
            }
            object2 = methodSummary.callToRVN.get(object3);
            boolean bl2 = false;
            if (object2 == null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            methodSummary.callToRVN.put(object3, set);
        }
        iterator = methodSummary2.callToTEN.entrySet().iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            object3 = (ProgramLocation)object4.getKey();
            set = object4.getValue();
            if (TRACE_INST) {
                out.println("Adding ten for callee call: " + set);
            }
            object2 = methodSummary.callToTEN.get(object3);
            boolean bl3 = false;
            if (object2 == null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            methodSummary.callToTEN.put(object3, set);
        }
        if (TRACE_INST) {
            out.println("Replacing formal parameters with actuals");
        }
        int n2 = 0;
        while (n2 < methodSummary2.params.length) {
            object4 = methodSummary2.params[n2];
            if (object4 != null) {
                object3 = (Set)hashMap.get(object4);
                if (TRACE_INST) {
                    out.println("Replacing " + object4 + " by " + object3);
                }
                ((Node)object4).replaceBy((Set)object3, bl);
                if (methodSummary2.returned.contains(object4)) {
                    if (TRACE_INST) {
                        out.println(object4 + " is returned, updating callee returned set");
                    }
                    if (bl) {
                        methodSummary2.returned.remove(object4);
                    }
                    methodSummary2.returned.addAll(object3);
                }
                if (methodSummary2.thrown.contains(object4)) {
                    if (TRACE_INST) {
                        out.println(object4 + " is thrown, updating callee thrown set");
                    }
                    if (bl) {
                        methodSummary2.thrown.remove(object4);
                    }
                    methodSummary2.thrown.addAll(object3);
                }
                if (bl) {
                    methodSummary2.nodes.remove(object4);
                }
            }
            ++n2;
        }
        ReturnValueNode returnValueNode = methodSummary.getRVN(programLocation);
        if (returnValueNode != null) {
            if (TRACE_INST) {
                out.println("Replacing return value " + returnValueNode + " by " + methodSummary2.returned);
            }
            returnValueNode.replaceBy(methodSummary2.returned, bl);
            if (methodSummary.returned.contains(returnValueNode)) {
                if (TRACE_INST) {
                    out.println(returnValueNode + " is returned, updating returned set");
                }
                if (bl) {
                    methodSummary.returned.remove(returnValueNode);
                }
                methodSummary.returned.addAll(methodSummary2.returned);
            }
            if (methodSummary.thrown.contains(returnValueNode)) {
                if (TRACE_INST) {
                    out.println(returnValueNode + " is thrown, updating thrown set");
                }
                if (bl) {
                    methodSummary.thrown.remove(returnValueNode);
                }
                methodSummary.thrown.addAll(methodSummary2.returned);
            }
            if (bl) {
                if (TRACE_INST) {
                    out.println("Removing old return value node " + returnValueNode + " from nodes list");
                }
                methodSummary.nodes.remove(returnValueNode);
            }
        }
        if ((object4 = methodSummary.getTEN(programLocation)) != null) {
            if (TRACE_INST) {
                out.println("Replacing thrown exception " + object4 + " by " + methodSummary2.thrown);
            }
            ((Node)object4).replaceBy(methodSummary2.thrown, bl);
            if (methodSummary.returned.contains(object4)) {
                if (TRACE_INST) {
                    out.println(object4 + " is returned, updating caller returned set");
                }
                if (bl) {
                    methodSummary.returned.remove(object4);
                }
                methodSummary.returned.addAll(methodSummary2.thrown);
            }
            if (methodSummary.thrown.contains(object4)) {
                if (TRACE_INST) {
                    out.println(object4 + " is thrown, updating caller thrown set");
                }
                if (bl) {
                    methodSummary.thrown.remove(object4);
                }
                methodSummary.thrown.addAll(methodSummary2.thrown);
            }
            if (bl) {
                if (TRACE_INST) {
                    out.println("Removing old thrown exception node " + object4 + " from nodes list");
                }
                methodSummary.nodes.remove(object4);
            }
        }
        if (TRACE_INST) {
            out.println("Adding all callee nodes: " + methodSummary2.nodes);
        }
        methodSummary.nodes.putAll(methodSummary2.nodes);
        if (TRACE_INST) {
            out.println("Building a root set for access path unification");
        }
        object3 = NodeSet.FACTORY.makeSet();
        object3.addAll(methodSummary2.returned);
        object3.addAll(methodSummary2.thrown);
        int n3 = 0;
        while (n3 < methodSummary2.params.length) {
            object2 = methodSummary2.params[n3];
            if (object2 != null) {
                object = (Set)hashMap.get(object2);
                object3.addAll(object);
            }
            ++n3;
        }
        if (TRACE_INST) {
            out.println("Root set: " + object3);
        }
        methodSummary.unifyAccessPaths((Set)object3);
        if (bl) {
            if (TRACE_INST) {
                out.println("Removing instantiated call: " + programLocation);
            }
            methodSummary.calls.remove(programLocation);
            methodSummary.callToRVN.remove(programLocation);
            methodSummary.callToTEN.remove(programLocation);
        }
    }

    public jq_Method getMethod() {
        return this.method;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Summary for ");
        stringBuffer.append(this.method.toString());
        stringBuffer.append(':');
        stringBuffer.append(Strings.lineSep);
        Iterator iterator = this.nodes.keySet().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            stringBuffer.append(node.toString_long());
            stringBuffer.append(Strings.lineSep);
        }
        if (this.returned != null && !this.returned.isEmpty()) {
            stringBuffer.append("Returned: ");
            stringBuffer.append(this.returned);
            stringBuffer.append(Strings.lineSep);
        }
        if (this.thrown != null && !this.thrown.isEmpty()) {
            stringBuffer.append("Thrown: ");
            stringBuffer.append(this.thrown);
            stringBuffer.append(Strings.lineSep);
        }
        if (this.calls != null && !this.calls.isEmpty()) {
            stringBuffer.append("Calls: ");
            stringBuffer.append(this.calls);
            stringBuffer.append(Strings.lineSep);
        }
        return stringBuffer.toString();
    }

    private final boolean addIfUseful(HashSet hashSet, HashSet hashSet2, Node node) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (hashSet2.contains(node)) {
            return true;
        }
        hashSet2.add(node);
        if (hashSet.contains(node)) {
            return this.nodes.containsKey(node);
        }
        hashSet.add(node);
        boolean bl = false;
        if (this.nodes.containsKey(node)) {
            if (TRACE_INTER) {
                out.println("Useful: " + node);
            }
            bl = true;
        }
        if (node instanceof UnknownTypeNode) {
            hashSet2.remove(node);
            return true;
        }
        if (node.addedEdges != null) {
            if (TRACE_INTER) {
                out.println("Useful because of added edge: " + node);
            }
            bl = true;
            object4 = node.getNonEscapingEdgeTargets().iterator();
            while (object4.hasNext()) {
                this.addAsUseful(hashSet, hashSet2, (Node)object4.next());
            }
        }
        if (node.accessPathEdges != null) {
            object4 = node.accessPathEdges.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = object3.getValue();
                if (object2 instanceof Node) {
                    if (this.addIfUseful(hashSet, hashSet2, (Node)object2)) {
                        if (TRACE_INTER && !bl) {
                            out.println("Useful because outside edge: " + node + "->" + object2);
                        }
                        bl = true;
                        continue;
                    }
                    if (node == object2) continue;
                    object4.remove();
                    continue;
                }
                object = ((Set)object2).iterator();
                while (object.hasNext()) {
                    Node node2 = (Node)object.next();
                    if (this.addIfUseful(hashSet, hashSet2, node2)) {
                        if (TRACE_INTER && !bl) {
                            out.println("Useful because outside edge: " + node + "->" + node2);
                        }
                        bl = true;
                        continue;
                    }
                    if (node == node2) continue;
                    object.remove();
                }
                if (bl) continue;
                object4.remove();
            }
        }
        if (this.castPredecessors.contains(node)) {
            object4 = this.castMap.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                object2 = (Node)((Pair)object3.getKey()).left;
                object = (CheckCastNode)object3.getValue();
                if (node != object2 || !this.addIfUseful(hashSet, hashSet2, (Node)object)) continue;
                bl = true;
            }
        }
        if (node instanceof ReturnedNode) {
            if (TRACE_INTER && !bl) {
                out.println("Useful because ReturnedNode: " + node);
            }
            bl = true;
        }
        if (node.predecessors != null) {
            bl = true;
            if (TRACE_INTER && !bl) {
                out.println("Useful because target of added edge: " + node);
            }
            object4 = node.getPredecessorTargets().iterator();
            while (object4.hasNext()) {
                this.addAsUseful(hashSet, hashSet2, (Node)object4.next());
            }
        }
        if (bl) {
            this.nodes.put(node, node);
            if (node instanceof FieldNode) {
                object4 = (FieldNode)node;
                object3 = ((FieldNode)object4).getAccessPathPredecessors().iterator();
                while (object3.hasNext()) {
                    this.addAsUseful(hashSet, hashSet2, (Node)object3.next());
                }
            }
            if (node instanceof CheckCastNode) {
                object4 = ((ProgramLocation.QuadProgramLocation)((CheckCastNode)node).getLocation()).getQuad();
                object3 = this.castPredecessors.iterator();
                while (object3.hasNext()) {
                    object2 = (Node)object3.next();
                    object = (CheckCastNode)this.castMap.get(new Pair(object2, object4));
                    if (object == null) continue;
                    this.addAsUseful(hashSet, hashSet2, (Node)object2);
                }
            }
        }
        if (TRACE_INTER && !bl) {
            out.println("Not useful: " + node);
        }
        hashSet2.remove(node);
        return bl;
    }

    private final void addAsUseful(HashSet hashSet, HashSet hashSet2, Node node) {
        Object object;
        Object object2;
        if (hashSet2.contains(node)) {
            return;
        }
        hashSet2.add(node);
        if (hashSet.contains(node)) {
            return;
        }
        if (node instanceof UnknownTypeNode) {
            hashSet2.remove(node);
            return;
        }
        hashSet.add(node);
        this.nodes.put(node, node);
        if (TRACE_INTER) {
            out.println("Useful: " + node);
        }
        Object object3 = node.getNonEscapingEdgeTargets().iterator();
        while (object3.hasNext()) {
            this.addAsUseful(hashSet, hashSet2, (Node)object3.next());
        }
        if (node.accessPathEdges != null) {
            object3 = node.accessPathEdges.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = object2.getValue();
                if (object instanceof Node) {
                    if (this.addIfUseful(hashSet, hashSet2, (Node)object)) continue;
                    object3.remove();
                    continue;
                }
                boolean bl = false;
                Iterator iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    if (!this.addIfUseful(hashSet, hashSet2, node2)) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                }
                if (bl) continue;
                object3.remove();
            }
        }
        object3 = node.getPredecessorTargets().iterator();
        while (object3.hasNext()) {
            this.addAsUseful(hashSet, hashSet2, (Node)object3.next());
        }
        if (node instanceof FieldNode) {
            object3 = (FieldNode)node;
            object2 = ((FieldNode)object3).getAccessPathPredecessors().iterator();
            while (object2.hasNext()) {
                this.addAsUseful(hashSet, hashSet2, (Node)object2.next());
            }
        }
        if (this.castPredecessors.contains(node)) {
            object3 = this.castMap.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = (Node)((Pair)object2.getKey()).left;
                CheckCastNode checkCastNode = (CheckCastNode)object2.getValue();
                if (node != object) continue;
                this.addIfUseful(hashSet, hashSet2, checkCastNode);
            }
        }
        if (node instanceof CheckCastNode) {
            object3 = ((ProgramLocation.QuadProgramLocation)((CheckCastNode)node).getLocation()).getQuad();
            object2 = this.castPredecessors.iterator();
            while (object2.hasNext()) {
                object = (Node)object2.next();
                CheckCastNode checkCastNode = (CheckCastNode)this.castMap.get(new Pair(object, object3));
                if (checkCastNode == null) continue;
                this.addAsUseful(hashSet, hashSet2, (Node)object);
            }
        }
        hashSet2.remove(node);
    }

    public Iterator nodeIterator() {
        return this.nodes.keySet().iterator();
    }

    public Set getReturned() {
        return this.returned;
    }

    public Set getThrown() {
        return this.thrown;
    }

    public Map getCastMap() {
        return this.castMap;
    }

    public ReturnValueNode getRVN(ProgramLocation programLocation) {
        return (ReturnValueNode)this.callToRVN.get(programLocation);
    }

    public ThrownExceptionNode getTEN(ProgramLocation programLocation) {
        return (ThrownExceptionNode)this.callToTEN.get(programLocation);
    }

    void verify() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = 0;
        while (n < this.params.length) {
            if (this.params[n] != null && !this.nodes.containsKey(this.params[n])) {
                Assert.UNREACHABLE(this.params[n].toString_long());
            }
            ++n;
        }
        Iterator<Object> iterator = this.returned.iterator();
        while (iterator.hasNext()) {
            object4 = (Node)iterator.next();
            if (object4 instanceof UnknownTypeNode || this.nodes.containsKey(object4)) continue;
            Assert.UNREACHABLE(((Node)object4).toString_long());
        }
        iterator = this.thrown.iterator();
        while (iterator.hasNext()) {
            object4 = (Node)iterator.next();
            if (object4 instanceof UnknownTypeNode || this.nodes.containsKey(object4)) continue;
            Assert.UNREACHABLE(((Node)object4).toString_long());
        }
        iterator = this.callToRVN.entrySet().iterator();
        while (iterator.hasNext()) {
            object4 = (Map.Entry)iterator.next();
            if (!this.calls.contains(object4.getKey())) {
                Assert.UNREACHABLE(object4.toString());
            }
            if ((object3 = object4.getValue()) == null || this.nodes.containsKey(object3)) continue;
            Assert.UNREACHABLE(object4.toString());
        }
        iterator = this.callToTEN.entrySet().iterator();
        while (iterator.hasNext()) {
            object4 = (Map.Entry)iterator.next();
            if (!this.calls.contains(object4.getKey())) {
                Assert.UNREACHABLE(object4.toString());
            }
            if ((object3 = object4.getValue()) instanceof Set) {
                object2 = ((Set)object3).iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (this.nodes.containsKey(object)) continue;
                    Assert.UNREACHABLE(object4.toString());
                }
                continue;
            }
            if (object3 == null || this.nodes.containsKey(object3)) continue;
            Assert.UNREACHABLE(object4.toString());
        }
        iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            Node node;
            Object object5;
            Object object6;
            Object object7;
            object4 = (Node)iterator.next();
            if (object4 instanceof UnknownTypeNode) {
                Assert.UNREACHABLE(((Node)object4).toString_long());
            }
            if (((Node)object4).addedEdges != null) {
                object3 = ((Node)object4).addedEdges.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    object = (jq_Field)object2.getKey();
                    object7 = object2.getValue();
                    if (object7 instanceof Node) {
                        object6 = (Node)object7;
                        if (!(object6 instanceof UnknownTypeNode) && !this.nodes.containsKey(object6)) {
                            Assert.UNREACHABLE(((Node)object6).toString_long());
                        }
                        if (((Node)object6).hasPredecessor((jq_Field)object, (Node)object4)) continue;
                        Assert.UNREACHABLE(((Node)object6).toString_long() + " has no predecessor " + ((Node)object4).toString_long());
                        continue;
                    }
                    if (object7 == null) continue;
                    object6 = (Set)object7;
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        node = (Node)object5.next();
                        if (!(node instanceof UnknownTypeNode) && !this.nodes.containsKey(node)) {
                            Assert.UNREACHABLE(node.toString_long());
                        }
                        if (node.hasPredecessor((jq_Field)object, (Node)object4)) continue;
                        Assert.UNREACHABLE(node.toString_long() + " has no predecessor " + ((Node)object4).toString_long());
                    }
                }
            }
            if (((Node)object4).predecessors != null) {
                object3 = ((Node)object4).predecessors.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    object = (jq_Field)object2.getKey();
                    object7 = object2.getValue();
                    if (object7 instanceof Node) {
                        object6 = (Node)object7;
                        if (object6 != GlobalNode.GLOBAL && !(object6 instanceof UnknownTypeNode) && !this.nodes.containsKey(object6)) {
                            Assert.UNREACHABLE(this.toString() + " ::: " + object6);
                        }
                        if (((Node)object6).hasNonEscapingEdge((jq_Field)object, (Node)object4)) continue;
                        Assert.UNREACHABLE(this.toString() + " ::: " + object6 + " -> " + object4);
                        continue;
                    }
                    if (object7 == null) continue;
                    object6 = (Set)object7;
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        node = (Node)object5.next();
                        if (node != GlobalNode.GLOBAL && !(node instanceof UnknownTypeNode) && !this.nodes.containsKey(node)) {
                            Assert.UNREACHABLE(node.toString_long());
                        }
                        if (node.hasNonEscapingEdge((jq_Field)object, (Node)object4)) continue;
                        Assert.UNREACHABLE(node.toString_long() + " has no edge " + ((Node)object4).toString_long());
                    }
                }
            }
            if (((Node)object4).accessPathEdges != null) {
                object3 = ((Node)object4).accessPathEdges.entrySet().iterator();
                while (object3.hasNext()) {
                    object2 = (Map.Entry)object3.next();
                    object = object2.getValue();
                    if (object instanceof FieldNode) {
                        object7 = (FieldNode)object;
                        if (!this.nodes.containsKey(object7)) {
                            Assert.UNREACHABLE(((FieldNode)object7).toString_long());
                        }
                        if (((FieldNode)object7).field_predecessors.contains(object4)) continue;
                        Assert.UNREACHABLE(((FieldNode)object7).toString_long() + " has no field pred " + ((Node)object4).toString_long());
                        continue;
                    }
                    if (object == null) continue;
                    object7 = (Set)object;
                    object6 = object7.iterator();
                    while (object6.hasNext()) {
                        object5 = (FieldNode)object6.next();
                        if (!this.nodes.containsKey(object5)) {
                            Assert.UNREACHABLE(((FieldNode)object5).toString_long());
                        }
                        if (((FieldNode)object5).field_predecessors.contains(object4)) continue;
                        Assert.UNREACHABLE(((FieldNode)object5).toString_long() + " has no field pred " + ((Node)object4).toString_long());
                    }
                }
            }
            if (object4 instanceof FieldNode) {
                object3 = (FieldNode)object4;
                if (((FieldNode)object3).field_predecessors != null) {
                    object2 = ((FieldNode)object3).f;
                    object = ((FieldNode)object3).field_predecessors.iterator();
                    while (object.hasNext()) {
                        object7 = (Node)object.next();
                        if (object7 != GlobalNode.GLOBAL && !(object7 instanceof UnknownTypeNode) && !this.nodes.containsKey(object7)) {
                            Assert.UNREACHABLE(this.toString() + " ::: " + ((Node)object7).toString_long());
                        }
                        if (((Node)object7).hasAccessPathEdge((jq_Field)object2, (Node)object3)) continue;
                        Assert.UNREACHABLE(this.toString() + " ::: " + ((Node)object7).toString_long() + " => " + ((FieldNode)object3).toString_long());
                    }
                }
            }
            if (object4 instanceof ReturnValueNode && !this.callToRVN.containsValue(object4)) {
                Assert.UNREACHABLE(((Node)object4).toString_long());
            }
            if (!(object4 instanceof ThrownExceptionNode) || this.callToTEN.containsValue(object4)) continue;
            System.out.println(this.callToTEN);
            Assert.UNREACHABLE(this.toString() + " ::: " + ((Node)object4).toString_long());
        }
    }

    static boolean multiset_contains(Map map, Object object) {
        if (map == null) {
            return false;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v == object) {
                return true;
            }
            if (!(v instanceof Collection) || !((Collection)v).contains(object)) continue;
            return true;
        }
        return false;
    }

    public Collection getSyncedVars() {
        return new FlattenedCollection(this.sync_ops.values());
    }

    void verifyNoReferences(Node node) {
        if (this.returned.contains(node)) {
            Assert.UNREACHABLE("ERROR: returned set contains " + node);
        }
        if (this.thrown.contains(node)) {
            Assert.UNREACHABLE("ERROR: thrown set contains " + node);
        }
        Iterator iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2 instanceof UnknownTypeNode) continue;
            if (MethodSummary.multiset_contains(node2.addedEdges, node)) {
                Assert.UNREACHABLE("ERROR: " + node2 + " contains an edge to " + node);
            }
            if (MethodSummary.multiset_contains(node2.predecessors, node)) {
                Assert.UNREACHABLE("ERROR: " + node2 + " contains predecessor " + node);
            }
            if (MethodSummary.multiset_contains(node2.accessPathEdges, node)) {
                Assert.UNREACHABLE("ERROR: " + node2 + " contains access path edge to " + node);
            }
            if (!(node2 instanceof FieldNode)) continue;
            FieldNode fieldNode = (FieldNode)node2;
            if (fieldNode.field_predecessors == null || !fieldNode.field_predecessors.contains(node)) continue;
            Assert.UNREACHABLE("ERROR: " + fieldNode + " contains a field predecessor " + node);
        }
    }

    public void dotGraph(DataOutput dataOutput) throws IOException {
        Object object;
        dataOutput.writeBytes("digraph \"" + this.method + "\" {\n");
        IndexMap indexMap = new IndexMap("MethodCallMap");
        Iterator iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            dataOutput.writeBytes("n" + ((Node)object).id + " [label=\"" + ((Node)object).toString_short() + "\"];\n");
        }
        iterator = this.getCalls().iterator();
        while (iterator.hasNext()) {
            object = (ProgramLocation)iterator.next();
            int n = indexMap.get(object);
            dataOutput.writeBytes("mc" + n + " [label=\"" + object + "\"];\n");
        }
        iterator = this.nodeIterator();
        while (iterator.hasNext()) {
            Node node;
            Iterator<Object> iterator2;
            String string;
            Object object2;
            object = (Node)iterator.next();
            Object object3 = ((Node)object).getNonEscapingEdges().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                string = "" + object2.getKey();
                iterator2 = object2.getValue() instanceof Set ? ((Set)object2.getValue()).iterator() : Collections.singleton(object2.getValue()).iterator();
                while (iterator2.hasNext()) {
                    node = (Node)iterator2.next();
                    dataOutput.writeBytes("n" + ((Node)object).id + " -> n" + node.id + " [label=\"" + string + "\"];\n");
                }
            }
            object3 = ((Node)object).getAccessPathEdges().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                string = "" + object2.getKey();
                iterator2 = object2.getValue() instanceof Set ? ((Set)object2.getValue()).iterator() : Collections.singleton(object2.getValue()).iterator();
                while (iterator2.hasNext()) {
                    node = (Node)iterator2.next();
                    dataOutput.writeBytes("n" + ((Node)object).id + " -> n" + node.id + " [label=\"" + string + "\",style=dashed];\n");
                }
            }
            if (((Node)object).getPassedParameters() != null) {
                object3 = ((Node)object).getPassedParameters().iterator();
                while (object3.hasNext()) {
                    object2 = (PassedParameter)object3.next();
                    int n = indexMap.get(((PassedParameter)object2).m);
                    dataOutput.writeBytes("n" + ((Node)object).id + " -> mc" + n + " [label=\"p" + ((PassedParameter)object2).paramNum + "\",style=dotted];\n");
                }
            }
            if (!(object instanceof ReturnedNode)) continue;
            object3 = (ReturnedNode)object;
            int n = indexMap.get(((ReturnedNode)object3).m);
            dataOutput.writeBytes("mc" + n + " -> n" + ((Node)object).id + " [label=\"r\",style=dotted];\n");
        }
        iterator = this.castMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Node node = (Node)((Pair)object.getKey()).left;
            Node node2 = (Node)object.getValue();
            if (!this.nodes.containsKey(node2)) continue;
            dataOutput.writeBytes("n" + node.id + " -> n" + node2.id + " [label=\"(cast)\"];\n");
        }
        dataOutput.writeBytes("}\n");
    }

    public static void main(String[] stringArray) throws IOException {
        Collection<Object> collection;
        Object object;
        HostedVM.initialize();
        jq_Class jq_Class2 = (jq_Class)jq_Type.parseType(stringArray[0]);
        jq_Class2.load();
        String string = null;
        String string2 = null;
        if (stringArray.length > 1) {
            string = stringArray[1];
            if (string.equals(fakeCloneName)) {
                MethodSummary methodSummary = MethodSummary.fakeCloneMethodSummary((jq_FakeInstanceMethod)jq_FakeInstanceMethod.fakeMethod(jq_Class2, fakeCloneName, "()" + jq_Class2.getName()));
                if (DUMP_DOTGRAPH) {
                    methodSummary.dotGraph(new DataOutputStream(System.out));
                } else {
                    System.out.println(methodSummary);
                }
                return;
            }
            if (stringArray.length > 2) {
                string2 = stringArray[2];
            }
        }
        if (string != null) {
            object = string2 != null ? (jq_Method)jq_Class2.getDeclaredMember(string, string2) : jq_Class2.getDeclaredMethod(string);
            collection = Collections.singleton(object);
        } else {
            collection = new LinkedList<jq_StaticMethod>();
            collection.addAll(java.util.Arrays.asList(jq_Class2.getDeclaredStaticMethods()));
            collection.addAll(java.util.Arrays.asList(jq_Class2.getDeclaredInstanceMethods()));
        }
        object = collection.iterator();
        while (object.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)object.next();
            if (jq_Method2.getBytecode() == null) continue;
            MethodSummary methodSummary = MethodSummary.getSummary(CodeCache.getCode(jq_Method2));
            if (DUMP_DOTGRAPH) {
                methodSummary.dotGraph(new DataOutputStream(System.out));
                continue;
            }
            System.out.println(methodSummary);
        }
    }

    public Collection getRegisterAtLocation(BasicBlock basicBlock, Quad quad, RegisterFactory.Register register) {
        this.builder.updateLocation(basicBlock, quad);
        Object object = this.builder.getRegister(register);
        if (object instanceof Node) {
            return Collections.singleton(object);
        }
        return (Collection)object;
    }

    public static MethodSummary fakeMethodSummary(jq_Method jq_Method2) {
        MethodSummary methodSummary = (MethodSummary)fakeCache.get(jq_Method2);
        if (methodSummary != null) {
            return methodSummary;
        }
        boolean bl = jq_Method2 instanceof jq_FakeInstanceMethod;
        if (bl && jq_Method2.getName().toString().equals(fakeCloneName)) {
            methodSummary = MethodSummary.fakeCloneMethodSummary((jq_FakeInstanceMethod)jq_Method2);
        } else if (identityMethods.contains(jq_Method2)) {
            methodSummary = MethodSummary.fakeIdentityMethodSummary(jq_Method2);
        } else {
            if (!bl) {
                return null;
            }
            throw new Error("don't know how to fake " + jq_Method2);
        }
        fakeCache.put(jq_Method2, methodSummary);
        return methodSummary;
    }

    static MethodSummary fakeIdentityMethodSummary(jq_Method jq_Method2) {
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        ParamNode[] paramNodeArray = new ParamNode[]{new FakeParamNode(jq_Method2, 0, jq_Class2)};
        return new MethodSummary(null, jq_Method2, paramNodeArray, new GlobalNode(jq_Method2), Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.singleton(paramNodeArray[0]), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_MAP);
    }

    public static MethodSummary fakeCloneMethodSummary(jq_FakeInstanceMethod jq_FakeInstanceMethod2) {
        jq_Class jq_Class2 = jq_FakeInstanceMethod2.getDeclaringClass();
        ParamNode[] paramNodeArray = new ParamNode[]{new FakeParamNode(jq_FakeInstanceMethod2, 0, jq_Class2)};
        ConcreteTypeNode concreteTypeNode = new ConcreteTypeNode(jq_Class2, new ProgramLocation.FakeProgramLocation(jq_FakeInstanceMethod2, "fakedclone"));
        jq_Class2.prepare();
        jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
        int n = 0;
        while (n < jq_InstanceFieldArray.length) {
            if (jq_InstanceFieldArray[n].getType().isReferenceType()) {
                concreteTypeNode.addEdge(jq_InstanceFieldArray[n], FieldNode.get(paramNodeArray[0], jq_InstanceFieldArray[n], new ProgramLocation.FakeProgramLocation(jq_FakeInstanceMethod2, "field=" + jq_InstanceFieldArray[n].getName())));
            }
            ++n;
        }
        return new MethodSummary(null, (jq_Method)jq_FakeInstanceMethod2, paramNodeArray, new GlobalNode(jq_FakeInstanceMethod2), Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, Collections.EMPTY_SET, Collections.singleton(concreteTypeNode), Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_MAP);
    }

    private final /* synthetic */ void this() {
        jq_Class jq_Class2 = PrimordialClassLoader.getJavaLangThrowable();
        identityMethods.add(jq_Class2.getDeclaredMember("fillInStackTrace", "()Ljava/lang/Throwable;"));
    }

    public MethodSummary(ParamNode[] paramNodeArray) {
        this.this();
        this.method = null;
        this.params = paramNodeArray;
        this.calls = Collections.EMPTY_SET;
        this.callToRVN = Collections.EMPTY_MAP;
        this.callToTEN = Collections.EMPTY_MAP;
        this.nodes = Collections.EMPTY_MAP;
        this.returned = Collections.EMPTY_SET;
        this.thrown = Collections.EMPTY_SET;
        this.castMap = Collections.EMPTY_MAP;
        this.castPredecessors = Collections.EMPTY_SET;
        this.passedParamToNodes = Collections.EMPTY_MAP;
        this.sync_ops = Collections.EMPTY_MAP;
    }

    public MethodSummary(BuildMethodSummary buildMethodSummary, jq_Method jq_Method2, ParamNode[] paramNodeArray, GlobalNode globalNode, Set set, Map map, Map map2, Map map3, Set set2, Set set3, Set set4, Set set5, Map map4) {
        Object object;
        this.this();
        this.method = jq_Method2;
        this.params = paramNodeArray;
        this.calls = set;
        this.callToRVN = map;
        this.callToTEN = map2;
        this.passedParamToNodes = new HashMap();
        this.sync_ops = map4;
        this.castMap = map3;
        this.castPredecessors = set2;
        this.returned = set3;
        this.thrown = set4;
        this.global = globalNode;
        if (CACHE_BUILDER) {
            this.builder = buildMethodSummary;
        }
        this.nodes = new LinkedHashMap();
        this.nodes.put(globalNode, globalNode);
        int n = 0;
        while (n < this.params.length) {
            if (this.params[n] != null) {
                this.nodes.put(this.params[n], this.params[n]);
            }
            ++n;
        }
        Object object2 = set3.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object instanceof UnknownTypeNode) continue;
            this.nodes.put(object, object);
        }
        object2 = set4.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object instanceof UnknownTypeNode) continue;
            this.nodes.put(object, object);
        }
        object2 = set5.iterator();
        while (object2.hasNext()) {
            object = (Node)object2.next();
            if (object instanceof UnknownTypeNode) continue;
            this.nodes.put(object, object);
            if (((Node)object).passedParameters == null) continue;
            Iterator iterator = ((Node)object).passedParameters.iterator();
            while (iterator.hasNext()) {
                PassedParameter passedParameter = (PassedParameter)iterator.next();
                Set set6 = (Set)this.passedParamToNodes.get(passedParameter);
                if (set6 == null) {
                    set6 = NodeSet.FACTORY.makeSet();
                    this.passedParamToNodes.put(passedParameter, set6);
                }
                set6.add(object);
            }
        }
        object2 = new HashSet();
        object = new HashSet();
        this.addAsUseful((HashSet)object2, (HashSet)object, globalNode);
        int n2 = 0;
        while (n2 < this.params.length) {
            if (this.params[n2] != null) {
                this.addAsUseful((HashSet)object2, (HashSet)object, this.params[n2]);
            }
            ++n2;
        }
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            this.addAsUseful((HashSet)object2, (HashSet)object, (Node)iterator.next());
        }
        iterator = set4.iterator();
        while (iterator.hasNext()) {
            this.addAsUseful((HashSet)object2, (HashSet)object, (Node)iterator.next());
        }
        iterator = set5.iterator();
        while (iterator.hasNext()) {
            this.addAsUseful((HashSet)object2, (HashSet)object, (Node)iterator.next());
        }
        set2 = null;
    }

    private MethodSummary(BuildMethodSummary buildMethodSummary, jq_Method jq_Method2, ParamNode[] paramNodeArray, Set set, Map map, Map map2, Map map3, Set set2, Map map4, Map map5, Set set3, Set set4, Map map6) {
        this.this();
        this.method = jq_Method2;
        this.params = paramNodeArray;
        this.calls = set;
        this.callToRVN = map;
        this.callToTEN = map2;
        this.castMap = map3;
        this.castPredecessors = set2;
        this.passedParamToNodes = map4;
        this.sync_ops = map5;
        this.returned = set3;
        this.thrown = set4;
        this.nodes = map6;
        this.builder = buildMethodSummary;
    }

    static {
        boolean bl = false;
        if (System.getProperty("ms.traceintra") != null) {
            bl = true;
        }
        TRACE_INTRA = bl;
        boolean bl2 = false;
        if (System.getProperty("ms.traceinter") != null) {
            bl2 = true;
        }
        TRACE_INTER = bl2;
        boolean bl3 = false;
        if (System.getProperty("ms.traceinst") != null) {
            bl3 = true;
        }
        TRACE_INST = bl3;
        summary_cache = new HashMap();
        CACHE_BUILDER = false;
        boolean bl4 = false;
        if (System.getProperty("ms.dotgraph") != null) {
            bl4 = true;
        }
        DUMP_DOTGRAPH = bl4;
        fakeCache = new HashMap();
        identityMethods = new HashSet();
        fakeCloneName = "fake$clone";
    }

    public static final class MethodSummaryBuilder
    implements ControlFlowGraphVisitor {
        public final void visitCFG(ControlFlowGraph controlFlowGraph) {
            MethodSummary methodSummary = MethodSummary.getSummary(controlFlowGraph);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(System.out);
                methodSummary.dotGraph(dataOutputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class BuildMethodSummary
    extends QuadVisitor.EmptyVisitor {
        public static final boolean INSIDE_EDGES = false;
        static final boolean GLOBAL_OBJECT_CONSTANTS = false;
        static final boolean GLOBAL_TYPE_CONSTANTS = false;
        static final boolean MERGE_LOCAL_CONSTANTS = false;
        protected final jq_Method method;
        protected final int nLocals;
        protected final int nRegisters;
        protected final ParamNode[] param_nodes;
        protected final GlobalNode my_global;
        protected final State[] start_states;
        protected final Set returned;
        protected final Set thrown;
        protected final Set methodCalls;
        protected final HashMap callToRVN;
        protected final HashMap callToTEN;
        protected final LinkedHashMap castMap;
        protected final LinkedHashSet castPredecessors;
        protected final Set passedAsParameter;
        protected BasicBlock bb;
        protected State s;
        protected boolean change;
        boolean include_sync_ops;
        boolean include_cast_ops;
        protected final Map sync_ops;
        protected final HashMap nodeCache;
        HashMap jsr_states;
        LoopAnalysis la;

        public final MethodSummary getSummary() {
            MethodSummary methodSummary = new MethodSummary(this, this.method, this.param_nodes, this.my_global, this.methodCalls, (Map)this.callToRVN, (Map)this.callToTEN, this.castMap, this.castPredecessors, this.returned, this.thrown, this.passedAsParameter, this.sync_ops);
            return methodSummary;
        }

        protected final void setLocal(int n, Node node) {
            this.s.registers[n] = node;
        }

        protected final void setRegister(RegisterFactory.Register register, Node node) {
            int n = register.getNumber();
            if (register.isTemp()) {
                n += this.nLocals;
            }
            this.s.registers[n] = node;
            if (TRACE_INTRA) {
                out.println("Setting register " + register + " to " + node);
            }
        }

        protected final void setRegister(RegisterFactory.Register register, Object object) {
            int n = register.getNumber();
            if (register.isTemp()) {
                n += this.nLocals;
            }
            if (object instanceof Collection) {
                object = NodeSet.FACTORY.makeSet((Collection)object);
            } else {
                Assert._assert(object instanceof Node);
            }
            this.s.registers[n] = object;
            if (TRACE_INTRA) {
                out.println("Setting register " + register + " to " + object);
            }
        }

        public final Object getRegister(RegisterFactory.Register register) {
            int n = register.getNumber();
            if (register.isTemp()) {
                n += this.nLocals;
            }
            boolean bl = false;
            if (this.s.registers[n] != null) {
                bl = true;
            }
            Assert._assert(bl);
            return this.s.registers[n];
        }

        public final void updateLocation(BasicBlock basicBlock, Quad quad) {
            this.bb = basicBlock;
            this.s = this.start_states[basicBlock.getID()];
            this.s = this.s.copy();
            ListIterator.Quad quad2 = basicBlock.iterator();
            while (quad2.hasNext()) {
                Quad quad3 = quad2.nextQuad();
                quad3.accept(this);
                if (quad3 == quad) break;
            }
        }

        protected final void mergeWith(BasicBlock basicBlock) {
            if (this.start_states[basicBlock.getID()] == null) {
                if (TRACE_INTRA) {
                    out.println(basicBlock + " not yet visited.");
                }
                this.start_states[basicBlock.getID()] = this.s.copy();
                this.change = true;
            } else {
                if (TRACE_INTRA) {
                    out.println("merging out set of " + this.bb + " into in set of " + basicBlock);
                }
                if (this.start_states[basicBlock.getID()].merge(this.s)) {
                    if (TRACE_INTRA) {
                        out.println(basicBlock + " in set changed");
                    }
                    this.change = true;
                }
            }
        }

        protected final void mergeWithJSR(BasicBlock basicBlock, State state, boolean[] blArray) {
            State state2 = this.start_states[basicBlock.getID()];
            if (state2 == null) {
                if (TRACE_INTRA) {
                    out.println(basicBlock + " not yet visited.");
                }
                this.start_states[basicBlock.getID()] = state2 = this.s.copy();
                this.change = true;
            }
            if (TRACE_INTRA) {
                out.println("merging out set of jsr " + this.bb + " into in set of " + basicBlock);
            }
            int n = 0;
            while (n < blArray.length) {
                if (blArray[n]) {
                    if (state2.merge(n, this.s.registers[n])) {
                        if (TRACE_INTRA) {
                            out.println(basicBlock + " in set changed by register " + n + " in jsr subroutine");
                        }
                        this.change = true;
                    }
                } else if (state2.merge(n, state.registers[n])) {
                    if (TRACE_INTRA) {
                        out.println(basicBlock + " in set changed by register " + n + " before jsr subroutine");
                    }
                    this.change = true;
                }
                ++n;
            }
        }

        protected final void mergeWith(ExceptionHandler exceptionHandler) {
            BasicBlock basicBlock = exceptionHandler.getEntry();
            if (this.start_states[basicBlock.getID()] == null) {
                if (TRACE_INTRA) {
                    out.println(basicBlock + " not yet visited.");
                }
                this.start_states[basicBlock.getID()] = this.s.copy();
                int n = this.nLocals;
                while (n < this.s.registers.length) {
                    this.start_states[basicBlock.getID()].registers[n] = null;
                    ++n;
                }
                this.change = true;
            } else {
                if (TRACE_INTRA) {
                    out.println("merging out set of " + this.bb + " into in set of ex handler " + basicBlock);
                }
                int n = 0;
                while (n < this.nLocals) {
                    if (this.start_states[basicBlock.getID()].merge(n, this.s.registers[n])) {
                        this.change = true;
                    }
                    ++n;
                }
                if (TRACE_INTRA && this.change) {
                    out.println(basicBlock + " in set changed");
                }
            }
        }

        protected final void heapLoad(Set set, Node node, jq_Field jq_Field2, FieldNode fieldNode) {
            set.add(fieldNode);
        }

        protected final void heapLoad(ProgramLocation programLocation, RegisterFactory.Register register, Set set, jq_Field jq_Field2) {
            Set set2 = NodeSet.FACTORY.makeSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                FieldNode fieldNode = FieldNode.get(node, jq_Field2, programLocation);
                this.heapLoad(set2, node, jq_Field2, fieldNode);
            }
            this.setRegister(register, set2);
        }

        protected final void heapLoad(ProgramLocation programLocation, RegisterFactory.Register register, Node node, jq_Field jq_Field2) {
            FieldNode fieldNode = FieldNode.get(node, jq_Field2, programLocation);
            Set set = NodeSet.FACTORY.makeSet();
            this.heapLoad(set, node, jq_Field2, fieldNode);
            this.setRegister(register, set);
        }

        protected final void heapLoad(ProgramLocation programLocation, RegisterFactory.Register register, RegisterFactory.Register register2, jq_Field jq_Field2) {
            Object object = this.getRegister(register2);
            if (object instanceof Set) {
                this.heapLoad(programLocation, register, (Set)object, jq_Field2);
            } else {
                this.heapLoad(programLocation, register, (Node)object, jq_Field2);
            }
        }

        protected final void heapStore(Node node, Node node2, jq_Field jq_Field2) {
            node.addEdge(jq_Field2, node2);
        }

        protected final void heapStore(Node node, Set set, jq_Field jq_Field2) {
            node.addEdges(jq_Field2, NodeSet.FACTORY.makeSet(set));
        }

        protected final void heapStore(Node node, Object object, jq_Field jq_Field2) {
            if (object instanceof Node) {
                this.heapStore(node, (Node)object, jq_Field2);
            } else {
                this.heapStore(node, (Set)object, jq_Field2);
            }
        }

        protected final void heapStore(Object object, Object object2, jq_Field jq_Field2) {
            if (object instanceof Node) {
                if (object2 instanceof Node) {
                    this.heapStore((Node)object, (Node)object2, jq_Field2);
                } else {
                    this.heapStore((Node)object, (Set)object2, jq_Field2);
                }
            } else {
                Set set = (Set)object;
                if (object2 instanceof Node) {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        this.heapStore((Node)iterator.next(), (Node)object2, jq_Field2);
                    }
                } else {
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        this.heapStore((Node)iterator.next(), (Set)object2, jq_Field2);
                    }
                }
            }
        }

        protected final void monitorOp(Quad quad, RegisterFactory.Register register) {
            Object object = this.getRegister(register);
            if (object instanceof Node) {
                this.monitorOp(quad, Collections.singleton(object));
            } else {
                this.monitorOp(quad, (Set)object);
            }
        }

        protected final void monitorOp(Quad quad, Set set) {
            Set set2 = (Set)this.sync_ops.get(quad);
            if (set2 != null) {
                Assert._assert(set.containsAll(set2));
            }
            this.sync_ops.put(quad, set);
        }

        final void passParameter(RegisterFactory.Register register, ProgramLocation programLocation, int n) {
            Object object = this.getRegister(register);
            if (TRACE_INTRA) {
                out.println("Passing " + register + " to " + programLocation + " param " + n + ": " + object);
            }
            if (object instanceof Set) {
                Iterator iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    node.recordPassedParameter(programLocation, n);
                    this.passedAsParameter.add(node);
                }
            } else {
                Node node = (Node)object;
                node.recordPassedParameter(programLocation, n);
                this.passedAsParameter.add(node);
            }
        }

        final Node handleConst(Operand.Const4Operand const4Operand, ProgramLocation programLocation) {
            Node node;
            if (const4Operand instanceof Operand.AConstOperand) {
                Operand.AConstOperand aConstOperand = (Operand.AConstOperand)const4Operand;
                Operand.Const4Operand const4Operand2 = const4Operand;
                node = (Node)this.nodeCache.get(const4Operand2);
                if (node == null) {
                    node = new ConcreteTypeNode(aConstOperand.getType(), programLocation);
                    this.nodeCache.put(const4Operand2, node);
                }
            } else {
                jq_Reference jq_Reference2 = ((Operand.PConstOperand)const4Operand).getType();
                node = UnknownTypeNode.get(jq_Reference2);
            }
            return node;
        }

        public final void visitALoad(Quad quad) {
            if (quad.getOperator() instanceof Operator.ALoad.ALOAD_A || quad.getOperator() instanceof Operator.ALoad.ALOAD_P) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.ALoad.getDest(quad).getRegister();
                Operand operand = Operator.ALoad.getBase(quad);
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.method, quad);
                if (operand instanceof Operand.RegisterOperand) {
                    RegisterFactory.Register register2 = ((Operand.RegisterOperand)operand).getRegister();
                    this.heapLoad((ProgramLocation)quadProgramLocation, register, register2, null);
                } else {
                    Node node = this.handleConst((Operand.AConstOperand)operand, quadProgramLocation);
                    this.heapLoad((ProgramLocation)quadProgramLocation, register, node, null);
                }
            }
        }

        public final void visitAStore(Quad quad) {
            if (quad.getOperator() instanceof Operator.AStore.ASTORE_A || quad.getOperator() instanceof Operator.AStore.ASTORE_P) {
                Object object;
                Object object2;
                RegisterFactory.Register register;
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                Operand operand = Operator.AStore.getValue(quad);
                Operand operand2 = Operator.AStore.getBase(quad);
                if (operand2 instanceof Operand.RegisterOperand) {
                    register = ((Operand.RegisterOperand)operand2).getRegister();
                    object2 = this.getRegister(register);
                } else {
                    object2 = this.handleConst((Operand.AConstOperand)operand2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                }
                if (operand instanceof Operand.RegisterOperand) {
                    register = ((Operand.RegisterOperand)operand).getRegister();
                    object = this.getRegister(register);
                } else {
                    object = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                }
                this.heapStore(object2, object, null);
            }
        }

        public final void visitBinary(Quad quad) {
            if (quad.getOperator() == Operator.Binary.ADD_P.INSTANCE) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.Binary.getDest(quad).getRegister();
                Operand operand = Operator.Binary.getSrc1(quad);
                if (operand instanceof Operand.RegisterOperand) {
                    Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                    RegisterFactory.Register register2 = registerOperand.getRegister();
                    this.setRegister(register, this.getRegister(register2));
                } else {
                    Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.setRegister(register, node);
                }
            }
        }

        public final void visitCheckCast(Quad quad) {
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            RegisterFactory.Register register = Operator.CheckCast.getDest(quad).getRegister();
            Operand operand = Operator.CheckCast.getSrc(quad);
            if (operand instanceof Operand.RegisterOperand) {
                RegisterFactory.Register register2 = ((Operand.RegisterOperand)operand).getRegister();
                Object object = this.getRegister(register2);
                if (!this.include_cast_ops) {
                    this.setRegister(register, object);
                    return;
                }
                CheckCastNode checkCastNode = (CheckCastNode)this.nodeCache.get(quad);
                if (checkCastNode == null) {
                    checkCastNode = new CheckCastNode((jq_Reference)Operator.CheckCast.getType(quad).getType(), new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.nodeCache.put(quad, checkCastNode);
                }
                Set<Object> set = object instanceof Collection ? (Set<Object>)object : Collections.singleton(object);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    Pair pair = new Pair(node, quad);
                    if (this.castMap.put(pair, checkCastNode) != null) continue;
                    this.castPredecessors.add(node);
                }
                this.setRegister(register, checkCastNode);
            } else {
                Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                this.setRegister(register, node);
            }
        }

        public final void visitGetfield(Quad quad) {
            if (quad.getOperator() instanceof Operator.Getfield.GETFIELD_A || quad.getOperator() instanceof Operator.Getfield.GETFIELD_P) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.Getfield.getDest(quad).getRegister();
                Operand operand = Operator.Getfield.getBase(quad);
                Operator.Getfield.getField(quad).resolve();
                jq_Field jq_Field2 = Operator.Getfield.getField(quad).getField();
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.method, quad);
                if (operand instanceof Operand.RegisterOperand) {
                    RegisterFactory.Register register2 = ((Operand.RegisterOperand)operand).getRegister();
                    this.heapLoad((ProgramLocation)quadProgramLocation, register, register2, jq_Field2);
                } else {
                    Node node = this.handleConst((Operand.Const4Operand)operand, quadProgramLocation);
                    this.heapLoad((ProgramLocation)quadProgramLocation, register, node, jq_Field2);
                }
            }
        }

        public final void visitGetstatic(Quad quad) {
            if (quad.getOperator() instanceof Operator.Getstatic.GETSTATIC_A || quad.getOperator() instanceof Operator.Getstatic.GETSTATIC_P) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.Getstatic.getDest(quad).getRegister();
                Operator.Getstatic.getField(quad).resolve();
                jq_Field jq_Field2 = Operator.Getstatic.getField(quad).getField();
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.method, quad);
                this.heapLoad((ProgramLocation)quadProgramLocation, register, this.my_global, jq_Field2);
            }
        }

        public final void visitInstanceOf(Quad quad) {
        }

        public final void visitInvoke(Quad quad) {
            Operand.RegisterOperand registerOperand;
            RegisterFactory.Register register;
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            Operator.Invoke.getMethod(quad).resolve();
            jq_Method jq_Method2 = Operator.Invoke.getMethod(quad).getMethod();
            ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.method, quad);
            if (jq_Method2 == Arrays._multinewarray) {
                Operand.RegisterOperand registerOperand2 = Operator.Invoke.getDest(quad);
                if (registerOperand2 != null) {
                    RegisterFactory.Register register2 = registerOperand2.getRegister();
                    jq_Array jq_Array2 = PrimordialClassLoader.getJavaLangObject().getArrayTypeForElementType();
                    Quad quad2 = quad;
                    ConcreteTypeNode concreteTypeNode = (ConcreteTypeNode)this.nodeCache.get(quad2);
                    if (concreteTypeNode == null) {
                        concreteTypeNode = new ConcreteTypeNode(jq_Array2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                        this.nodeCache.put(quad2, concreteTypeNode);
                    }
                    this.setRegister(register2, concreteTypeNode);
                }
                return;
            }
            this.methodCalls.add(quadProgramLocation);
            jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
            Operand.ParamListOperand paramListOperand = Operator.Invoke.getParamList(quad);
            boolean bl = false;
            if (jq_Method2 == Arrays._multinewarray || jq_TypeArray.length == paramListOperand.length()) {
                bl = true;
            }
            Assert._assert(bl);
            int n = 0;
            while (n < jq_TypeArray.length) {
                if (jq_TypeArray[n].isReferenceType()) {
                    register = paramListOperand.get(n).getRegister();
                    this.passParameter(register, quadProgramLocation, n);
                }
                ++n;
            }
            if (jq_Method2.getReturnType().isReferenceType() && (registerOperand = Operator.Invoke.getDest(quad)) != null) {
                register = registerOperand.getRegister();
                ReturnValueNode returnValueNode = (ReturnValueNode)this.callToRVN.get(quadProgramLocation);
                if (returnValueNode == null) {
                    returnValueNode = new ReturnValueNode(quadProgramLocation);
                    this.callToRVN.put(quadProgramLocation, returnValueNode);
                    this.passedAsParameter.add(returnValueNode);
                }
                this.setRegister(register, returnValueNode);
            }
        }

        public final void visitJsr(Quad quad) {
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            if (this.jsr_states == null) {
                this.jsr_states = new HashMap();
            }
            BasicBlock basicBlock = Operator.Jsr.getSuccessor(quad).getTarget();
            this.jsr_states.put(basicBlock, this.s);
        }

        public final void visitMonitor(Quad quad) {
            Operand operand;
            if (!this.include_sync_ops) {
                return;
            }
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            if ((operand = Operator.Monitor.getSrc(quad)) instanceof Operand.RegisterOperand) {
                Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                RegisterFactory.Register register = registerOperand.getRegister();
                this.monitorOp(quad, register);
            } else {
                Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                this.monitorOp(quad, Collections.singleton(node));
            }
        }

        public final void visitMove(Quad quad) {
            if (quad.getOperator() instanceof Operator.Move.MOVE_A || quad.getOperator() instanceof Operator.Move.MOVE_P) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.Move.getDest(quad).getRegister();
                Operand operand = Operator.Move.getSrc(quad);
                if (operand instanceof Operand.RegisterOperand) {
                    Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                    if (registerOperand.getType() instanceof BytecodeToQuad.jq_ReturnAddressType) {
                        return;
                    }
                    RegisterFactory.Register register2 = registerOperand.getRegister();
                    this.setRegister(register, this.getRegister(register2));
                } else {
                    Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.setRegister(register, node);
                }
            }
        }

        public final void visitNew(Quad quad) {
            Textualizable textualizable;
            Object object;
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            RegisterFactory.Register register = Operator.New.getDest(quad).getRegister();
            jq_Reference jq_Reference2 = (jq_Reference)Operator.New.getType(quad).getType();
            if (jq_Reference2 != null) {
                jq_Reference2.prepare();
                object = PrimordialClassLoader.getJavaLangThread();
                textualizable = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/lang/Runnable;");
                ((jq_Class)object).prepare();
                ((jq_Class)textualizable).prepare();
                if (jq_Reference2.isSubtypeOf((jq_Type)object) || jq_Reference2.isSubtypeOf((jq_Type)textualizable)) {
                    if (this.la == null) {
                        this.la = new LoopAnalysis();
                    }
                    if (this.la.isInLoop(this.method, this.bb)) {
                        Quad quad2 = quad;
                        Pair pair = (Pair)this.nodeCache.get(quad2);
                        if (pair == null) {
                            System.out.println("Found thread creation in loop: " + quad);
                            pair = new Pair(new ConcreteTypeNode(jq_Reference2, new ProgramLocation.QuadProgramLocation(this.method, quad)), new ConcreteTypeNode(jq_Reference2, new ProgramLocation.QuadProgramLocation(this.method, quad)));
                            this.nodeCache.put(quad2, pair);
                        }
                        this.setRegister(register, pair);
                        return;
                    }
                }
            }
            if ((textualizable = (ConcreteTypeNode)this.nodeCache.get(object = quad)) == null) {
                textualizable = new ConcreteTypeNode(jq_Reference2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                this.nodeCache.put(object, textualizable);
            }
            this.setRegister(register, (Node)textualizable);
        }

        public final void visitNewArray(Quad quad) {
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            RegisterFactory.Register register = Operator.NewArray.getDest(quad).getRegister();
            jq_Reference jq_Reference2 = (jq_Reference)Operator.NewArray.getType(quad).getType();
            Quad quad2 = quad;
            ConcreteTypeNode concreteTypeNode = (ConcreteTypeNode)this.nodeCache.get(quad2);
            if (concreteTypeNode == null) {
                concreteTypeNode = new ConcreteTypeNode(jq_Reference2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                this.nodeCache.put(quad2, concreteTypeNode);
            }
            this.setRegister(register, concreteTypeNode);
        }

        public final void visitPutfield(Quad quad) {
            if (quad.getOperator() instanceof Operator.Putfield.PUTFIELD_A || quad.getOperator() instanceof Operator.Putfield.PUTFIELD_P) {
                Object object;
                Object object2;
                RegisterFactory.Register register;
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                Operand operand = Operator.Putfield.getBase(quad);
                Operand operand2 = Operator.Putfield.getSrc(quad);
                Operator.Putfield.getField(quad).resolve();
                jq_Field jq_Field2 = Operator.Putfield.getField(quad).getField();
                if (operand2 instanceof Operand.RegisterOperand) {
                    register = ((Operand.RegisterOperand)operand2).getRegister();
                    object2 = this.getRegister(register);
                } else {
                    object2 = this.handleConst((Operand.Const4Operand)operand2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                }
                if (operand instanceof Operand.RegisterOperand) {
                    register = ((Operand.RegisterOperand)operand).getRegister();
                    object = this.getRegister(register);
                } else {
                    object = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                }
                this.heapStore(object, object2, jq_Field2);
            }
        }

        public final void visitPutstatic(Quad quad) {
            if (quad.getOperator() instanceof Operator.Putstatic.PUTSTATIC_A || quad.getOperator() instanceof Operator.Putstatic.PUTSTATIC_P) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                Operand operand = Operator.Putstatic.getSrc(quad);
                Operator.Putstatic.getField(quad).resolve();
                jq_Field jq_Field2 = Operator.Putstatic.getField(quad).getField();
                if (operand instanceof Operand.RegisterOperand) {
                    RegisterFactory.Register register = ((Operand.RegisterOperand)operand).getRegister();
                    this.heapStore((Node)this.my_global, this.getRegister(register), jq_Field2);
                } else {
                    Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.heapStore((Node)this.my_global, node, jq_Field2);
                }
            }
        }

        static final void addToSet(Set set, Object object) {
            if (object instanceof Set) {
                set.addAll((Set)object);
            } else if (object != null) {
                set.add(object);
            }
        }

        public final void visitReturn(Quad quad) {
            Set set;
            Operand operand = Operator.Return.getSrc(quad);
            if (quad.getOperator() == Operator.Return.RETURN_A.INSTANCE || quad.getOperator() == Operator.Return.RETURN_P.INSTANCE) {
                set = this.returned;
            } else if (quad.getOperator() == Operator.Return.THROW_A.INSTANCE) {
                set = this.thrown;
            } else {
                return;
            }
            if (TRACE_INTRA) {
                out.println("Visiting: " + quad);
            }
            if (operand instanceof Operand.RegisterOperand) {
                RegisterFactory.Register register = ((Operand.RegisterOperand)operand).getRegister();
                BuildMethodSummary.addToSet(set, this.getRegister(register));
            } else {
                Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                set.add(node);
            }
        }

        static final void setAsEscapes(Object object) {
            if (object instanceof Set) {
                Iterator iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).escapes = true;
                }
            } else {
                ((Node)object).escapes = true;
            }
        }

        public final void visitSpecial(Quad quad) {
            if (quad.getOperator() == Operator.Special.GET_THREAD_BLOCK.INSTANCE) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = ((Operand.RegisterOperand)Operator.Special.getOp1(quad)).getRegister();
                jq_Class jq_Class2 = jq_Thread._class;
                ConcreteTypeNode concreteTypeNode = (ConcreteTypeNode)this.nodeCache.get(quad);
                Quad quad2 = quad;
                if (concreteTypeNode == null) {
                    concreteTypeNode = new ConcreteTypeNode(jq_Class2, new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.nodeCache.put(quad2, concreteTypeNode);
                }
                concreteTypeNode.setEscapes();
                this.setRegister(register, concreteTypeNode);
            } else if (quad.getOperator() == Operator.Special.SET_THREAD_BLOCK.INSTANCE) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = ((Operand.RegisterOperand)Operator.Special.getOp2(quad)).getRegister();
                BuildMethodSummary.setAsEscapes(this.getRegister(register));
            }
        }

        public final void visitUnary(Quad quad) {
            if (quad.getOperator() == Operator.Unary.OBJECT_2ADDRESS.INSTANCE || quad.getOperator() == Operator.Unary.ADDRESS_2OBJECT.INSTANCE) {
                if (TRACE_INTRA) {
                    out.println("Visiting: " + quad);
                }
                RegisterFactory.Register register = Operator.Unary.getDest(quad).getRegister();
                Operand operand = Operator.Unary.getSrc(quad);
                if (operand instanceof Operand.RegisterOperand) {
                    Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                    RegisterFactory.Register register2 = registerOperand.getRegister();
                    this.setRegister(register, this.getRegister(register2));
                } else {
                    Node node = this.handleConst((Operand.Const4Operand)operand, new ProgramLocation.QuadProgramLocation(this.method, quad));
                    this.setRegister(register, node);
                }
            } else if (quad.getOperator() == Operator.Unary.INT_2ADDRESS.INSTANCE) {
                RegisterFactory.Register register = Operator.Unary.getDest(quad).getRegister();
                jq_Class jq_Class2 = Address._class;
                UnknownTypeNode unknownTypeNode = UnknownTypeNode.get(jq_Class2);
                this.setRegister(register, unknownTypeNode);
            }
        }

        public final void visitExceptionThrower(Quad quad) {
            if (quad.getOperator() instanceof Operator.Invoke) {
                Operator.Invoke.getMethod(quad).resolve();
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this.method, quad);
                ThrownExceptionNode thrownExceptionNode = (ThrownExceptionNode)this.callToTEN.get(quadProgramLocation);
                if (thrownExceptionNode == null) {
                    thrownExceptionNode = new ThrownExceptionNode(quadProgramLocation);
                    this.callToTEN.put(quadProgramLocation, thrownExceptionNode);
                    this.passedAsParameter.add(thrownExceptionNode);
                }
                ListIterator.ExceptionHandler exceptionHandler = this.bb.getExceptionHandlers().exceptionHandlerIterator();
                while (exceptionHandler.hasNext()) {
                    ExceptionHandler exceptionHandler2 = exceptionHandler.nextExceptionHandler();
                    this.mergeWith(exceptionHandler2);
                    this.start_states[exceptionHandler2.getEntry().getID()].merge(this.nLocals, thrownExceptionNode);
                    if (!exceptionHandler2.mustCatch(PrimordialClassLoader.getJavaLangThrowable())) continue;
                    return;
                }
                this.thrown.add(thrownExceptionNode);
                return;
            }
            ListIterator.jq_Class jq_Class2 = quad.getThrownExceptions().classIterator();
            while (jq_Class2.hasNext()) {
                jq_Class jq_Class3 = jq_Class2.nextClass();
                UnknownTypeNode unknownTypeNode = UnknownTypeNode.get(jq_Class3);
                ListIterator.ExceptionHandler exceptionHandler = this.bb.getExceptionHandlers().exceptionHandlerIterator();
                boolean bl = false;
                while (exceptionHandler.hasNext()) {
                    ExceptionHandler exceptionHandler3 = exceptionHandler.nextExceptionHandler();
                    if (exceptionHandler3.mayCatch(jq_Class3)) {
                        this.mergeWith(exceptionHandler3);
                        this.start_states[exceptionHandler3.getEntry().getID()].merge(this.nLocals, unknownTypeNode);
                    }
                    if (!exceptionHandler3.mustCatch(jq_Class3)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.thrown.add(unknownTypeNode);
            }
        }

        private final /* synthetic */ void this() {
            this.include_sync_ops = true;
            this.include_cast_ops = System.getProperty("ms.withcasts", "yes").equals("yes");
        }

        BuildMethodSummary(BuildMethodSummary buildMethodSummary) {
            this.this();
            this.method = buildMethodSummary.method;
            this.nLocals = buildMethodSummary.nLocals;
            this.nRegisters = buildMethodSummary.nRegisters;
            this.param_nodes = buildMethodSummary.param_nodes;
            this.my_global = buildMethodSummary.my_global;
            this.start_states = buildMethodSummary.start_states;
            this.returned = buildMethodSummary.returned;
            this.thrown = buildMethodSummary.thrown;
            this.methodCalls = buildMethodSummary.methodCalls;
            this.callToRVN = buildMethodSummary.callToRVN;
            this.callToTEN = buildMethodSummary.callToTEN;
            this.castMap = buildMethodSummary.castMap;
            this.castPredecessors = buildMethodSummary.castPredecessors;
            this.passedAsParameter = buildMethodSummary.passedAsParameter;
            this.bb = buildMethodSummary.bb;
            this.s = buildMethodSummary.s;
            this.change = buildMethodSummary.change;
            this.sync_ops = buildMethodSummary.sync_ops;
            this.nodeCache = buildMethodSummary.nodeCache;
        }

        public BuildMethodSummary(ControlFlowGraph controlFlowGraph) {
            this.this();
            RegisterFactory registerFactory = controlFlowGraph.getRegisterFactory();
            this.nLocals = registerFactory.getLocalSize(PrimordialClassLoader.getJavaLangObject());
            this.nRegisters = this.nLocals + registerFactory.getStackSize(PrimordialClassLoader.getJavaLangObject());
            this.method = controlFlowGraph.getMethod();
            this.start_states = new State[controlFlowGraph.getNumberOfBasicBlocks()];
            this.methodCalls = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            this.callToRVN = new HashMap();
            this.callToTEN = new HashMap();
            this.passedAsParameter = NodeSet.FACTORY.makeSet();
            this.nodeCache = new HashMap();
            this.s = this.start_states[0] = new State(this.nRegisters);
            jq_Type[] jq_TypeArray = this.method.getParamTypes();
            this.param_nodes = new ParamNode[jq_TypeArray.length];
            int n = 0;
            int n2 = 0;
            while (n < jq_TypeArray.length) {
                if (jq_TypeArray[n].isReferenceType()) {
                    this.param_nodes[n] = new ParamNode(this.method, n, (jq_Reference)jq_TypeArray[n]);
                    this.setLocal(n2, this.param_nodes[n]);
                } else if (jq_TypeArray[n].getReferenceSize() == 8) {
                    ++n2;
                }
                ++n;
                ++n2;
            }
            this.my_global = new GlobalNode(this.method);
            this.sync_ops = new HashMap();
            this.castMap = new LinkedHashMap();
            this.castPredecessors = new LinkedHashSet();
            this.returned = NodeSet.FACTORY.makeSet();
            this.thrown = NodeSet.FACTORY.makeSet();
            if (TRACE_INTRA) {
                out.println("Building summary for " + this.method);
            }
            List.BasicBlock basicBlock = controlFlowGraph.reversePostOrder(controlFlowGraph.entry());
            do {
                ListIterator.BasicBlock basicBlock2 = basicBlock.basicBlockIterator();
                this.change = false;
                while (basicBlock2.hasNext()) {
                    this.bb = basicBlock2.nextBasicBlock();
                    this.s = this.start_states[this.bb.getID()];
                    if (this.s == null) continue;
                    this.s = this.s.copy();
                    if (TRACE_INTRA) {
                        out.println("State at beginning of " + this.bb + ':');
                        this.s.dump(out);
                    }
                    this.bb.visitQuads(this);
                    ListIterator.BasicBlock basicBlock3 = this.bb.getSuccessors().basicBlockIterator();
                    while (basicBlock3.hasNext()) {
                        BasicBlock basicBlock4 = basicBlock3.nextBasicBlock();
                        if (this.bb.endsInRet()) {
                            if (this.jsr_states != null) {
                                State state = (State)this.jsr_states.get(basicBlock4);
                                if (state != null) {
                                    JSRInfo jSRInfo = controlFlowGraph.getJSRInfo(this.bb);
                                    boolean[] blArray = jSRInfo.changedLocals;
                                    this.mergeWithJSR(basicBlock4, state, blArray);
                                    continue;
                                }
                                if (!TRACE_INTRA) continue;
                                out.println("jsr before " + basicBlock4 + " not yet visited!");
                                continue;
                            }
                            if (!TRACE_INTRA) continue;
                            out.println("no jsr's visited yet! was looking for jsr successor " + basicBlock4);
                            continue;
                        }
                        this.mergeWith(basicBlock4);
                    }
                }
            } while (this.change);
        }
    }

    public static class PassedParameter
    implements Textualizable {
        final ProgramLocation m;
        final int paramNum;

        public ProgramLocation getCall() {
            return this.m;
        }

        public int getParamNum() {
            return this.paramNum;
        }

        public int hashCode() {
            return this.m.hashCode() ^ this.paramNum;
        }

        public boolean equals(PassedParameter passedParameter) {
            boolean bl = false;
            if (this.m.equals(passedParameter.m) && this.paramNum == passedParameter.paramNum) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof PassedParameter) {
                return this.equals((PassedParameter)object);
            }
            return false;
        }

        public String toString() {
            return "Param " + this.paramNum + " for " + this.m;
        }

        public void write(Textualizer textualizer) throws IOException {
            this.m.write(textualizer);
            textualizer.writeBytes(" " + this.paramNum);
        }

        public void writeEdges(Textualizer textualizer) throws IOException {
        }

        public void addEdge(String string, Textualizable textualizable) {
        }

        public static PassedParameter read(StringTokenizer stringTokenizer) {
            ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            return new PassedParameter(programLocation, n);
        }

        public PassedParameter(ProgramLocation programLocation, int n) {
            this.m = programLocation;
            this.paramNum = n;
        }
    }

    public static class CallSite {
        final MethodSummary caller;
        final ProgramLocation m;

        public MethodSummary getCaller() {
            return this.caller;
        }

        public ProgramLocation getLocation() {
            return this.m;
        }

        public int hashCode() {
            int n = 0;
            if (this.caller != null) {
                n = this.caller.hashCode();
            }
            return n ^ this.m.hashCode();
        }

        public boolean equals(CallSite callSite) {
            boolean bl = false;
            if (this.m.equals(callSite.m) && this.caller == callSite.caller) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof CallSite) {
                return this.equals((CallSite)object);
            }
            return false;
        }

        public String toString() {
            return "" + (this.caller != null ? this.caller.getMethod() : null) + ' ' + this.m.getID() + ' ' + (this.m.getTargetMethod() != null ? this.m.getTargetMethod().getName() : null);
        }

        public CallSite(MethodSummary methodSummary, ProgramLocation programLocation) {
            this.caller = methodSummary;
            this.m = programLocation;
        }
    }

    public static class InsideEdgeNavigator
    implements Navigator {
        public Collection next(Object object) {
            Node node = (Node)object;
            return node.getNonEscapingEdgeTargets();
        }

        public Collection prev(Object object) {
            Node node = (Node)object;
            return node.getPredecessorTargets();
        }
    }

    public static abstract class Node
    implements Textualizable,
    Comparable,
    Variable {
        public static boolean TRACK_REASONS = false;
        private static int current_id = 0;
        protected Map predecessors;
        protected Set passedParameters;
        protected Map addedEdges;
        protected Map accessPathEdges;
        protected final int id;
        private boolean escapes;

        public int hashCode() {
            return this.id;
        }

        public final int compareTo(Node node) {
            if (this.id > node.id) {
                return 1;
            }
            if (this.id == node.id) {
                return 0;
            }
            return -1;
        }

        public final int compareTo(Object object) {
            return this.compareTo((Node)object);
        }

        public boolean isPassedAsParameter() {
            boolean bl = false;
            if (this.passedParameters != null) {
                bl = true;
            }
            return bl;
        }

        public Set getPassedParameters() {
            return this.passedParameters;
        }

        public void replaceBy(Set set, boolean bl) {
            Node node;
            Iterator iterator;
            Object object;
            Object object2;
            Object v;
            Object object3;
            Object object4;
            Iterator iterator2;
            if (TRACE_INTRA) {
                out.println("Replacing " + this + " with " + set + (bl ? ", and removing self" : ""));
            }
            if (set.contains(this)) {
                if (TRACE_INTRA) {
                    out.println("Replacing a node with itself, turning off remove self.");
                }
                set.remove(this);
                if (set.isEmpty()) {
                    if (TRACE_INTRA) {
                        out.println("Replacing a node with only itself! Nothing to do.");
                    }
                    return;
                }
                bl = false;
            }
            if (this.predecessors != null) {
                iterator2 = this.predecessors.entrySet().iterator();
                while (iterator2.hasNext()) {
                    object4 = iterator2.next();
                    object3 = (jq_Field)object4.getKey();
                    v = object4.getValue();
                    if (bl) {
                        iterator2.remove();
                    }
                    if (TRACE_INTRA) {
                        out.println("Looking at predecessor on field " + object3 + ": " + v);
                    }
                    if (v == null) continue;
                    if (v instanceof Node) {
                        object2 = (Node)v;
                        if (bl) {
                            super._removeEdge((jq_Field)object3, this);
                        }
                        if (object2 == this) {
                            if (TRACE_INTRA) {
                                out.println("Adding self-cycles on field " + object3);
                            }
                            object = set.iterator();
                            while (object.hasNext()) {
                                iterator = (Node)object.next();
                                ((Node)((Object)iterator)).addEdge((jq_Field)object3, (Node)((Object)iterator));
                            }
                            continue;
                        }
                        object = set.iterator();
                        while (object.hasNext()) {
                            ((Node)object2).addEdge((jq_Field)object3, (Node)object.next());
                        }
                        continue;
                    }
                    object2 = ((Set)v).iterator();
                    while (object2.hasNext()) {
                        object = (Node)object2.next();
                        if (bl) {
                            object2.remove();
                            super._removeEdge((jq_Field)object3, this);
                        }
                        if (object == this) {
                            if (TRACE_INTRA) {
                                out.println("Adding self-cycles on field " + object3);
                            }
                            iterator = set.iterator();
                            while (iterator.hasNext()) {
                                node = (Node)iterator.next();
                                node.addEdge((jq_Field)object3, node);
                            }
                            continue;
                        }
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            ((Node)object).addEdge((jq_Field)object3, (Node)iterator.next());
                        }
                    }
                }
            }
            if (this.addedEdges != null) {
                iterator2 = this.addedEdges.entrySet().iterator();
                while (iterator2.hasNext()) {
                    object4 = iterator2.next();
                    object3 = (jq_Field)object4.getKey();
                    v = object4.getValue();
                    if (bl) {
                        iterator2.remove();
                    }
                    if (v == null) continue;
                    if (TRACE_INTRA) {
                        out.println("Looking at successor on field " + object3 + ": " + v);
                    }
                    if (v instanceof Node) {
                        object2 = (Node)v;
                        if (object2 == this) continue;
                        if (bl) {
                            boolean bl2 = ((Node)object2).removePredecessor((jq_Field)object3, this);
                            if (TRACE_INTRA) {
                                out.println("Removed " + this + " from predecessor set of " + object2 + '.' + object3);
                            }
                            Assert._assert(bl2);
                        }
                        object = set.iterator();
                        while (object.hasNext()) {
                            iterator = (Node)object.next();
                            ((Node)((Object)iterator)).addEdge((jq_Field)object3, (Node)object2);
                        }
                        continue;
                    }
                    object2 = ((Set)v).iterator();
                    while (object2.hasNext()) {
                        object = (Node)object2.next();
                        if (bl) {
                            object2.remove();
                        }
                        if (object == this) continue;
                        if (bl) {
                            boolean bl3 = ((Node)object).removePredecessor((jq_Field)object3, this);
                            if (TRACE_INTRA) {
                                out.println("Removed " + this + " from predecessor set of " + object + '.' + object3);
                            }
                            Assert._assert(bl3);
                        }
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            node = (Node)iterator.next();
                            node.addEdge((jq_Field)object3, (Node)object);
                        }
                    }
                }
            }
            if (this.accessPathEdges != null) {
                iterator2 = this.accessPathEdges.entrySet().iterator();
                while (iterator2.hasNext()) {
                    object4 = iterator2.next();
                    object3 = (jq_Field)object4.getKey();
                    v = object4.getValue();
                    if (bl) {
                        iterator2.remove();
                    }
                    if (v == null) continue;
                    if (TRACE_INTRA) {
                        out.println("Looking at access path successor on field " + object3 + ": " + v);
                    }
                    if (v instanceof FieldNode) {
                        object2 = (FieldNode)v;
                        if (object2 == this) continue;
                        if (bl) {
                            ((FieldNode)object2).field_predecessors.remove(this);
                            if (TRACE_INTRA) {
                                out.println("Removed " + this + " from access path predecessor set of " + object2);
                            }
                        }
                        object = set.iterator();
                        while (object.hasNext()) {
                            iterator = (Node)object.next();
                            if (TRACE_INTRA) {
                                out.println("Adding access path edge " + iterator + "->" + object2);
                            }
                            ((Node)((Object)iterator)).addAccessPathEdge((jq_Field)object3, (FieldNode)object2);
                        }
                        continue;
                    }
                    object2 = ((Set)v).iterator();
                    while (object2.hasNext()) {
                        object = (FieldNode)object2.next();
                        if (bl) {
                            object2.remove();
                        }
                        if (object == this) continue;
                        if (bl) {
                            ((FieldNode)object).field_predecessors.remove(this);
                        }
                        iterator = set.iterator();
                        while (iterator.hasNext()) {
                            node = (Node)iterator.next();
                            node.addAccessPathEdge((jq_Field)object3, (FieldNode)object);
                        }
                    }
                }
            }
            if (this.passedParameters != null) {
                if (TRACE_INTRA) {
                    out.println("Node " + this + " is passed as parameters: " + this.passedParameters + ", adding those parameters to " + set);
                }
                iterator2 = this.passedParameters.iterator();
                while (iterator2.hasNext()) {
                    object4 = (PassedParameter)((Object)iterator2.next());
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        ((Node)object3.next()).recordPassedParameter((PassedParameter)object4);
                    }
                }
            }
        }

        static void updateMap(Map map, Iterator iterator, Map map2) {
            while (iterator.hasNext()) {
                Set<Object> set;
                Map.Entry entry = (Map.Entry)iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                if (v instanceof Node) {
                    set = map.get(v);
                    if (v instanceof UnknownTypeNode) {
                        set = v;
                    }
                    if (v == GlobalNode.GLOBAL) {
                        set = v;
                    }
                    if (TRACE_INTRA) {
                        out.println("Updated edge " + k + ' ' + v + " to " + set);
                    }
                    map2.put(k, set);
                    continue;
                }
                set = NodeSet.FACTORY.makeSet();
                map2.put(k, set);
                Iterator iterator2 = ((Set)v).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    boolean bl = false;
                    if (e != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    Object object = map.get(e);
                    if (e instanceof UnknownTypeNode) {
                        object = e;
                    }
                    if (e == GlobalNode.GLOBAL) {
                        object = v;
                    }
                    if (TRACE_INTRA) {
                        out.println("Updated edge " + k + ' ' + e + " to " + object);
                    }
                    set.add(object);
                }
            }
        }

        static void addGlobalEdges(Node node) {
            Object e;
            Iterator iterator;
            Object v;
            jq_Field jq_Field2;
            Map.Entry entry;
            Iterator iterator2;
            if (node.predecessors != null) {
                iterator2 = node.predecessors.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    jq_Field2 = (jq_Field)entry.getKey();
                    v = entry.getValue();
                    if (v == GlobalNode.GLOBAL) {
                        GlobalNode.GLOBAL.addEdge(jq_Field2, node);
                        continue;
                    }
                    if (v instanceof UnknownTypeNode) {
                        ((UnknownTypeNode)v).addEdge(jq_Field2, node);
                        continue;
                    }
                    if (!(v instanceof Set)) continue;
                    iterator = ((Set)v).iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (e == GlobalNode.GLOBAL) {
                            GlobalNode.GLOBAL.addEdge(jq_Field2, node);
                            continue;
                        }
                        if (!(e instanceof UnknownTypeNode)) continue;
                        ((UnknownTypeNode)e).addEdge(jq_Field2, node);
                    }
                }
            }
            if (node.addedEdges != null) {
                iterator2 = node.addedEdges.entrySet().iterator();
                while (iterator2.hasNext()) {
                    entry = iterator2.next();
                    jq_Field2 = (jq_Field)entry.getKey();
                    v = entry.getValue();
                    if (v instanceof UnknownTypeNode) {
                        node.addEdge(jq_Field2, (UnknownTypeNode)v);
                        continue;
                    }
                    if (!(v instanceof Set)) continue;
                    iterator = ((Set)v).iterator();
                    while (iterator.hasNext()) {
                        e = iterator.next();
                        if (!(e instanceof UnknownTypeNode)) continue;
                        node.addEdge(jq_Field2, (UnknownTypeNode)e);
                    }
                }
            }
        }

        static void updateMap_unknown(Map map, Iterator iterator, Map map2) {
            while (iterator.hasNext()) {
                Set<Object> set;
                Map.Entry entry = (Map.Entry)iterator.next();
                jq_Field jq_Field2 = (jq_Field)entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                if (v instanceof Node) {
                    set = map.get(v);
                    if (set == null) {
                        set = v;
                    } else if (TRACE_INTRA) {
                        out.println("Updated edge " + jq_Field2 + ' ' + v + " to " + set);
                    }
                    map2.put(jq_Field2, set);
                    continue;
                }
                set = NodeSet.FACTORY.makeSet();
                map2.put(jq_Field2, set);
                Iterator iterator2 = ((Set)v).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    boolean bl = false;
                    if (e != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    Object object = map.get(e);
                    if (object == null) {
                        object = e;
                    } else if (TRACE_INTRA) {
                        out.println("Updated edge " + jq_Field2 + ' ' + e + " to " + object);
                    }
                    set.add(object);
                }
            }
        }

        public void update(HashMap hashMap) {
            Map map;
            if (TRACE_INTRA) {
                out.println("Updating edges for node " + this.toString_long());
            }
            if ((map = this.predecessors) != null) {
                this.predecessors = new LinkedHashMap();
                Node.updateMap(hashMap, map.entrySet().iterator(), this.predecessors);
            }
            if ((map = this.addedEdges) != null) {
                this.addedEdges = new LinkedHashMap();
                Node.updateMap(hashMap, map.entrySet().iterator(), this.addedEdges);
            }
            if ((map = this.accessPathEdges) != null) {
                this.accessPathEdges = new LinkedHashMap();
                Node.updateMap(hashMap, map.entrySet().iterator(), this.accessPathEdges);
            }
            if (this.passedParameters != null) {
                Set set = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
                set.addAll(this.passedParameters);
                this.passedParameters = set;
            }
            Node.addGlobalEdges(this);
        }

        public abstract jq_Reference getDeclaredType();

        public abstract jq_Method getDefiningMethod();

        public abstract Node copy();

        public boolean hasPredecessor(jq_Field jq_Field2, Node node) {
            Object v = this.predecessors.get(jq_Field2);
            if (v instanceof Node) {
                if (node != v) {
                    Assert.UNREACHABLE("predecessor of " + this + " should be " + node + ", but is " + v);
                    return false;
                }
            } else {
                if (v == null) {
                    Assert.UNREACHABLE("predecessor of " + this + " should be " + node + ", but is missing");
                    return false;
                }
                Set set = (Set)v;
                if (!set.contains(node)) {
                    Assert.UNREACHABLE("predecessor of " + this + " should be " + node);
                    return false;
                }
            }
            return true;
        }

        public boolean removePredecessor(jq_Field jq_Field2, Node node) {
            if (this.predecessors == null) {
                return false;
            }
            Object v = this.predecessors.get(jq_Field2);
            if (v instanceof Set) {
                return ((Set)v).remove(node);
            }
            if (v == node) {
                this.predecessors.remove(jq_Field2);
                return true;
            }
            return false;
        }

        public boolean addPredecessor(jq_Field jq_Field2, Node node) {
            Object v;
            if (this.predecessors == null) {
                this.predecessors = new LinkedHashMap();
            }
            if ((v = this.predecessors.get(jq_Field2)) == null) {
                this.predecessors.put(jq_Field2, node);
                return true;
            }
            if (v instanceof Set) {
                return ((Set)v).add(node);
            }
            if (v == node) {
                return false;
            }
            Set set = NodeSet.FACTORY.makeSet();
            set.add(v);
            set.add(node);
            this.predecessors.put(jq_Field2, set);
            return true;
        }

        public Set getPredecessors() {
            if (this.predecessors == null) {
                return Collections.EMPTY_SET;
            }
            return this.predecessors.entrySet();
        }

        public Collection getPredecessorTargets() {
            if (this.predecessors == null) {
                return Collections.EMPTY_SET;
            }
            return new FlattenedCollection(this.predecessors.values());
        }

        public boolean recordPassedParameter(PassedParameter passedParameter) {
            if (this.passedParameters == null) {
                this.passedParameters = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            }
            return this.passedParameters.add(passedParameter);
        }

        public boolean recordPassedParameter(ProgramLocation programLocation, int n) {
            if (this.passedParameters == null) {
                this.passedParameters = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            }
            PassedParameter passedParameter = new PassedParameter(programLocation, n);
            return this.passedParameters.add(passedParameter);
        }

        private final boolean _removeEdge(jq_Field jq_Field2, Node node) {
            Object v = this.addedEdges.get(jq_Field2);
            if (v instanceof Set) {
                return ((Set)v).remove(node);
            }
            if (v == node) {
                this.addedEdges.remove(jq_Field2);
                return true;
            }
            return false;
        }

        public boolean removeEdge(jq_Field jq_Field2, Node node) {
            if (this.addedEdges == null) {
                return false;
            }
            node.removePredecessor(jq_Field2, this);
            return this._removeEdge(jq_Field2, node);
        }

        public boolean hasNonEscapingEdge(jq_Field jq_Field2, Node node) {
            if (this.addedEdges == null) {
                return false;
            }
            Object v = this.addedEdges.get(jq_Field2);
            if (v == node) {
                return true;
            }
            if (v instanceof Set) {
                return ((Set)v).contains(node);
            }
            return false;
        }

        public boolean addEdge(jq_Field jq_Field2, Node node) {
            Object v;
            node.addPredecessor(jq_Field2, this);
            if (this.addedEdges == null) {
                this.addedEdges = new LinkedHashMap();
            }
            if ((v = this.addedEdges.get(jq_Field2)) == null) {
                this.addedEdges.put(jq_Field2, node);
                return true;
            }
            if (v instanceof Set) {
                return ((Set)v).add(node);
            }
            if (v == node) {
                return false;
            }
            Set set = NodeSet.FACTORY.makeSet();
            set.add(v);
            set.add(node);
            this.addedEdges.put(jq_Field2, set);
            return true;
        }

        public boolean addEdges(jq_Field jq_Field2, Set set) {
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                node.addPredecessor(jq_Field2, this);
            }
            if (this.addedEdges == null) {
                this.addedEdges = new LinkedHashMap();
            }
            if ((iterator = this.addedEdges.get(jq_Field2)) == null) {
                this.addedEdges.put(jq_Field2, set);
                return true;
            }
            if (iterator instanceof Set) {
                return ((Set)((Object)iterator)).addAll(set);
            }
            this.addedEdges.put(jq_Field2, set);
            return set.add(iterator);
        }

        public static boolean addEdges(Set set, jq_Field jq_Field2, Node node) {
            boolean bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!node2.addEdge(jq_Field2, node)) continue;
                bl = true;
            }
            return bl;
        }

        private final boolean _removeAccessPathEdge(jq_Field jq_Field2, FieldNode fieldNode) {
            Object v = this.accessPathEdges.get(jq_Field2);
            if (v instanceof Set) {
                return ((Set)v).remove(fieldNode);
            }
            if (v == fieldNode) {
                this.accessPathEdges.remove(jq_Field2);
                return true;
            }
            return false;
        }

        public boolean removeAccessPathEdge(jq_Field jq_Field2, FieldNode fieldNode) {
            if (this.accessPathEdges == null) {
                return false;
            }
            if (fieldNode.field_predecessors != null) {
                fieldNode.field_predecessors.remove(this);
            }
            return this._removeAccessPathEdge(jq_Field2, fieldNode);
        }

        public boolean hasAccessPathEdge(jq_Field jq_Field2, Node node) {
            if (this.accessPathEdges == null) {
                return false;
            }
            Object v = this.accessPathEdges.get(jq_Field2);
            if (v == node) {
                return true;
            }
            if (v instanceof Set) {
                return ((Set)v).contains(node);
            }
            return false;
        }

        public boolean addAccessPathEdge(jq_Field jq_Field2, FieldNode fieldNode) {
            Object v;
            if (fieldNode.field_predecessors == null) {
                fieldNode.field_predecessors = NodeSet.FACTORY.makeSet();
            }
            fieldNode.field_predecessors.add(this);
            if (this.accessPathEdges == null) {
                this.accessPathEdges = new LinkedHashMap();
            }
            if ((v = this.accessPathEdges.get(jq_Field2)) == null) {
                this.accessPathEdges.put(jq_Field2, fieldNode);
                return true;
            }
            if (v instanceof Set) {
                return ((Set)v).add(fieldNode);
            }
            if (v == fieldNode) {
                return false;
            }
            Set set = NodeSet.FACTORY.makeSet();
            set.add(v);
            set.add(fieldNode);
            this.accessPathEdges.put(jq_Field2, set);
            return true;
        }

        public boolean addAccessPathEdges(jq_Field jq_Field2, Set set) {
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                FieldNode fieldNode = (FieldNode)iterator.next();
                if (fieldNode.field_predecessors == null) {
                    fieldNode.field_predecessors = NodeSet.FACTORY.makeSet();
                }
                fieldNode.field_predecessors.add(this);
            }
            if (this.accessPathEdges == null) {
                this.accessPathEdges = new LinkedHashMap();
            }
            if ((iterator = this.accessPathEdges.get(jq_Field2)) == null) {
                this.accessPathEdges.put(jq_Field2, set);
                return true;
            }
            if (iterator instanceof Set) {
                return ((Set)((Object)iterator)).addAll(set);
            }
            this.accessPathEdges.put(jq_Field2, set);
            return set.add(iterator);
        }

        public final void getAllEdges(jq_Field jq_Field2, Set set) {
            Object v;
            if (this.addedEdges != null && (v = this.addedEdges.get(jq_Field2)) != null) {
                if (v instanceof Set) {
                    set.addAll((Set)v);
                } else {
                    set.add(v);
                }
            }
            if (this.escapes) {
                this.getEdges_escaped(jq_Field2, set);
            }
        }

        public final Set getAllEdges(jq_Field jq_Field2) {
            Object object;
            if (this.addedEdges != null && (object = this.addedEdges.get(jq_Field2)) != null) {
                if (object instanceof Set) {
                    Set set = NodeSet.FACTORY.makeSet((Set)object);
                    if (this.escapes) {
                        this.getEdges_escaped(jq_Field2, set);
                    }
                    return set;
                }
                if (this.escapes) {
                    Set set = NodeSet.FACTORY.makeSet(2);
                    set.add(object);
                    this.getEdges_escaped(jq_Field2, set);
                    return set;
                }
                return Collections.singleton(object);
            }
            if (this.escapes) {
                object = NodeSet.FACTORY.makeSet(1);
                this.getEdges_escaped(jq_Field2, (Set)object);
                return object;
            }
            return Collections.EMPTY_SET;
        }

        public final Set getAllEdges() {
            if (this.escapes) {
                jq_Reference jq_Reference2 = this.getDeclaredType();
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                if (jq_Reference2 instanceof jq_Class) {
                    jq_Class jq_Class2 = (jq_Class)jq_Reference2;
                    jq_Class2.prepare();
                    Iterator<jq_InstanceField> iterator = java.util.Arrays.asList(jq_Class2.getInstanceFields()).iterator();
                    while (iterator.hasNext()) {
                        jq_InstanceField jq_InstanceField2 = iterator.next();
                        if (!jq_InstanceField2.getType().isReferenceType()) continue;
                        Set set = NodeSet.FACTORY.makeSet();
                        this.getEdges_escaped(jq_InstanceField2, set);
                        linkedHashSet.add(new Map.Entry(this, jq_InstanceField2, set){
                            final /* synthetic */ Node this$0;
                            final /* synthetic */ jq_InstanceField val$f;
                            final /* synthetic */ Set val$r;

                            public final Object getKey() {
                                return this.val$f;
                            }

                            public final Object getValue() {
                                return this.val$r;
                            }

                            public final Object setValue(Object object) {
                                throw new UnsupportedOperationException();
                            }
                            {
                                this.this$0 = node;
                                this.val$f = jq_InstanceField2;
                                this.val$r = set;
                            }
                        });
                    }
                }
                if (this.addedEdges != null) {
                    linkedHashSet.addAll(this.addedEdges.entrySet());
                }
                return linkedHashSet;
            }
            if (this.addedEdges != null) {
                return this.addedEdges.entrySet();
            }
            return Collections.EMPTY_SET;
        }

        public final Set getNonEscapingEdges(jq_Field jq_Field2) {
            if (this.addedEdges == null) {
                return Collections.EMPTY_SET;
            }
            Object v = this.addedEdges.get(jq_Field2);
            if (v == null) {
                return Collections.EMPTY_SET;
            }
            if (v instanceof Set) {
                return (Set)v;
            }
            return Collections.singleton(v);
        }

        public void getEdges_escaped(jq_Field jq_Field2, Set set) {
            if (TRACE_INTER) {
                out.println("Getting escaped edges " + this + '.' + jq_Field2);
            }
            jq_Reference jq_Reference2 = this.getDeclaredType();
            if (jq_Field2 == null) {
                if (jq_Reference2 != null && (jq_Reference2.isArrayType() || jq_Reference2 == PrimordialClassLoader.getJavaLangObject())) {
                    set.add(UnknownTypeNode.get(PrimordialClassLoader.getJavaLangObject()));
                }
                return;
            }
            if (jq_Reference2 != null) {
                jq_Reference2.prepare();
                jq_Field2.getDeclaringClass().prepare();
                if (TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass()) || TypeCheck.isAssignable(jq_Field2.getDeclaringClass(), jq_Reference2)) {
                    jq_Reference jq_Reference3 = (jq_Reference)jq_Field2.getType();
                    set.add(UnknownTypeNode.get(jq_Reference3));
                } else if (TRACE_INTER) {
                    out.println("Object of type " + jq_Reference2 + " cannot possibly have field " + jq_Field2);
                }
            }
            if (TRACE_INTER) {
                out.println("New result: " + set);
            }
        }

        public Set getNonEscapingEdges() {
            if (this.addedEdges == null) {
                return Collections.EMPTY_SET;
            }
            return this.addedEdges.entrySet();
        }

        public Set getNonEscapingEdgeFields() {
            if (this.addedEdges == null) {
                return Collections.EMPTY_SET;
            }
            return this.addedEdges.keySet();
        }

        public Collection getNonEscapingEdgeTargets() {
            if (this.addedEdges == null) {
                return Collections.EMPTY_SET;
            }
            return new FlattenedCollection(this.addedEdges.values());
        }

        public boolean hasNonEscapingEdges() {
            boolean bl = false;
            if (this.addedEdges != null) {
                bl = true;
            }
            return bl;
        }

        public boolean hasAccessPathEdges() {
            boolean bl = false;
            if (this.accessPathEdges != null) {
                bl = true;
            }
            return bl;
        }

        public final Set getAccessPathEdges(jq_Field jq_Field2) {
            if (this.accessPathEdges == null) {
                return Collections.EMPTY_SET;
            }
            Object v = this.accessPathEdges.get(jq_Field2);
            if (v == null) {
                return Collections.EMPTY_SET;
            }
            if (v instanceof Set) {
                return (Set)v;
            }
            return Collections.singleton(v);
        }

        public void getAccessPathEdges(jq_Field jq_Field2, Set set) {
            if (this.accessPathEdges == null) {
                return;
            }
            Object v = this.accessPathEdges.get(jq_Field2);
            if (v == null) {
                return;
            }
            if (v instanceof Set) {
                set.addAll((Set)v);
            } else {
                set.add(v);
            }
        }

        public Set getAccessPathEdges() {
            if (this.accessPathEdges == null) {
                return Collections.EMPTY_SET;
            }
            return this.accessPathEdges.entrySet();
        }

        public Set getAccessPathEdgeFields() {
            if (this.accessPathEdges == null) {
                return Collections.EMPTY_SET;
            }
            return this.accessPathEdges.keySet();
        }

        public Collection getAccessPathEdgeTargets() {
            if (this.accessPathEdges == null) {
                return Collections.EMPTY_SET;
            }
            return new FlattenedCollection(this.accessPathEdges.values());
        }

        public void setEscapes() {
            this.escapes = true;
        }

        public boolean getEscapes() {
            return this.escapes;
        }

        public abstract String toString_short();

        public String toString() {
            return this.toString_short() + (this.escapes ? "*" : "");
        }

        public String toString_long() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.addedEdges != null) {
                stringBuffer.append(" writes: ");
                Iterator iterator = this.addedEdges.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    jq_Field jq_Field2 = (jq_Field)entry.getKey();
                    Object v = entry.getValue();
                    if (v == null) continue;
                    stringBuffer.append(jq_Field2);
                    stringBuffer.append("={");
                    if (v instanceof Node) {
                        stringBuffer.append(((Node)v).toString_short());
                    } else {
                        Iterator iterator2 = ((Set)v).iterator();
                        while (iterator2.hasNext()) {
                            stringBuffer.append(((Node)iterator2.next()).toString_short());
                            if (!iterator2.hasNext()) continue;
                            stringBuffer.append(", ");
                        }
                    }
                    stringBuffer.append("} ");
                }
            }
            if (this.accessPathEdges != null) {
                stringBuffer.append(" reads: ");
                stringBuffer.append(this.accessPathEdges);
            }
            if (this.passedParameters != null) {
                stringBuffer.append(" called: ");
                stringBuffer.append(this.passedParameters);
            }
            return stringBuffer.toString();
        }

        public void write(Textualizer textualizer) throws IOException {
            Node node;
            Iterator<Object> iterator;
            Collection<Object> collection;
            jq_Field jq_Field2;
            Object object;
            Iterator iterator2;
            if (this.addedEdges != null) {
                iterator2 = this.getNonEscapingEdges().iterator();
                while (iterator2.hasNext()) {
                    object = (Map.Entry)iterator2.next();
                    jq_Field2 = (jq_Field)object.getKey();
                    collection = object.getValue() instanceof Collection ? (Set)object.getValue() : Collections.singleton(object.getValue());
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        node = (Node)iterator.next();
                        if (!textualizer.contains(node)) continue;
                        textualizer.writeBytes(" succ ");
                        if (jq_Field2 == null) {
                            textualizer.writeBytes("null");
                        } else {
                            jq_Field2.write(textualizer);
                        }
                        textualizer.writeBytes(" ");
                        textualizer.writeReference(node);
                    }
                }
            }
            if (this.predecessors != null) {
                iterator2 = this.getPredecessors().iterator();
                while (iterator2.hasNext()) {
                    object = (Map.Entry)iterator2.next();
                    jq_Field2 = (jq_Field)object.getKey();
                    collection = object.getValue() instanceof Collection ? (Collection)object.getValue() : Collections.singleton(object.getValue());
                    iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        node = (Node)iterator.next();
                        if (!textualizer.contains(node)) continue;
                        textualizer.writeBytes(" pred ");
                        if (jq_Field2 == null) {
                            textualizer.writeBytes("null");
                        } else {
                            jq_Field2.write(textualizer);
                        }
                        textualizer.writeBytes(" ");
                        textualizer.writeReference(node);
                    }
                }
            }
            if (this.accessPathEdges != null) {
                iterator2 = this.getAccessPathEdgeTargets().iterator();
                while (iterator2.hasNext()) {
                    object = (Node)iterator2.next();
                    if (!textualizer.contains((Textualizable)object)) continue;
                    textualizer.writeEdge("fsucc", (Textualizable)object);
                }
            }
        }

        public void readEdges(IndexMap indexMap, StringTokenizer stringTokenizer) {
            while (stringTokenizer.hasMoreElements()) {
                Node node;
                String string = stringTokenizer.nextToken();
                if (string.equals("succ")) {
                    jq_Field jq_Field2 = (jq_Field)jq_Member.read(stringTokenizer);
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= indexMap.size()) continue;
                    this.addEdge(jq_Field2, (Node)indexMap.get(n));
                    continue;
                }
                if (string.equals("pred")) {
                    jq_Field jq_Field3 = (jq_Field)jq_Member.read(stringTokenizer);
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= indexMap.size()) continue;
                    node = (Node)indexMap.get(n);
                    node.addEdge(jq_Field3, this);
                    continue;
                }
                if (string.equals("fsucc")) {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= indexMap.size()) continue;
                    FieldNode fieldNode = (FieldNode)indexMap.get(n);
                    this.addAccessPathEdge(fieldNode.getField(), fieldNode);
                    continue;
                }
                if (string.equals("fpred")) {
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= indexMap.size()) continue;
                    Node node2 = (Node)indexMap.get(n);
                    node = (FieldNode)this;
                    node2.addAccessPathEdge(((FieldNode)node).getField(), (FieldNode)node);
                    continue;
                }
                Assert.UNREACHABLE(string);
            }
        }

        public void addEdge(String string, Textualizable textualizable) {
        }

        public void writeEdges(Textualizer textualizer) throws IOException {
        }

        static /* synthetic */ boolean access$0(Node node) {
            return node.escapes;
        }

        protected Node() {
            this.id = ++current_id;
        }

        protected Node(Node node) {
            this.predecessors = node.predecessors;
            this.passedParameters = node.passedParameters;
            this.addedEdges = node.addedEdges;
            this.accessPathEdges = node.accessPathEdges;
            this.id = ++current_id;
            this.escapes = node.escapes;
        }
    }

    public static final class CheckCastNode
    extends Node {
        jq_Reference dstType;
        final ProgramLocation q;

        public final String toString_short() {
            return "(" + this.dstType.shortName() + ") @ " + this.q;
        }

        public final Node copy() {
            return new CheckCastNode(this);
        }

        public final jq_Reference getDeclaredType() {
            return this.dstType;
        }

        public final jq_Method getDefiningMethod() {
            return this.q.getMethod();
        }

        public final ProgramLocation getLocation() {
            return this.q;
        }

        public final void write(Textualizer textualizer) throws IOException {
            this.dstType.write(textualizer);
            textualizer.writeBytes(" ");
            this.q.write(textualizer);
            super.write(textualizer);
        }

        public static final Node read(StringTokenizer stringTokenizer) {
            jq_Reference jq_Reference2 = (jq_Reference)jq_Type.read(stringTokenizer);
            ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
            CheckCastNode checkCastNode = new CheckCastNode(jq_Reference2, programLocation);
            return checkCastNode;
        }

        public CheckCastNode(jq_Reference jq_Reference2, ProgramLocation programLocation) {
            this.dstType = jq_Reference2;
            this.q = programLocation;
        }

        public CheckCastNode(CheckCastNode checkCastNode) {
            super(checkCastNode);
            this.dstType = checkCastNode.dstType;
            this.q = checkCastNode.q;
        }
    }

    public static final class ConcreteTypeNode
    extends Node
    implements HeapObject {
        static final HashMap FACTORY = new HashMap();
        final jq_Reference type;
        final ProgramLocation q;

        public static final ConcreteTypeNode get(jq_Reference jq_Reference2) {
            ConcreteTypeNode concreteTypeNode = (ConcreteTypeNode)FACTORY.get(jq_Reference2);
            if (concreteTypeNode == null) {
                concreteTypeNode = new ConcreteTypeNode(jq_Reference2);
                FACTORY.put(jq_Reference2, concreteTypeNode);
            }
            return concreteTypeNode;
        }

        public final Node copy() {
            return new ConcreteTypeNode(this);
        }

        public final ProgramLocation getLocation() {
            return this.q;
        }

        public final jq_Method getDefiningMethod() {
            if (this.q == null) {
                return null;
            }
            return this.q.getMethod();
        }

        public final jq_Reference getDeclaredType() {
            return this.type;
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "Concrete: " + (this.type == null ? "null" : this.type.shortName()) + " @ " + (this.q == null ? -1 : this.q.getID());
        }

        public final void write(Textualizer textualizer) throws IOException {
            if (this.type == null) {
                textualizer.writeBytes("null ");
            } else {
                this.type.write(textualizer);
                textualizer.writeBytes(" ");
            }
            if (this.q == null) {
                textualizer.writeBytes("null");
            } else {
                this.q.write(textualizer);
            }
            super.write(textualizer);
        }

        public static final ConcreteTypeNode read(StringTokenizer stringTokenizer) {
            jq_Reference jq_Reference2 = (jq_Reference)jq_Type.read(stringTokenizer);
            ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
            ConcreteTypeNode concreteTypeNode = new ConcreteTypeNode(jq_Reference2, programLocation);
            return concreteTypeNode;
        }

        public ConcreteTypeNode(jq_Reference jq_Reference2) {
            this.type = jq_Reference2;
            this.q = null;
        }

        public ConcreteTypeNode(jq_Reference jq_Reference2, ProgramLocation programLocation) {
            this.type = jq_Reference2;
            this.q = programLocation;
        }

        private ConcreteTypeNode(ConcreteTypeNode concreteTypeNode) {
            super(concreteTypeNode);
            this.type = concreteTypeNode.type;
            this.q = concreteTypeNode.q;
        }
    }

    public static final class ConcreteObjectNode
    extends Node
    implements HeapObject {
        public static final boolean ADD_EDGES = true;
        static final HashMap FACTORY = new HashMap();
        final Object object;

        public static final Collection getAll() {
            return FACTORY.values();
        }

        public static final ConcreteObjectNode get(Object object) {
            ConcreteObjectNode concreteObjectNode;
            block4: {
                jq_Reference jq_Reference2;
                block5: {
                    concreteObjectNode = (ConcreteObjectNode)FACTORY.get(object);
                    if (concreteObjectNode != null) {
                        return concreteObjectNode;
                    }
                    concreteObjectNode = new ConcreteObjectNode(object);
                    FACTORY.put(object, concreteObjectNode);
                    if (object == null) break block4;
                    jq_Reference2 = jq_Reference.getTypeOf(object);
                    if (!jq_Reference2.isClassType()) break block5;
                    jq_Class jq_Class2 = (jq_Class)jq_Reference2;
                    jq_Class2.prepare();
                    jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
                    int n = 0;
                    while (n < jq_InstanceFieldArray.length) {
                        if (!jq_InstanceFieldArray[n].getType().isPrimitiveType()) {
                            Object object2 = Reflection.getfield_A(object, jq_InstanceFieldArray[n]);
                            concreteObjectNode.addEdge(jq_InstanceFieldArray[n], ConcreteObjectNode.get(object2));
                        }
                        ++n;
                    }
                    break block4;
                }
                Assert._assert(jq_Reference2.isArrayType());
                jq_Array jq_Array2 = (jq_Array)jq_Reference2;
                if (!jq_Array2.getElementType().isReferenceType()) break block4;
                Object[] objectArray = (Object[])object;
                int n = 0;
                while (n < objectArray.length) {
                    concreteObjectNode.addEdge(null, ConcreteObjectNode.get(objectArray[n]));
                    ++n;
                }
            }
            return concreteObjectNode;
        }

        public final ProgramLocation getLocation() {
            return null;
        }

        public final Node copy() {
            return new ConcreteObjectNode(this);
        }

        public final jq_Method getDefiningMethod() {
            return null;
        }

        public final jq_Reference getDeclaredType() {
            if (this.object == null) {
                return null;
            }
            return jq_Reference.getTypeOf(this.object);
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "Object " + this.getDeclaredType();
        }

        public final Set getNonEscapingEdgeFields() {
            return super.getNonEscapingEdgeFields();
        }

        public final Set getEdges() {
            return super.getNonEscapingEdges();
        }

        public final boolean hasNonEscapingEdge(jq_Field jq_Field2, Node node) {
            return super.hasNonEscapingEdge(jq_Field2, node);
        }

        public final boolean hasEdges() {
            return super.hasNonEscapingEdges();
        }

        public final boolean removeEdge(jq_Field jq_Field2, Node node) {
            Assert._assert(node instanceof ConcreteObjectNode ^ true);
            return super.removeEdge(jq_Field2, node);
        }

        public final void write(Textualizer textualizer) throws IOException {
            jq_Reference jq_Reference2 = this.getDeclaredType();
            if (jq_Reference2 == null) {
                textualizer.writeBytes("null");
            } else {
                jq_Reference2.write(textualizer);
            }
            super.write(textualizer);
        }

        public static final Node read(StringTokenizer stringTokenizer) {
            jq_Reference jq_Reference2 = (jq_Reference)jq_Type.read(stringTokenizer);
            return new ConcreteTypeNode(jq_Reference2);
        }

        public ConcreteObjectNode(Object object) {
            this.object = object;
        }

        private ConcreteObjectNode(ConcreteObjectNode concreteObjectNode) {
            super(concreteObjectNode);
            this.object = concreteObjectNode.object;
        }
    }

    public static final class UnknownTypeNode
    extends Node
    implements HeapObject {
        public static final boolean ADD_DUMMY_EDGES = false;
        static final HashMap FACTORY = new HashMap();
        final jq_Reference type;

        public static final UnknownTypeNode get(jq_Reference jq_Reference2) {
            UnknownTypeNode unknownTypeNode = (UnknownTypeNode)FACTORY.get(jq_Reference2);
            if (unknownTypeNode == null) {
                unknownTypeNode = new UnknownTypeNode(jq_Reference2);
                FACTORY.put(jq_Reference2, unknownTypeNode);
            }
            return unknownTypeNode;
        }

        public static final Collection getAll() {
            return FACTORY.values();
        }

        private final void addDummyEdges() {
            if (this.type instanceof jq_Class) {
                jq_Class jq_Class2 = (jq_Class)this.type;
                jq_Class2.prepare();
                jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
                int n = 0;
                while (n < jq_InstanceFieldArray.length) {
                    jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n];
                    if (jq_InstanceField2.getType() instanceof jq_Reference) {
                        UnknownTypeNode unknownTypeNode = UnknownTypeNode.get((jq_Reference)jq_InstanceField2.getType());
                        this.addEdge(jq_InstanceField2, unknownTypeNode);
                    }
                    ++n;
                }
            } else {
                jq_Array jq_Array2 = (jq_Array)this.type;
                if (jq_Array2.getElementType() instanceof jq_Reference) {
                    UnknownTypeNode unknownTypeNode = UnknownTypeNode.get((jq_Reference)jq_Array2.getElementType());
                    this.addEdge(null, unknownTypeNode);
                }
            }
        }

        public final void update(HashMap hashMap) {
        }

        public final ProgramLocation getLocation() {
            return null;
        }

        public final jq_Method getDefiningMethod() {
            return null;
        }

        public final jq_Reference getDeclaredType() {
            return this.type;
        }

        public final Node copy() {
            return this;
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "Unknown: " + this.type;
        }

        public final void write(Textualizer textualizer) throws IOException {
            this.getDeclaredType().write(textualizer);
            super.write(textualizer);
        }

        public static final UnknownTypeNode read(StringTokenizer stringTokenizer) {
            jq_Reference jq_Reference2 = (jq_Reference)jq_Type.read(stringTokenizer);
            return new UnknownTypeNode(jq_Reference2);
        }

        private UnknownTypeNode(jq_Reference jq_Reference2) {
            this.type = jq_Reference2;
            this.setEscapes();
        }
    }

    public static abstract class OutsideNode
    extends Node {
        public OutsideNode skip;
        public boolean visited;

        public abstract jq_Reference getDeclaredType();

        OutsideNode() {
        }

        OutsideNode(Node node) {
            super(node);
        }
    }

    public static final class GlobalNode
    extends OutsideNode {
        public static GlobalNode GLOBAL = new GlobalNode(null);
        jq_Method method;

        public final jq_Reference getDeclaredType() {
            return null;
        }

        public final jq_Method getDefiningMethod() {
            return this.method;
        }

        public final Node copy() {
            boolean bl = false;
            if (this != GLOBAL) {
                bl = true;
            }
            Assert._assert(bl);
            return new GlobalNode(this);
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "global(" + (this.method == null ? null : this.method.getName()) + ')';
        }

        public final void addDefaultStatics() {
            jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/lang/System;");
            jq_Class2.load();
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Class2.getDeclaredMember("in", "Ljava/io/InputStream;");
            boolean bl = false;
            if (jq_StaticField2 != null) {
                bl = true;
            }
            Assert._assert(bl);
            ConcreteObjectNode concreteObjectNode = ConcreteObjectNode.get(System.in);
            this.addEdge(jq_StaticField2, concreteObjectNode);
            jq_StaticField2 = (jq_StaticField)jq_Class2.getDeclaredMember("out", "Ljava/io/PrintStream;");
            boolean bl2 = false;
            if (jq_StaticField2 != null) {
                bl2 = true;
            }
            Assert._assert(bl2);
            concreteObjectNode = ConcreteObjectNode.get(System.out);
            this.addEdge(jq_StaticField2, concreteObjectNode);
            jq_StaticField2 = (jq_StaticField)jq_Class2.getDeclaredMember("err", "Ljava/io/PrintStream;");
            boolean bl3 = false;
            if (jq_StaticField2 != null) {
                bl3 = true;
            }
            Assert._assert(bl3);
            concreteObjectNode = ConcreteObjectNode.get(System.err);
            this.addEdge(jq_StaticField2, concreteObjectNode);
        }

        public final void write(Textualizer textualizer) throws IOException {
            if (this.method == null) {
                textualizer.writeBytes("null");
            } else {
                this.method.write(textualizer);
            }
            super.write(textualizer);
        }

        public static final GlobalNode read(StringTokenizer stringTokenizer) {
            jq_Method jq_Method2 = (jq_Method)jq_Member.read(stringTokenizer);
            return new GlobalNode(jq_Method2);
        }

        public GlobalNode(jq_Method jq_Method2) {
            this.method = jq_Method2;
            if (TRACE_INTRA) {
                out.println("Created " + this.toString_long());
            }
        }

        private GlobalNode(GlobalNode globalNode) {
            super(globalNode);
            this.method = globalNode.method;
        }
    }

    public static abstract class ReturnedNode
    extends OutsideNode {
        final ProgramLocation m;

        public jq_Method getDefiningMethod() {
            return this.m.getMethod();
        }

        public final ProgramLocation getLocation() {
            return this.m;
        }

        public ReturnedNode(ProgramLocation programLocation) {
            this.m = programLocation;
        }

        public ReturnedNode(ReturnedNode returnedNode) {
            super(returnedNode);
            this.m = returnedNode.m;
        }
    }

    public static final class ReturnValueNode
    extends ReturnedNode {
        public final jq_Reference getDeclaredType() {
            return (jq_Reference)this.m.getTargetMethod().getReturnType();
        }

        public final Node copy() {
            return new ReturnValueNode(this);
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "Return value of " + this.m;
        }

        public final void write(Textualizer textualizer) throws IOException {
            this.m.write(textualizer);
            super.write(textualizer);
        }

        public static final ReturnValueNode read(StringTokenizer stringTokenizer) {
            ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
            return new ReturnValueNode(programLocation);
        }

        public ReturnValueNode(ProgramLocation programLocation) {
            super(programLocation);
        }

        private ReturnValueNode(ReturnValueNode returnValueNode) {
            super(returnValueNode);
        }
    }

    public static final class ThrownExceptionNode
    extends ReturnedNode {
        public final jq_Reference getDeclaredType() {
            return PrimordialClassLoader.getJavaLangObject();
        }

        public final Node copy() {
            return new ThrownExceptionNode(this);
        }

        public final String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public final String toString_short() {
            return "Thrown exception of " + this.m;
        }

        public final void write(Textualizer textualizer) throws IOException {
            this.m.write(textualizer);
            super.write(textualizer);
        }

        public static final ThrownExceptionNode read(StringTokenizer stringTokenizer) {
            ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
            return new ThrownExceptionNode(programLocation);
        }

        public ThrownExceptionNode(ProgramLocation programLocation) {
            super(programLocation);
        }

        private ThrownExceptionNode(ThrownExceptionNode thrownExceptionNode) {
            super(thrownExceptionNode);
        }
    }

    public static class ParamNode
    extends OutsideNode {
        final jq_Method m;
        final int n;
        final jq_Reference declaredType;

        public jq_Reference getDeclaredType() {
            return this.declaredType;
        }

        public jq_Method getDefiningMethod() {
            return this.m;
        }

        public jq_Method getMethod() {
            return this.m;
        }

        public int getIndex() {
            return this.n;
        }

        public Node copy() {
            return new ParamNode(this);
        }

        public String toString_long() {
            return Integer.toHexString(this.hashCode()) + ": " + this.toString_short() + super.toString_long();
        }

        public String toString_short() {
            return "Param#" + this.n + " method " + this.m.getName();
        }

        public void write(Textualizer textualizer) throws IOException {
            this.m.write(textualizer);
            textualizer.writeBytes(" " + this.n);
            super.write(textualizer);
        }

        public static ParamNode read(StringTokenizer stringTokenizer) {
            jq_Method jq_Method2 = (jq_Method)jq_Member.read(stringTokenizer);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            jq_Reference jq_Reference2 = (jq_Reference)jq_Method2.getParamTypes()[n];
            return new ParamNode(jq_Method2, n, jq_Reference2);
        }

        public ParamNode(jq_Method jq_Method2, int n, jq_Reference jq_Reference2) {
            this.m = jq_Method2;
            this.n = n;
            this.declaredType = jq_Reference2;
        }

        private ParamNode(ParamNode paramNode) {
            this.m = paramNode.m;
            this.n = paramNode.n;
            this.declaredType = paramNode.declaredType;
        }
    }

    public static final class FakeParamNode
    extends ParamNode {
        public final Node copy() {
            return new FakeParamNode(this);
        }

        public static final ParamNode read(StringTokenizer stringTokenizer) {
            jq_Method jq_Method2 = (jq_Method)jq_FakeInstanceMethod.read(stringTokenizer);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            jq_Reference jq_Reference2 = (jq_Reference)jq_Method2.getParamTypes()[n];
            return new FakeParamNode(jq_Method2, n, jq_Reference2);
        }

        public FakeParamNode(jq_Method jq_Method2, int n, jq_Reference jq_Reference2) {
            super(jq_Method2, n, jq_Reference2);
        }

        private FakeParamNode(FakeParamNode fakeParamNode) {
            super(fakeParamNode);
        }
    }

    public static final class FieldNode
    extends OutsideNode {
        final jq_Field f;
        final Set locs;
        Set field_predecessors;

        private static final FieldNode findPredecessor(FieldNode fieldNode, ProgramLocation programLocation) {
            if (TRACE_INTRA) {
                out.println("Checking " + fieldNode + " for predecessor " + programLocation.getID());
            }
            if (fieldNode.locs.contains(programLocation)) {
                if (TRACE_INTRA) {
                    out.println("Success!");
                }
                return fieldNode;
            }
            if (fieldNode.visited) {
                if (TRACE_INTRA) {
                    out.println(fieldNode + " already visited");
                }
                return null;
            }
            fieldNode.visited = true;
            if (fieldNode.field_predecessors != null) {
                Iterator iterator = fieldNode.field_predecessors.iterator();
                while (iterator.hasNext()) {
                    FieldNode fieldNode2;
                    FieldNode fieldNode3;
                    Object e = iterator.next();
                    if (!(e instanceof FieldNode) || (fieldNode3 = FieldNode.findPredecessor(fieldNode2 = (FieldNode)e, programLocation)) == null) continue;
                    fieldNode.visited = false;
                    return fieldNode3;
                }
            }
            fieldNode.visited = false;
            return null;
        }

        public static final FieldNode get(Node node, jq_Field jq_Field2, ProgramLocation programLocation) {
            Object object;
            if (TRACE_INTRA) {
                out.println("Getting field node for " + node + (jq_Field2 == null ? "[]" : "." + jq_Field2.getName()) + " loc " + (programLocation == null ? -1 : programLocation.getID()));
            }
            Set set = null;
            if (node.accessPathEdges != null) {
                object = node.accessPathEdges.get(jq_Field2);
                if (object instanceof FieldNode) {
                    if (TRACE_INTRA) {
                        out.println("Field node for " + node + " already exists, reusing: " + object);
                    }
                    return (FieldNode)object;
                }
                if (object != null && !(set = (Set)object).isEmpty()) {
                    if (TRACE_INTRA) {
                        out.println("Field node for " + node + " already exists, reusing: " + object);
                    }
                    return (FieldNode)set.iterator().next();
                }
            } else {
                node.accessPathEdges = new LinkedHashMap();
            }
            if ((object = node instanceof FieldNode ? FieldNode.findPredecessor((FieldNode)node, programLocation) : null) == null) {
                object = new FieldNode(jq_Field2, programLocation);
                if (TRACE_INTRA) {
                    out.println("Created field node: " + ((FieldNode)object).toString_long());
                }
            } else if (TRACE_INTRA) {
                out.println("Using existing field node: " + ((FieldNode)object).toString_long());
            }
            if (((FieldNode)object).field_predecessors == null) {
                ((FieldNode)object).field_predecessors = NodeSet.FACTORY.makeSet();
            }
            ((FieldNode)object).field_predecessors.add(node);
            if (set != null) {
                set.add(object);
            } else {
                node.accessPathEdges.put(jq_Field2, object);
            }
            if (TRACE_INTRA) {
                out.println("Final field node: " + ((FieldNode)object).toString_long());
            }
            return object;
        }

        public static final FieldNode unify(jq_Field jq_Field2, Set set) {
            FieldNode fieldNode;
            if (TRACE_INTRA) {
                out.println("Unifying the set of field nodes: " + set);
            }
            FieldNode fieldNode2 = new FieldNode(jq_Field2);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                fieldNode = (FieldNode)iterator.next();
                boolean bl = false;
                if (jq_Field2 == fieldNode.f) {
                    bl = true;
                }
                Assert._assert(bl);
                fieldNode2.locs.addAll(fieldNode.locs);
            }
            iterator = set.iterator();
            while (iterator.hasNext()) {
                fieldNode = (FieldNode)iterator.next();
                Set<FieldNode> set2 = Collections.singleton(fieldNode2);
                fieldNode.replaceBy(set2, true);
            }
            if (TRACE_INTRA) {
                out.println("Resulting field node: " + fieldNode2.toString_long());
            }
            return fieldNode2;
        }

        public final void replaceBy(Set set, boolean bl) {
            if (TRACE_INTRA) {
                out.println("Replacing " + this + " with " + set + (bl ? ", and removing self" : ""));
            }
            if (set.contains(this)) {
                if (TRACE_INTRA) {
                    out.println("Replacing a node with itself, turning off remove self.");
                }
                set.remove(this);
                if (set.isEmpty()) {
                    if (TRACE_INTRA) {
                        out.println("Replacing a node with only itself! Nothing to do.");
                    }
                    return;
                }
                bl = false;
            }
            if (this.field_predecessors != null) {
                Iterator iterator = this.field_predecessors.iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2;
                    Node node = (Node)iterator.next();
                    boolean bl2 = false;
                    if (node != null) {
                        bl2 = true;
                    }
                    Assert._assert(bl2);
                    if (bl) {
                        iterator.remove();
                        node._removeAccessPathEdge(this.f, this);
                    }
                    if (node == this) {
                        if (TRACE_INTRA) {
                            out.println("Found self-cycle on outside edge of " + node);
                        }
                        iterator2 = set.iterator();
                        while (iterator2.hasNext()) {
                            FieldNode fieldNode = (FieldNode)iterator2.next();
                            fieldNode.addAccessPathEdge(this.f, fieldNode);
                        }
                        continue;
                    }
                    iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        node.addAccessPathEdge(this.f, (FieldNode)iterator2.next());
                    }
                }
            }
            super.replaceBy(set, bl);
        }

        static final void addGlobalAccessPathEdges(FieldNode fieldNode) {
            if (fieldNode.field_predecessors == null) {
                return;
            }
            jq_Field jq_Field2 = fieldNode.f;
            Iterator iterator = fieldNode.field_predecessors.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == GlobalNode.GLOBAL) {
                    GlobalNode.GLOBAL.addAccessPathEdge(jq_Field2, fieldNode);
                    continue;
                }
                if (!(e instanceof UnknownTypeNode)) continue;
                ((UnknownTypeNode)e).addAccessPathEdge(jq_Field2, fieldNode);
            }
        }

        public final void update(HashMap hashMap) {
            super.update(hashMap);
            Set set = this.field_predecessors;
            if (set != null) {
                this.field_predecessors = NodeSet.FACTORY.makeSet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    boolean bl = false;
                    if (e != null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    Object object = hashMap.get(e);
                    if (e instanceof UnknownTypeNode) {
                        object = e;
                    }
                    if (e == GlobalNode.GLOBAL) {
                        object = e;
                    }
                    this.field_predecessors.add(object);
                }
                FieldNode.addGlobalAccessPathEdges(this);
            }
        }

        public final Set getAccessPathPredecessors() {
            if (this.field_predecessors == null) {
                return Collections.EMPTY_SET;
            }
            return this.field_predecessors;
        }

        public final jq_Field getField() {
            return this.f;
        }

        public final jq_Method getDefiningMethod() {
            Iterator iterator = this.locs.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            return ((ProgramLocation)iterator.next()).getMethod();
        }

        public final Set getLocations() {
            return this.locs;
        }

        public final String fieldName() {
            if (this.f != null) {
                return this.f.getName().toString();
            }
            return this.getDeclaredType() + "[]";
        }

        public final Node copy() {
            return new FieldNode(this);
        }

        public final jq_Reference getDeclaredType() {
            if (this.f != null) {
                return (jq_Reference)this.f.getType();
            }
            if (this.locs.isEmpty()) {
                return PrimordialClassLoader.getJavaLangObject();
            }
            return (jq_Reference)((ProgramLocation)this.locs.iterator().next()).getResultType();
        }

        public final String toString_long() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.toString_short());
            stringBuffer.append(super.toString_long());
            if (this.field_predecessors != null) {
                stringBuffer.append(" field pred:");
                stringBuffer.append(this.field_predecessors);
            }
            return stringBuffer.toString();
        }

        public final String toString_short() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Integer.toHexString(this.hashCode()));
            stringBuffer.append(": ");
            stringBuffer.append("FieldLoad ");
            stringBuffer.append(this.fieldName());
            Iterator iterator = this.locs.iterator();
            if (iterator.hasNext()) {
                int n = ((ProgramLocation)iterator.next()).getID();
                if (!iterator.hasNext()) {
                    stringBuffer.append(" loc ");
                    stringBuffer.append(n);
                } else {
                    stringBuffer.append(" locs {");
                    stringBuffer.append(n);
                    while (iterator.hasNext()) {
                        stringBuffer.append(',');
                        stringBuffer.append(((ProgramLocation)iterator.next()).getID());
                    }
                    stringBuffer.append('}');
                }
            }
            return stringBuffer.toString();
        }

        public final void write(Textualizer textualizer) throws IOException {
            Textualizable textualizable;
            if (this.f == null) {
                textualizer.writeBytes("null");
            } else {
                this.f.write(textualizer);
            }
            textualizer.writeBytes(" " + this.locs.size());
            Iterator iterator = this.locs.iterator();
            while (iterator.hasNext()) {
                textualizer.writeBytes(" ");
                textualizable = (ProgramLocation)iterator.next();
                textualizable.write(textualizer);
            }
            iterator = this.field_predecessors.iterator();
            while (iterator.hasNext()) {
                textualizable = (Node)iterator.next();
                if (!textualizer.contains(textualizable)) continue;
                textualizer.writeEdge("fpred", textualizable);
            }
            super.write(textualizer);
        }

        public static final FieldNode read(StringTokenizer stringTokenizer) {
            jq_Field jq_Field2 = (jq_Field)jq_Member.read(stringTokenizer);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            Set set = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            int n2 = 0;
            while (n2 < n) {
                ProgramLocation programLocation = ProgramLocation.read(stringTokenizer);
                set.add(programLocation);
                ++n2;
            }
            return new FieldNode(jq_Field2, set);
        }

        private FieldNode(jq_Field jq_Field2, ProgramLocation programLocation) {
            this.f = jq_Field2;
            this.locs = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            this.locs.add(programLocation);
        }

        private FieldNode(jq_Field jq_Field2, Set set) {
            this.f = jq_Field2;
            this.locs = set;
        }

        private FieldNode(jq_Field jq_Field2) {
            this.f = jq_Field2;
            this.locs = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
        }

        private FieldNode(FieldNode fieldNode) {
            this.f = fieldNode.f;
            this.locs = SortedArraySet.FACTORY.makeSet(fieldNode.locs);
            this.field_predecessors = fieldNode.field_predecessors;
        }
    }

    public static final class State
    implements Cloneable {
        final Object[] registers;

        public final State copy() {
            State state = new State(this.registers.length);
            int n = 0;
            while (n < this.registers.length) {
                Object object = this.registers[n];
                if (object != null) {
                    state.registers[n] = object instanceof Node ? object : NodeSet.FACTORY.makeSet((Set)object);
                }
                ++n;
            }
            return state;
        }

        public final boolean merge(State state) {
            boolean bl = false;
            int n = 0;
            while (n < this.registers.length) {
                if (this.merge(n, state.registers[n])) {
                    bl = true;
                }
                ++n;
            }
            return bl;
        }

        public final boolean merge(int n, Object object) {
            Set set;
            if (object == null) {
                return false;
            }
            Object object2 = this.registers[n];
            if (object.equals(object2)) {
                return false;
            }
            if (!(object2 instanceof Set)) {
                set = NodeSet.FACTORY.makeSet();
                this.registers[n] = set;
                if (object2 != null) {
                    set.add(object2);
                }
            } else {
                set = (Set)object2;
            }
            if (object instanceof Set) {
                if (set.addAll((Set)object)) {
                    if (TRACE_INTRA) {
                        out.println("change in register " + n + " from adding set");
                    }
                    return true;
                }
            } else if (set.add(object)) {
                if (TRACE_INTRA) {
                    out.println("change in register " + n + " from adding " + object);
                }
                return true;
            }
            return false;
        }

        public final void dump(PrintStream printStream) {
            int n = 0;
            while (n < this.registers.length) {
                if (this.registers[n] != null) {
                    printStream.print(n + ": " + this.registers[n] + ' ');
                }
                ++n;
            }
            printStream.println();
        }

        public State(int n) {
            this.registers = new Object[n];
        }
    }

    public static final class NodeSet
    implements Set,
    Cloneable {
        public static final boolean REDUCE_ALLOCATIONS = false;
        public static final boolean TEST = false;
        public static final boolean PROFILE = false;
        public static final SetFactory FACTORY = new 1();
        private Node[] elementData;
        private int size;

        public final int size() {
            return this.size;
        }

        private static final int compare(Node node, Node node2) {
            int n = node.id;
            int n2 = node2.id;
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }

        private final int whereDoesItGo(Node node) {
            int n = 0;
            int n2 = this.size - 1;
            if (n2 < 0) {
                return 0;
            }
            int n3 = n2 >> 1;
            while (true) {
                Node node2;
                int n4;
                if ((n4 = NodeSet.compare(node, node2 = this.elementData[n3])) < 0) {
                    n2 = n3 - 1;
                    if (n > n2) {
                        return n3;
                    }
                } else if (n4 > 0) {
                    n = n3 + 1;
                    if (n > n2) {
                        return n;
                    }
                } else {
                    return n3;
                }
                n3 = (n2 - n >> 1) + n;
            }
        }

        public final boolean add(Object object) {
            return this.add((Node)object);
        }

        public final boolean add(Node node) {
            int n;
            int n2 = this.whereDoesItGo(node);
            if (n2 != (n = this.size) && this.elementData[n2].equals(node)) {
                return false;
            }
            this.ensureCapacity(n + 1);
            System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, n - n2);
            this.elementData[n2] = node;
            ++this.size;
            return true;
        }

        public final void ensureCapacity(int n) {
            int n2 = this.elementData.length;
            if (n > n2) {
                Node[] nodeArray = this.elementData;
                int n3 = (n2 * 3 >> 1) + 1;
                if (n3 < n) {
                    n3 = n;
                }
                this.elementData = new Node[n3];
                System.arraycopy(nodeArray, 0, this.elementData, 0, this.size);
            }
        }

        public final boolean addAll(Collection collection) {
            if (collection instanceof NodeSet) {
                boolean bl = this.addAll((NodeSet)collection);
                return bl;
            }
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.add((Node)iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        public final boolean addAll(NodeSet nodeSet) {
            if (this == nodeSet) {
                return false;
            }
            int n = nodeSet.size();
            if (n == 0) {
                return false;
            }
            int n2 = this.size;
            Node[] nodeArray = this.elementData;
            Node[] nodeArray2 = nodeSet.elementData;
            int n3 = Math.max(nodeArray.length, n2 + n);
            int n4 = 0;
            int n5 = 0;
            Node[] nodeArray3 = new Node[n3];
            this.elementData = nodeArray3;
            int n6 = 0;
            boolean bl = false;
            while (true) {
                Node node;
                block7: {
                    int n7;
                    if (n5 == n) {
                        int n8 = n2 - n6;
                        if (n8 > 0) {
                            System.arraycopy(nodeArray, n6, nodeArray3, n4, n8);
                        }
                        this.size = n4 + n8;
                        return bl;
                    }
                    node = nodeArray2[n5++];
                    do {
                        if (n6 == n2) {
                            nodeArray3[n4++] = node;
                            int n9 = n - n5;
                            System.arraycopy(nodeArray2, n5, nodeArray3, n4, n9);
                            this.size = n4 + n9;
                            return true;
                        }
                        Node node2 = nodeArray[n6];
                        n7 = NodeSet.compare(node2, node);
                        if (n7 > 0) break block7;
                        nodeArray3[n4++] = node2;
                        ++n6;
                    } while (n7 != 0);
                    continue;
                }
                nodeArray3[n4++] = node;
                bl = true;
            }
        }

        public final int indexOf(Node node) {
            int n = this.whereDoesItGo(node);
            if (n == this.size || node.id != this.elementData[n].id) {
                return -1;
            }
            return n;
        }

        public final boolean contains(Object object) {
            return this.contains((Node)object);
        }

        public final boolean contains(Node node) {
            boolean bl = false;
            if (this.indexOf(node) != -1) {
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }

        public final boolean remove(Object object) {
            return this.remove((Node)object);
        }

        public final boolean remove(Node node) {
            int n = this.whereDoesItGo(node);
            if (n == this.size) {
                return false;
            }
            Node node2 = this.elementData[n];
            if (node != node2) {
                return false;
            }
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
            }
            this.elementData[--this.size] = null;
            return true;
        }

        public final Object clone() {
            try {
                NodeSet nodeSet = (NodeSet)super.clone();
                int n = this.elementData.length;
                nodeSet.elementData = new Node[n];
                nodeSet.size = this.size;
                System.arraycopy(this.elementData, 0, nodeSet.elementData, 0, this.size);
                return nodeSet;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public final boolean equals(Object object) {
            if (object instanceof NodeSet) {
                boolean bl = this.equals((NodeSet)object);
                return bl;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                if (this.size() != collection.size()) {
                    return false;
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (this.contains(iterator.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public final boolean equals(NodeSet nodeSet) {
            if (this.size != nodeSet.size) {
                return false;
            }
            Node[] nodeArray = this.elementData;
            Node[] nodeArray2 = nodeSet.elementData;
            int n = 0;
            while (n < this.size) {
                if (nodeArray[n] != nodeArray2[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public final int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.size) {
                n += this.elementData[n2].hashCode();
                ++n2;
            }
            return n;
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.elementData[n]);
                if (n + 1 < this.size) {
                    stringBuffer.append(',');
                }
                ++n;
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        public final void clear() {
            this.size = 0;
        }

        public final boolean containsAll(Collection collection) {
            if (collection instanceof NodeSet) {
                return this.containsAll((NodeSet)collection);
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains((Node)iterator.next())) continue;
                return false;
            }
            return true;
        }

        public final boolean containsAll(NodeSet nodeSet) {
            if (this == nodeSet) {
                return true;
            }
            int n = nodeSet.size;
            int n2 = this.size;
            if (n > n2) {
                return false;
            }
            Node[] nodeArray = this.elementData;
            Node[] nodeArray2 = nodeSet.elementData;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                Node node;
                Node node2 = nodeArray2[n4];
                while ((node = nodeArray[n3++]) != node2) {
                    if (node.id <= node2.id) continue;
                    return false;
                }
                ++n4;
            }
            return true;
        }

        public final boolean isEmpty() {
            boolean bl = false;
            if (this.size == 0) {
                bl = true;
            }
            return bl;
        }

        public final Iterator iterator() {
            Node[] nodeArray = this.elementData;
            int n = this.size;
            return new Iterator(this, n, nodeArray){
                int n;
                int i;
                final /* synthetic */ NodeSet this$0;
                final /* synthetic */ int val$s;
                final /* synthetic */ Node[] val$e;

                public final Object next() {
                    return this.val$e[this.i++];
                }

                public final boolean hasNext() {
                    boolean bl = false;
                    if (this.i < this.n) {
                        bl = true;
                    }
                    return bl;
                }

                public final void remove() {
                    int n = this.val$s - this.i;
                    if (n > 0) {
                        System.arraycopy(this.val$e, this.i, this.val$e, this.i - 1, n);
                    }
                    Node[] nodeArray = NodeSet.access$0(this.this$0);
                    NodeSet nodeSet = this.this$0;
                    int n2 = NodeSet.access$1(nodeSet) - 1;
                    NodeSet.access$2(nodeSet, n2);
                    nodeArray[n2] = null;
                    --this.i;
                    --this.n;
                }

                private final /* synthetic */ void this() {
                    this.n = this.val$s;
                    this.i = 0;
                }
                {
                    this.this$0 = nodeSet;
                    this.val$s = n;
                    this.val$e = nodeArray;
                    this.this();
                }
            };
        }

        public final boolean removeAll(Collection collection) {
            if (collection instanceof NodeSet) {
                return this.removeAll((NodeSet)collection);
            }
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove((Node)iterator.next())) continue;
                bl = true;
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        public final boolean removeAll(NodeSet var1_1) {
            if (this.isEmpty()) {
                return false;
            }
            if (this == var1_1) {
                this.clear();
                return true;
            }
            var2_2 = this.size;
            var3_3 = var1_1.size;
            var4_4 = this.elementData;
            var5_5 = var1_1.elementData;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = var4_4[var6_6++];
            var10_10 = var5_5[var7_7++];
            block0: while (true) {
                if (var9_9.id < var10_10.id) {
                    var4_4[var8_8++] = var9_9;
                    if (var6_6 == var2_2) break;
                    var9_9 = var4_4[var6_6++];
                    continue;
                }
                while (var9_9.id > var10_10.id) {
                    if (var7_7 == var3_3) break block0;
                    var10_10 = var5_5[var7_7++];
                }
                while (true) {
                    if (var9_9 == var10_10) ** break;
                    continue block0;
                    if (var6_6 == var2_2) break block0;
                    var9_9 = var4_4[var6_6++];
                    if (var7_7 == var3_3) {
                        System.arraycopy(var4_4, var6_6, var4_4, var8_8, var2_2 - var6_6);
                        var8_8 += var2_2 - var6_6;
                        break block0;
                    }
                    var10_10 = var5_5[var7_7++];
                }
                break;
            }
            this.size = var8_8;
            return true;
        }

        public final boolean retainAll(Collection collection) {
            if (collection instanceof NodeSet) {
                return this.retainAll((NodeSet)collection);
            }
            boolean bl = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (collection.contains(iterator.next())) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        public final boolean retainAll(NodeSet var1_1) {
            if (this == var1_1) {
                return false;
            }
            var2_2 = this.size;
            var3_3 = var1_1.size;
            var4_4 = this.elementData;
            var5_5 = var1_1.elementData;
            var6_6 = 0;
            var7_7 = 0;
            var8_8 = 0;
            var9_9 = var4_4[var6_6++];
            var10_10 = var5_5[var7_7++];
            block0: while (true) {
                if (var9_9.id < var10_10.id) {
                    if (var6_6 == var2_2) break;
                    var9_9 = var4_4[var6_6++];
                    continue;
                }
                while (var9_9.id > var10_10.id) {
                    if (var7_7 == var3_3) break block0;
                    var10_10 = var5_5[var7_7++];
                }
                while (true) {
                    if (var9_9 == var10_10) ** break;
                    continue block0;
                    var4_4[var8_8++] = var9_9;
                    if (var6_6 == var2_2) break block0;
                    var9_9 = var4_4[var6_6++];
                    if (var7_7 == var3_3) break block0;
                    var10_10 = var5_5[var7_7++];
                }
                break;
            }
            this.size = var8_8;
            return true;
        }

        public final Object[] toArray() {
            Object[] objectArray = new Node[this.size];
            System.arraycopy(this.elementData, 0, objectArray, 0, this.size);
            return objectArray;
        }

        public final Object[] toArray(Object[] objectArray) {
            return this.toArray();
        }

        static /* synthetic */ Node[] access$0(NodeSet nodeSet) {
            return nodeSet.elementData;
        }

        static /* synthetic */ int access$1(NodeSet nodeSet) {
            return nodeSet.size;
        }

        static /* synthetic */ void access$2(NodeSet nodeSet, int n) {
            nodeSet.size = n;
        }

        public NodeSet(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + n);
            }
            this.elementData = new Node[n];
            this.size = 0;
        }

        public NodeSet() {
            this(10);
        }

        public NodeSet(Collection collection) {
            this((int)Math.min((long)collection.size() * 110L / 100L, Integer.MAX_VALUE));
            this.addAll(collection);
        }
    }

    public static class AccessPath {
        public static final FilterIterator.Filter filter = new 1();
        jq_Field _field;
        Node _n;
        boolean _last;
        Set succ;

        private final void reachable(Set set) {
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                if (set.contains(identityHashCodeWrapper)) continue;
                set.add(identityHashCodeWrapper);
                ((AccessPath)identityHashCodeWrapper.getObject()).reachable(set);
            }
        }

        public Iterator reachable() {
            Set set = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            set.add(IdentityHashCodeWrapper.create(this));
            this.reachable(set);
            return new FilterIterator(set.iterator(), filter);
        }

        private final void addSuccessor(AccessPath accessPath) {
            this.succ.add(IdentityHashCodeWrapper.create(accessPath));
        }

        public static AccessPath create(jq_Field jq_Field2, Node node, AccessPath accessPath) {
            if (accessPath == null) {
                return new AccessPath(jq_Field2, node, true);
            }
            AccessPath accessPath2 = accessPath.findNode(node);
            if (accessPath2 == null) {
                accessPath2 = new AccessPath(jq_Field2, node);
            } else {
                accessPath = accessPath.copy();
                accessPath2 = accessPath.findNode(node);
            }
            accessPath2.addSuccessor(accessPath);
            return accessPath2;
        }

        public static AccessPath create(AccessPath accessPath, jq_Field jq_Field2, Node node) {
            if (accessPath == null) {
                return new AccessPath(jq_Field2, node, true);
            }
            AccessPath accessPath2 = (accessPath = accessPath.copy()).findNode(node);
            if (accessPath2 == null) {
                accessPath2 = new AccessPath(jq_Field2, node);
            }
            accessPath2.setLast();
            Iterator iterator = accessPath.findLast();
            while (iterator.hasNext()) {
                AccessPath accessPath3 = (AccessPath)iterator.next();
                accessPath3.unsetLast();
                accessPath3.addSuccessor(accessPath2);
            }
            return accessPath;
        }

        private final void findLast(HashSet hashSet, Set set) {
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                if (hashSet.contains(identityHashCodeWrapper)) continue;
                hashSet.add(identityHashCodeWrapper);
                AccessPath accessPath = (AccessPath)identityHashCodeWrapper.getObject();
                if (accessPath._last) {
                    set.add(identityHashCodeWrapper);
                }
                accessPath.findLast(hashSet, set);
            }
        }

        public Iterator findLast() {
            HashSet<IdentityHashCodeWrapper> hashSet = new HashSet<IdentityHashCodeWrapper>();
            Set set = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
            IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(this);
            hashSet.add(identityHashCodeWrapper);
            if (this._last) {
                set.add(identityHashCodeWrapper);
            }
            this.findLast(hashSet, set);
            return new FilterIterator(set.iterator(), filter);
        }

        private final AccessPath findNode(Node node, HashSet hashSet) {
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                if (hashSet.contains(identityHashCodeWrapper)) continue;
                AccessPath accessPath = (AccessPath)identityHashCodeWrapper.getObject();
                if (node == accessPath._n) {
                    return accessPath;
                }
                hashSet.add(identityHashCodeWrapper);
                AccessPath accessPath2 = accessPath.findNode(node, hashSet);
                if (accessPath2 == null) continue;
                return accessPath2;
            }
            return null;
        }

        public AccessPath findNode(Node node) {
            if (node == this._n) {
                return this;
            }
            HashSet<IdentityHashCodeWrapper> hashSet = new HashSet<IdentityHashCodeWrapper>();
            IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(this);
            hashSet.add(identityHashCodeWrapper);
            return this.findNode(node, hashSet);
        }

        private final void setLast() {
            this._last = true;
        }

        private final void unsetLast() {
            this._last = false;
        }

        private final void copy(HashMap hashMap, AccessPath accessPath) {
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                AccessPath accessPath2 = (AccessPath)hashMap.get(identityHashCodeWrapper);
                if (accessPath2 == null) {
                    AccessPath accessPath3 = (AccessPath)identityHashCodeWrapper.getObject();
                    accessPath2 = new AccessPath(accessPath3._field, accessPath3._n, accessPath3._last);
                    hashMap.put(identityHashCodeWrapper, accessPath2);
                    accessPath3.copy(hashMap, accessPath2);
                }
                accessPath.addSuccessor(accessPath2);
            }
        }

        public AccessPath copy() {
            HashMap<IdentityHashCodeWrapper, AccessPath> hashMap = new HashMap<IdentityHashCodeWrapper, AccessPath>();
            IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(this);
            AccessPath accessPath = new AccessPath(this._field, this._n, this._last);
            hashMap.put(identityHashCodeWrapper, accessPath);
            this.copy(hashMap, accessPath);
            return accessPath;
        }

        private final void toString(StringBuffer stringBuffer, HashSet hashSet) {
            if (this._field == null) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append(this._field.getName());
            }
            if (this._last) {
                stringBuffer.append("<e>");
            }
            stringBuffer.append("->(");
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                if (hashSet.contains(identityHashCodeWrapper)) {
                    stringBuffer.append("<backedge>");
                    continue;
                }
                hashSet.add(identityHashCodeWrapper);
                ((AccessPath)identityHashCodeWrapper.getObject()).toString(stringBuffer, hashSet);
            }
            stringBuffer.append(')');
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            HashSet<IdentityHashCodeWrapper> hashSet = new HashSet<IdentityHashCodeWrapper>();
            IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(this);
            hashSet.add(identityHashCodeWrapper);
            this.toString(stringBuffer, hashSet);
            return stringBuffer.toString();
        }

        private final boolean oneEquals(AccessPath accessPath) {
            if (this._field != accessPath._field) {
                return false;
            }
            if (this._last != accessPath._last) {
                return false;
            }
            return this.succ.size() == accessPath.succ.size();
        }

        private final boolean equals(AccessPath accessPath, HashSet hashSet) {
            Iterator iterator = this.succ.iterator();
            Iterator iterator2 = accessPath.succ.iterator();
            while (iterator.hasNext()) {
                AccessPath accessPath2;
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                IdentityHashCodeWrapper identityHashCodeWrapper2 = (IdentityHashCodeWrapper)iterator2.next();
                AccessPath accessPath3 = (AccessPath)identityHashCodeWrapper.getObject();
                if (!accessPath3.oneEquals(accessPath2 = (AccessPath)identityHashCodeWrapper2.getObject())) {
                    return false;
                }
                if (hashSet.contains(identityHashCodeWrapper)) continue;
                hashSet.add(identityHashCodeWrapper);
                if (accessPath3.equals(accessPath2, hashSet)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(AccessPath accessPath) {
            HashSet<IdentityHashCodeWrapper> hashSet = new HashSet<IdentityHashCodeWrapper>();
            if (!this.oneEquals(accessPath)) {
                return false;
            }
            hashSet.add(IdentityHashCodeWrapper.create(this));
            return this.equals(accessPath, hashSet);
        }

        public boolean equals(Object object) {
            if (object instanceof AccessPath) {
                return this.equals((AccessPath)object);
            }
            return false;
        }

        public int hashCode() {
            int n = this.local_hashCode();
            Iterator iterator = this.succ.iterator();
            while (iterator.hasNext()) {
                IdentityHashCodeWrapper identityHashCodeWrapper = (IdentityHashCodeWrapper)iterator.next();
                n ^= ((AccessPath)identityHashCodeWrapper.getObject()).local_hashCode() << 1;
            }
            return n;
        }

        private final int local_hashCode() {
            return this._field != null ? this._field.hashCode() : 201527;
        }

        public jq_Field first() {
            return this._field;
        }

        public Iterator next() {
            return new FilterIterator(this.succ.iterator(), filter);
        }

        private AccessPath(jq_Field jq_Field2, Node node, boolean bl) {
            this._field = jq_Field2;
            this._n = node;
            this._last = bl;
            this.succ = SortedArraySet.FACTORY.makeSet(HashCodeComparator.INSTANCE);
        }

        private AccessPath(jq_Field jq_Field2, Node node) {
            this(jq_Field2, node, false);
        }
    }

    public static class OperandToNodeMap {
        MultiMap operandToNode;

        public static void write(Textualizer textualizer) throws IOException {
            Iterator iterator = summary_cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                jq_Method jq_Method2 = (jq_Method)entry.getKey();
                if (jq_Method2.getBytecode() == null) continue;
                MethodSummary methodSummary = (MethodSummary)entry.getValue();
                ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
                jq_Method2.write(textualizer);
                ListIterator.BasicBlock basicBlock = controlFlowGraph.reversePostOrderIterator();
                while (basicBlock.hasNext()) {
                    BasicBlock basicBlock2;
                    methodSummary.builder.bb = basicBlock2 = (BasicBlock)basicBlock.next();
                    State state = methodSummary.builder.start_states[basicBlock2.getID()];
                    methodSummary.builder.s = state.copy();
                    ListIterator.Quad quad = basicBlock2.iterator();
                    while (quad.hasNext()) {
                        Quad quad2 = (Quad)quad.next();
                        textualizer.writeBytes("quad " + quad2.getID() + ' ');
                        boolean bl = false;
                        Iterator iterator2 = quad2.getUsedRegisters().iterator();
                        while (iterator2.hasNext()) {
                            Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)iterator2.next();
                            textualizer.writeBytes("op ");
                            RegisterFactory.Register register = registerOperand.getRegister();
                            Object object = methodSummary.builder.getRegister(register);
                            Set<Object> set = object instanceof Set ? (Set<Object>)object : Collections.singleton(object);
                            Iterator<Object> iterator3 = set.iterator();
                            while (iterator3.hasNext()) {
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface Variable {
    }

    public static interface HeapObject {
        public ProgramLocation getLocation();

        public jq_Reference getDeclaredType();
    }
}

