/*
 * Decompiled with CFR 0.152.
 */
package Clazz;

import Bootstrap.PrimordialClassLoader;
import ClassLib.ClassLibInterface;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_MemberReference;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_TryCatchBC;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.Bytecodes;
import Run_Time.Debug;
import UTF.Utf8;
import Util.Assert;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class jq_ConstantPool
implements jq_ClassFileConstants {
    public static boolean TRACE = false;
    private Object[] constant_pool;
    private byte[] constant_pool_tags;

    public String toString() {
        return Arrays.asList(this.constant_pool).toString();
    }

    public void load(DataInput dataInput) throws IOException, ClassFormatError {
        int n = this.constant_pool.length;
        int n2 = 1;
        while (n2 < n) {
            this.constant_pool_tags[n2] = dataInput.readByte();
            switch (this.constant_pool_tags[n2]) {
                case 3: {
                    this.constant_pool[n2] = new Integer(dataInput.readInt());
                    break;
                }
                case 4: {
                    this.constant_pool[n2] = new Float(dataInput.readFloat());
                    break;
                }
                case 5: {
                    this.constant_pool[n2++] = new Long(dataInput.readLong());
                    break;
                }
                case 6: {
                    this.constant_pool[n2++] = new Double(dataInput.readDouble());
                    break;
                }
                case 1: {
                    byte[] byArray = new byte[dataInput.readUnsignedShort()];
                    dataInput.readFully(byArray);
                    this.constant_pool[n2] = Utf8.get(byArray);
                    break;
                }
                case 7: 
                case 8: {
                    this.constant_pool[n2] = new Character((char)dataInput.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    char c = (char)dataInput.readUnsignedShort();
                    char c2 = (char)dataInput.readUnsignedShort();
                    this.constant_pool[n2] = new PairOfChars(c, c2);
                    break;
                }
                default: {
                    throw new ClassFormatError("bad constant pool entry tag (entry=" + n2 + ", tag=" + this.constant_pool_tags[n2]);
                }
            }
            ++n2;
        }
    }

    public void resolve(ClassLoader classLoader) {
        int n = this.constant_pool.length;
        int n2 = 1;
        while (n2 < n) {
            switch (this.constant_pool_tags[n2]) {
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    ++n2;
                    break;
                }
                case 12: {
                    break;
                }
                case 7: {
                    this.resolveClass(classLoader, n2);
                    break;
                }
                case 13: {
                    break;
                }
                case 8: {
                    char c = ((Character)this.constant_pool[n2]).charValue();
                    if (this.constant_pool_tags[c] != 1) {
                        throw new ClassFormatError("constant pool entry " + c + ", referred to by " + n2 + ", is wrong type tag (expected=1, actual=" + this.constant_pool_tags[c] + ')');
                    }
                    Utf8 utf8 = (Utf8)this.constant_pool[c];
                    this.constant_pool[n2] = utf8.toString();
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    PairOfChars pairOfChars = (PairOfChars)this.constant_pool[n2];
                    char c = pairOfChars.getFirst();
                    char c2 = pairOfChars.getSecond();
                    if (this.constant_pool_tags[c] != 13) {
                        if (this.constant_pool_tags[c] != 7) {
                            throw new ClassFormatError("constant pool entry " + c + ", referred to by " + n2 + ", is wrong type tag (expected=7, actual=" + this.constant_pool_tags[c] + ')');
                        }
                        if (c > n2) {
                            this.resolveClass(classLoader, c);
                        }
                    }
                    jq_Class jq_Class2 = (jq_Class)this.constant_pool[c];
                    PairOfChars pairOfChars2 = (PairOfChars)this.constant_pool[c2];
                    char c3 = pairOfChars2.getFirst();
                    char c4 = pairOfChars2.getSecond();
                    if (this.constant_pool_tags[c3] != 1) {
                        throw new ClassFormatError("constant pool entry " + c3 + ", referred to by " + c2 + ", is wrong type tag (expected=1, actual=" + this.constant_pool_tags[c3] + ')');
                    }
                    if (this.constant_pool_tags[c4] != 1) {
                        throw new ClassFormatError("constant pool entry " + c4 + ", referred to by " + c2 + ", is wrong type tag (expected=1, actual=" + this.constant_pool_tags[c4] + ')');
                    }
                    Utf8 utf8 = (Utf8)this.constant_pool[c3];
                    Utf8 utf82 = (Utf8)this.constant_pool[c4];
                    if (this.constant_pool_tags[n2] == 9) {
                        if (!utf82.isValidTypeDescriptor()) {
                            throw new ClassFormatError(utf82 + " is not a valid type descriptor");
                        }
                    } else if (!utf82.isValidMethodDescriptor()) {
                        throw new ClassFormatError(utf82 + " is not a valid method descriptor");
                    }
                    jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc(utf8, utf82);
                    if (jq_Class2.isLoaded()) {
                        jq_Member jq_Member2 = jq_Class2.getDeclaredMember(jq_NameAndDesc2);
                        if (jq_Member2 == null) {
                            if (TRACE) {
                                Debug.writeln("No such member: " + jq_Class2 + '.' + jq_NameAndDesc2 + ", referenced by cp idx " + n2);
                            }
                            this.constant_pool[n2] = new jq_MemberReference(jq_Class2, jq_NameAndDesc2);
                            break;
                        }
                        this.constant_pool[n2] = jq_Member2;
                        if (utf82.isDescriptor((byte)40)) {
                            if (jq_Member2.isStatic()) {
                                this.constant_pool_tags[n2] = 16;
                                if (!TRACE) break;
                                Debug.writeln("Resolved static method " + jq_Member2 + ", cp idx " + n2);
                                break;
                            }
                            this.constant_pool_tags[n2] = 17;
                            if (!TRACE) break;
                            Debug.writeln("Resolved instance method " + jq_Member2 + ", cp idx " + n2);
                            break;
                        }
                        if (jq_Member2.isStatic()) {
                            this.constant_pool_tags[n2] = 14;
                            if (!TRACE) break;
                            Debug.writeln("Resolved static field " + jq_Member2 + ", cp idx " + n2);
                            break;
                        }
                        this.constant_pool_tags[n2] = 15;
                        if (!TRACE) break;
                        Debug.writeln("Resolved instance field " + jq_Member2 + ", cp idx " + n2);
                        break;
                    }
                    this.constant_pool[n2] = new jq_MemberReference(jq_Class2, jq_NameAndDesc2);
                    break;
                }
                default: {
                    Assert.UNREACHABLE();
                    return;
                }
            }
            ++n2;
        }
    }

    private final void resolveClass(ClassLoader classLoader, int n) throws ClassFormatError {
        char c = ((Character)this.constant_pool[n]).charValue();
        if (this.constant_pool_tags[c] != 1) {
            throw new ClassFormatError("constant pool entry " + c + ", referred to by " + n + ", is wrong type tag (expected=1, actual=" + this.constant_pool_tags[c]);
        }
        Utf8 utf8 = (Utf8)this.constant_pool[c];
        if (!utf8.isDescriptor((byte)91)) {
            utf8 = utf8.getAsClassDescriptor();
        }
        this.constant_pool[n] = PrimordialClassLoader.getOrCreateType(classLoader, utf8);
        this.constant_pool_tags[n] = 13;
        if (TRACE) {
            Debug.writeln("Resolved class " + this.constant_pool[n] + ", cp idx " + n);
        }
    }

    public final void set(char c, Object object, byte by) {
        this.constant_pool[c] = object;
        this.constant_pool_tags[c] = by;
    }

    public final int getCount() {
        return this.constant_pool.length;
    }

    public final byte getTag(char c) {
        return this.constant_pool_tags[c];
    }

    public final Object get(char c) {
        return this.constant_pool[c];
    }

    public final Integer getAsInt(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 3) {
            bl = true;
        }
        Assert._assert(bl);
        return (Integer)this.constant_pool[c];
    }

    public final Float getAsFloat(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 4) {
            bl = true;
        }
        Assert._assert(bl);
        return (Float)this.constant_pool[c];
    }

    public final Long getAsLong(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 5) {
            bl = true;
        }
        Assert._assert(bl);
        return (Long)this.constant_pool[c];
    }

    public final Double getAsDouble(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 6) {
            bl = true;
        }
        Assert._assert(bl);
        return (Double)this.constant_pool[c];
    }

    public final String getAsString(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 8) {
            bl = true;
        }
        Assert._assert(bl);
        return (String)this.constant_pool[c];
    }

    public final Utf8 getAsUtf8(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 1) {
            bl = true;
        }
        Assert._assert(bl);
        return (Utf8)this.constant_pool[c];
    }

    public final jq_Type getAsType(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 13) {
            bl = true;
        }
        Assert._assert(bl);
        return (jq_Type)this.constant_pool[c];
    }

    public final jq_Member getAsMember(char c) {
        boolean bl = false;
        if (this.constant_pool_tags[c] == 14 || this.constant_pool_tags[c] == 15 || this.constant_pool_tags[c] == 16 || this.constant_pool_tags[c] == 17) {
            bl = true;
        }
        Assert._assert(bl);
        return (jq_Member)this.constant_pool[c];
    }

    public final jq_StaticField getAsStaticField(char c) {
        jq_StaticField jq_StaticField2;
        if (this.constant_pool_tags[c] == 14) {
            return (jq_StaticField)this.constant_pool[c];
        }
        if (this.constant_pool_tags[c] != 9) {
            throw new VerifyError();
        }
        if (TRACE) {
            Debug.writeln("Attempting to resolve static field " + this.constant_pool[c] + " cp idx " + c);
        }
        jq_MemberReference jq_MemberReference2 = (jq_MemberReference)this.constant_pool[c];
        jq_Class jq_Class2 = jq_MemberReference2.getReferencedClass();
        jq_NameAndDesc jq_NameAndDesc2 = jq_MemberReference2.getNameAndDesc();
        if (jq_Class2.isInClassLib()) {
            jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        }
        if (jq_Class2.isLoaded()) {
            jq_StaticField2 = jq_Class2.getStaticField(jq_NameAndDesc2);
            if (jq_StaticField2 == null) {
                throw new NoSuchFieldError("no such static field " + jq_Class2 + '.' + jq_NameAndDesc2);
            }
        } else {
            jq_Field jq_Field2 = (jq_Field)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
            if (jq_Field2 == null) {
                jq_StaticField2 = jq_Class2.createStaticField(jq_NameAndDesc2);
                this.constant_pool[c] = jq_StaticField2;
                this.constant_pool_tags[c] = 14;
                if (TRACE) {
                    Debug.writeln("Resolved static field " + jq_StaticField2 + ", cp idx " + c);
                }
            } else {
                if (!jq_Field2.isStatic()) {
                    throw new VerifyError("field " + jq_Field2 + " referred to as both static and instance");
                }
                jq_StaticField2 = (jq_StaticField)jq_Field2;
            }
        }
        return jq_StaticField2;
    }

    public final jq_InstanceField getAsInstanceField(char c) {
        jq_InstanceField jq_InstanceField2;
        if (this.constant_pool_tags[c] == 15) {
            return (jq_InstanceField)this.constant_pool[c];
        }
        if (this.constant_pool_tags[c] != 9) {
            throw new VerifyError();
        }
        if (TRACE) {
            Debug.writeln("Attempting to resolve instance field " + this.constant_pool[c] + " cp idx " + c);
        }
        jq_MemberReference jq_MemberReference2 = (jq_MemberReference)this.constant_pool[c];
        jq_Class jq_Class2 = jq_MemberReference2.getReferencedClass();
        jq_NameAndDesc jq_NameAndDesc2 = jq_MemberReference2.getNameAndDesc();
        if (jq_Class2.isInClassLib()) {
            jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        }
        if (jq_Class2.isLoaded()) {
            jq_InstanceField2 = jq_Class2.getInstanceField(jq_NameAndDesc2);
            if (jq_InstanceField2 == null) {
                throw new NoSuchFieldError("no such instance field " + jq_Class2 + '.' + jq_NameAndDesc2);
            }
        } else {
            jq_Field jq_Field2 = (jq_Field)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
            if (jq_Field2 == null) {
                jq_InstanceField2 = jq_Class2.createInstanceField(jq_NameAndDesc2);
                this.constant_pool[c] = jq_InstanceField2;
                this.constant_pool_tags[c] = 15;
                if (TRACE) {
                    Debug.writeln("Resolved instance field " + jq_InstanceField2 + ", cp idx " + c);
                }
            } else {
                if (jq_Field2.isStatic()) {
                    throw new VerifyError("field " + jq_Field2 + " referred to as both static and instance");
                }
                jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            }
        }
        return jq_InstanceField2;
    }

    public final jq_StaticMethod getAsStaticMethod(char c) {
        jq_StaticMethod jq_StaticMethod2;
        if (this.constant_pool_tags[c] == 16) {
            return (jq_StaticMethod)this.constant_pool[c];
        }
        if (this.constant_pool_tags[c] != 10) {
            throw new VerifyError();
        }
        if (TRACE) {
            Debug.writeln("Attempting to resolve static method " + this.constant_pool[c] + " cp idx " + c);
        }
        jq_MemberReference jq_MemberReference2 = (jq_MemberReference)this.constant_pool[c];
        jq_Class jq_Class2 = jq_MemberReference2.getReferencedClass();
        jq_NameAndDesc jq_NameAndDesc2 = jq_MemberReference2.getNameAndDesc();
        if (jq_Class2.isInClassLib()) {
            jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        }
        if (jq_Class2.isLoaded()) {
            jq_StaticMethod2 = jq_Class2.getStaticMethod(jq_NameAndDesc2);
            if (jq_StaticMethod2 == null) {
                throw new NoSuchMethodError("no such static method " + jq_Class2 + '.' + jq_NameAndDesc2);
            }
        } else {
            jq_Method jq_Method2 = (jq_Method)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
            if (jq_Method2 == null) {
                jq_StaticMethod2 = jq_Class2.createStaticMethod(jq_NameAndDesc2);
                this.constant_pool[c] = jq_StaticMethod2;
                this.constant_pool_tags[c] = 16;
                if (TRACE) {
                    Debug.writeln("Resolved static method " + jq_StaticMethod2 + ", cp idx " + c);
                }
            } else {
                if (!jq_Method2.isStatic()) {
                    throw new VerifyError("method " + jq_Method2 + " referred to as both static and instance");
                }
                jq_StaticMethod2 = (jq_StaticMethod)jq_Method2;
            }
        }
        return jq_StaticMethod2;
    }

    public final jq_InstanceMethod getAsInstanceMethod(char c) {
        jq_InstanceMethod jq_InstanceMethod2;
        if (this.constant_pool_tags[c] == 17) {
            return (jq_InstanceMethod)this.constant_pool[c];
        }
        if (this.constant_pool_tags[c] != 10 && this.constant_pool_tags[c] != 11) {
            throw new VerifyError();
        }
        if (TRACE) {
            Debug.writeln("Attempting to resolve instance method " + this.constant_pool[c] + " cp idx " + c);
        }
        jq_MemberReference jq_MemberReference2 = (jq_MemberReference)this.constant_pool[c];
        jq_Class jq_Class2 = jq_MemberReference2.getReferencedClass();
        jq_NameAndDesc jq_NameAndDesc2 = jq_MemberReference2.getNameAndDesc();
        if (jq_Class2.isInClassLib()) {
            jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        }
        if (jq_Class2.isLoaded()) {
            jq_InstanceMethod2 = jq_Class2.getInstanceMethod(jq_NameAndDesc2);
            if (jq_InstanceMethod2 == null) {
                throw new NoSuchMethodError("no such instance method " + jq_Class2 + '.' + jq_NameAndDesc2);
            }
        } else {
            jq_Method jq_Method2 = (jq_Method)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
            if (jq_Method2 == null) {
                jq_InstanceMethod2 = jq_Class2.createInstanceMethod(jq_NameAndDesc2);
                this.constant_pool[c] = jq_InstanceMethod2;
                this.constant_pool_tags[c] = 17;
                if (TRACE) {
                    Debug.writeln("Resolved instance method " + jq_InstanceMethod2 + ", cp idx " + c);
                }
            } else {
                if (jq_Method2.isStatic()) {
                    throw new VerifyError("method " + jq_Method2 + " referred to as both static and instance");
                }
                jq_InstanceMethod2 = (jq_InstanceMethod)jq_Method2;
            }
        }
        return jq_InstanceMethod2;
    }

    public void trim(Set set, Set set2) {
        int n = 0;
        while (n < this.constant_pool.length) {
            byte by = this.constant_pool_tags[n];
            Object object = this.constant_pool[n];
            switch (by) {
                case 14: 
                case 15: {
                    if (set.contains(object)) break;
                    jq_MemberReference jq_MemberReference2 = new jq_MemberReference(((jq_Member)object).getDeclaringClass(), ((jq_Member)object).getNameAndDesc());
                    this.constant_pool[n] = jq_MemberReference2;
                    this.constant_pool_tags[n] = 9;
                    break;
                }
                case 16: 
                case 17: {
                    if (set2.contains(object)) break;
                    jq_MemberReference jq_MemberReference2 = new jq_MemberReference(((jq_Member)object).getDeclaringClass(), ((jq_Member)object).getNameAndDesc());
                    this.constant_pool[n] = jq_MemberReference2;
                    this.constant_pool_tags[n] = 10;
                }
            }
            ++n;
        }
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.constant_pool.length) {
            if (this.constant_pool[n] == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final int growCPbyOne() {
        int n = this.constant_pool.length + 1;
        Object[] objectArray = new Object[n];
        System.arraycopy(this.constant_pool, 0, objectArray, 0, this.constant_pool.length);
        byte[] byArray = new byte[n];
        System.arraycopy(this.constant_pool_tags, 0, byArray, 0, this.constant_pool_tags.length);
        this.constant_pool = objectArray;
        this.constant_pool_tags = byArray;
        return n - 1;
    }

    public int addInteger(int n) {
        int n2 = this.growCPbyOne();
        this.constant_pool[n2] = new Integer(n);
        this.constant_pool_tags[n2] = 3;
        return n2;
    }

    public int addFloat(float f) {
        int n = this.growCPbyOne();
        this.constant_pool[n] = new Float(f);
        this.constant_pool_tags[n] = 4;
        return n;
    }

    public int addLong(float f) {
        int n = this.growCPbyOne();
        this.constant_pool[n] = new Float(f);
        this.constant_pool_tags[n] = 4;
        this.growCPbyOne();
        return n;
    }

    public int addDouble(double d) {
        int n = this.growCPbyOne();
        this.constant_pool[n] = new Double(d);
        this.constant_pool_tags[n] = 6;
        this.growCPbyOne();
        return n;
    }

    public int addString(String string) {
        int n = this.growCPbyOne();
        this.constant_pool[n] = string;
        this.constant_pool_tags[n] = 8;
        return n;
    }

    Adder getAdder() {
        return new Adder();
    }

    public jq_ConstantPool(int n) {
        this.constant_pool = new Object[n];
        this.constant_pool_tags = new byte[n];
    }

    static class PairOfChars {
        char c1;
        char c2;

        char getFirst() {
            return this.c1;
        }

        char getSecond() {
            return this.c2;
        }

        PairOfChars(char c, char c2) {
            this.c1 = c;
            this.c2 = c2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Adder {
        LinkedList toadd_cp;

        public char add(Object object, byte by) {
            int n = 0;
            while (n < jq_ConstantPool.this.constant_pool.length) {
                if (object.equals(jq_ConstantPool.this.get((char)n))) {
                    boolean bl = false;
                    if (jq_ConstantPool.this.getTag((char)n) == by) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    return (char)n;
                }
                ++n;
            }
            ConstantPoolEntry constantPoolEntry = new ConstantPoolEntry(object, by);
            n = this.toadd_cp.indexOf(constantPoolEntry);
            if (n != -1) {
                return (char)n;
            }
            n = jq_ConstantPool.this.constant_pool.length + this.toadd_cp.size();
            this.toadd_cp.add(constantPoolEntry);
            boolean bl = false;
            if (n <= (char)-1) {
                bl = true;
            }
            Assert._assert(bl);
            return (char)n;
        }

        public void finish() {
            if (this.toadd_cp.size() == 0) {
                return;
            }
            Object[] objectArray = new Object[jq_ConstantPool.this.constant_pool.length + this.toadd_cp.size()];
            byte[] byArray = new byte[objectArray.length];
            int n = jq_ConstantPool.this.constant_pool.length - 1;
            System.arraycopy(jq_ConstantPool.this.constant_pool, 0, objectArray, 0, jq_ConstantPool.this.constant_pool.length);
            System.arraycopy(jq_ConstantPool.this.constant_pool_tags, 0, byArray, 0, jq_ConstantPool.this.constant_pool_tags.length);
            Iterator iterator = this.toadd_cp.iterator();
            while (iterator.hasNext()) {
                ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)iterator.next();
                objectArray[++n] = constantPoolEntry.o;
                byArray[n] = constantPoolEntry.tag;
            }
            jq_ConstantPool.this.constant_pool = objectArray;
            jq_ConstantPool.this.constant_pool_tags = byArray;
        }

        private final /* synthetic */ void this() {
            this.toadd_cp = new LinkedList();
        }

        Adder() {
            this.this();
        }
    }

    static class ConstantPoolEntry {
        Object o;
        byte tag;

        public boolean equals(ConstantPoolEntry constantPoolEntry) {
            boolean bl = false;
            if (this.o == constantPoolEntry.o && this.tag == constantPoolEntry.tag) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object instanceof ConstantPoolEntry) {
                return this.equals((ConstantPoolEntry)object);
            }
            return false;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        ConstantPoolEntry(Object object, byte by) {
            this.o = object;
            this.tag = by;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ConstantPoolRebuilder {
        HashMap new_entries;

        private final int renumber() {
            int n = 0;
            Set set = this.new_entries.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                boolean bl = false;
                if (n < (int)-1) {
                    bl = true;
                }
                Assert._assert(bl);
                entry.setValue(new Character((char)(++n)));
                if (!(entry.getKey() instanceof Long) && !(entry.getKey() instanceof Double)) continue;
                ++n;
            }
            if (TRACE) {
                Debug.writeln("After renumbering constant pool: " + (n + 1) + " entries.");
            }
            return n + 1;
        }

        public jq_ConstantPool finish() {
            if (TRACE) {
                Debug.writeln("Finishing rebuilding constant pool...");
            }
            int n = this.renumber();
            int n2 = 0;
            boolean bl = false;
            if (n <= (char)-1) {
                bl = true;
            }
            Assert._assert(bl);
            jq_ConstantPool jq_ConstantPool2 = new jq_ConstantPool(n);
            Set set = this.new_entries.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                int n3 = ((Character)entry.getValue()).charValue();
                boolean bl2 = false;
                if (n3 == ++n2) {
                    bl2 = true;
                }
                Assert._assert(bl2, (char)n3 + "!=" + n2);
                ((jq_ConstantPool)jq_ConstantPool2).constant_pool[n2] = k;
                if (k instanceof Utf8) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 1;
                    continue;
                }
                if (k instanceof Integer) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 3;
                    continue;
                }
                if (k instanceof Float) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 4;
                    continue;
                }
                if (k instanceof Long) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 5;
                    ++n2;
                    continue;
                }
                if (k instanceof Double) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 6;
                    ++n2;
                    continue;
                }
                if (k instanceof jq_Type) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 13;
                    continue;
                }
                if (k instanceof String) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 8;
                    continue;
                }
                if (k instanceof jq_NameAndDesc) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 12;
                    continue;
                }
                if (k instanceof jq_InstanceMethod) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 17;
                    continue;
                }
                if (k instanceof jq_StaticMethod) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 16;
                    continue;
                }
                if (k instanceof jq_InstanceField) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 15;
                    continue;
                }
                if (k instanceof jq_StaticField) {
                    ((jq_ConstantPool)jq_ConstantPool2).constant_pool_tags[n2] = 14;
                    continue;
                }
                Assert.UNREACHABLE(k.toString());
            }
            return jq_ConstantPool2;
        }

        public void addCode(jq_Method jq_Method2) {
            byte[] byArray;
            if (TRACE) {
                Debug.writeln("Adding code for " + jq_Method2);
            }
            if ((byArray = jq_Method2.getBytecode()) == null) {
                return;
            }
            Bytecodes.InstructionList instructionList = new Bytecodes.InstructionList(jq_Method2.getDeclaringClass().getCP(), byArray);
            this.addCode(instructionList);
        }

        public void addCode(Bytecodes.InstructionList instructionList) {
            if (TRACE) {
                Debug.writeln("Adding code for " + instructionList);
            }
            RebuildCPVisitor rebuildCPVisitor = new RebuildCPVisitor();
            instructionList.accept(rebuildCPVisitor);
        }

        public void addExceptions(jq_Method jq_Method2) {
            byte[] byArray = jq_Method2.getBytecode();
            if (byArray == null) {
                return;
            }
            jq_TryCatchBC[] jq_TryCatchBCArray = jq_Method2.getExceptionTable();
            int n = 0;
            while (n < jq_TryCatchBCArray.length) {
                jq_Class jq_Class2 = jq_TryCatchBCArray[n].getExceptionType();
                if (jq_Class2 != null) {
                    this.addType(jq_Class2);
                }
                ++n;
            }
        }

        public void addAttributeNames(jq_Member jq_Member2) {
            if (TRACE) {
                Debug.writeln("Adding attribute names for " + jq_Member2);
            }
            Map map = jq_Member2.getAttributes();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.new_entries.put(entry.getKey(), null);
            }
        }

        public void dump(DataOutput dataOutput) throws IOException {
            int n = this.renumber();
            int n2 = 0;
            boolean bl = false;
            if (n <= (char)-1) {
                bl = true;
            }
            Assert._assert(bl);
            dataOutput.writeChar(n);
            Set set = this.new_entries.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                int n3 = ((Character)entry.getValue()).charValue();
                boolean bl2 = false;
                if (n3 == ++n2) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                if (k instanceof Utf8) {
                    dataOutput.writeByte(1);
                    ((Utf8)k).dump(dataOutput);
                    continue;
                }
                if (k instanceof Integer) {
                    dataOutput.writeByte(3);
                    dataOutput.writeInt((Integer)k);
                    continue;
                }
                if (k instanceof Float) {
                    dataOutput.writeByte(4);
                    dataOutput.writeFloat(((Float)k).floatValue());
                    continue;
                }
                if (k instanceof Long) {
                    dataOutput.writeByte(5);
                    dataOutput.writeLong((Long)k);
                    ++n2;
                    continue;
                }
                if (k instanceof Double) {
                    dataOutput.writeByte(6);
                    dataOutput.writeDouble((Double)k);
                    ++n2;
                    continue;
                }
                if (k instanceof jq_Type) {
                    dataOutput.writeByte(7);
                    Utf8 utf8 = ((jq_Type)k).getDesc();
                    if (k instanceof jq_Class) {
                        utf8 = utf8.getClassName();
                    }
                    dataOutput.writeChar(this.get(utf8));
                    continue;
                }
                if (k instanceof String) {
                    dataOutput.writeByte(8);
                    dataOutput.writeChar(this.get(Utf8.get((String)k)));
                    continue;
                }
                if (k instanceof jq_NameAndDesc) {
                    dataOutput.writeByte(12);
                    jq_NameAndDesc jq_NameAndDesc2 = (jq_NameAndDesc)k;
                    dataOutput.writeChar(this.get(jq_NameAndDesc2.getName()));
                    dataOutput.writeChar(this.get(jq_NameAndDesc2.getDesc()));
                    continue;
                }
                if (k instanceof jq_Member) {
                    int n4 = 10;
                    jq_Member jq_Member2 = (jq_Member)k;
                    if (jq_Member2 instanceof jq_Field) {
                        n4 = 9;
                    } else if (jq_Member2 instanceof jq_InstanceMethod) {
                        jq_Member2.getDeclaringClass().load();
                        if (jq_Member2.getDeclaringClass().isInterface()) {
                            n4 = 11;
                        }
                    }
                    dataOutput.writeByte(n4);
                    dataOutput.writeChar(this.get(jq_Member2.getDeclaringClass()));
                    dataOutput.writeChar(this.get(jq_Member2.getNameAndDesc()));
                    continue;
                }
                Assert.UNREACHABLE();
            }
        }

        public char get(Object object) {
            boolean bl = false;
            if (object != null) {
                bl = true;
            }
            Assert._assert(bl);
            Character c = (Character)this.new_entries.get(object);
            if (c == null) {
                Assert.UNREACHABLE("No such constant pool entry: type " + object.getClass() + " value " + object);
            }
            return c.charValue();
        }

        public void addString(String string) {
            if (TRACE) {
                Debug.writeln("Adding string " + string);
            }
            this.new_entries.put(Utf8.get(string), null);
            this.new_entries.put(string, null);
        }

        public void addType(jq_Type jq_Type2) {
            if (TRACE) {
                Debug.writeln("Adding type " + jq_Type2);
            }
            Utf8 utf8 = jq_Type2.getDesc();
            if (jq_Type2 instanceof jq_Class) {
                utf8 = utf8.getClassName();
            }
            this.new_entries.put(utf8, null);
            this.new_entries.put(jq_Type2, null);
        }

        public void addMember(jq_Member jq_Member2) {
            if (TRACE) {
                Debug.writeln("Adding member " + jq_Member2);
            }
            this.new_entries.put(jq_Member2.getName(), null);
            this.new_entries.put(jq_Member2.getDesc(), null);
            this.new_entries.put(jq_Member2.getNameAndDesc(), null);
            this.addType(jq_Member2.getDeclaringClass());
            this.new_entries.put(jq_Member2, null);
        }

        public void addOther(Object object) {
            Assert._assert(object instanceof String ^ true);
            if (object == null) {
                return;
            }
            if (TRACE) {
                Debug.writeln("Adding other " + object);
            }
            this.new_entries.put(object, null);
        }

        public void remove(Object object) {
            if (TRACE) {
                Debug.writeln("Removing " + object);
            }
            this.new_entries.remove(object);
        }

        public void resetIndices(Bytecodes.InstructionList instructionList) {
            if (TRACE) {
                Debug.writeln("Resetting indices of " + instructionList);
            }
            ConstantPoolRebuilder constantPoolRebuilder = this;
            Bytecodes.EmptyVisitor emptyVisitor = new Bytecodes.EmptyVisitor(this, constantPoolRebuilder){
                final /* synthetic */ ConstantPoolRebuilder this$0;
                final /* synthetic */ ConstantPoolRebuilder val$my_cpr;

                public final void visitCPInstruction(Bytecodes.CPInstruction cPInstruction) {
                    cPInstruction.setIndex(this.val$my_cpr);
                    boolean bl = false;
                    if (cPInstruction.getIndex() != 0) {
                        bl = true;
                    }
                    Assert._assert(bl);
                }
                {
                    this.this$0 = constantPoolRebuilder;
                    this.val$my_cpr = constantPoolRebuilder2;
                }
            };
            instructionList.accept(emptyVisitor);
        }

        private final /* synthetic */ void this() {
            this.new_entries = new HashMap();
        }

        public ConstantPoolRebuilder() {
            this.this();
        }

        class RebuildCPVisitor
        extends Bytecodes.EmptyVisitor {
            public void visitCPInstruction(Bytecodes.CPInstruction cPInstruction) {
                Object object = cPInstruction.getObject();
                if (object instanceof String) {
                    ConstantPoolRebuilder.this.addString((String)object);
                } else if (object instanceof jq_Type) {
                    ConstantPoolRebuilder.this.addType((jq_Type)object);
                } else if (object instanceof jq_Member) {
                    ConstantPoolRebuilder.this.addMember((jq_Member)object);
                } else {
                    ConstantPoolRebuilder.this.addOther(object);
                }
            }

            RebuildCPVisitor() {
            }
        }
    }

    public static class ConstantPoolAdder
    extends ConstantPoolRebuilder {
        jq_ConstantPool cp;

        public jq_ConstantPool finish() {
            Adder adder = this.cp.getAdder();
            int n = -1;
            Set set = this.new_entries.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (k instanceof Utf8) {
                    n = adder.add(k, (byte)1);
                } else if (k instanceof Integer) {
                    n = adder.add(k, (byte)3);
                } else if (k instanceof Float) {
                    n = adder.add(k, (byte)4);
                } else if (k instanceof Long) {
                    n = adder.add(k, (byte)5);
                } else if (k instanceof Double) {
                    n = adder.add(k, (byte)6);
                } else if (k instanceof jq_Type) {
                    n = adder.add(k, (byte)13);
                } else if (k instanceof String) {
                    n = adder.add(k, (byte)8);
                } else if (k instanceof jq_NameAndDesc) {
                    n = adder.add(k, (byte)12);
                } else if (k instanceof jq_InstanceMethod) {
                    n = adder.add(k, (byte)17);
                } else if (k instanceof jq_StaticMethod) {
                    n = adder.add(k, (byte)16);
                } else if (k instanceof jq_InstanceField) {
                    n = adder.add(k, (byte)15);
                } else if (k instanceof jq_StaticField) {
                    n = adder.add(k, (byte)14);
                } else {
                    Assert.UNREACHABLE();
                }
                entry.setValue(new Character((char)n++));
            }
            adder.finish();
            return this.cp;
        }

        public char get(Object object) {
            Character c = (Character)this.new_entries.get(object);
            if (c == null) {
                this.new_entries.put(object, null);
                this.finish();
                c = (Character)this.new_entries.get(object);
            }
            return c.charValue();
        }

        public void remove(Object object) {
            Assert.UNREACHABLE("No remove allowed in jq_ConstantPool.ConstantPoolAdder! ");
        }

        public void dump(DataOutput dataOutput) throws IOException {
            Assert.UNREACHABLE("TODO: implement Dump in jq_ConstantPool.ConstantPoolAdder! ");
        }

        public ConstantPoolAdder(jq_ConstantPool jq_ConstantPool2) {
            this.cp = jq_ConstantPool2;
        }
    }
}

