/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.ZipConstants;
import ClassLib.Common.java.util.zip.ZipFile;
import Util.Assert;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipException;

class ZipEntry
implements ZipConstants {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    String name = "UNINITIALIZED";
    long time;
    long crc;
    long size;
    long csize;
    int method;
    byte[] extra;
    String comment;
    int flag;
    int version;
    long offset;

    public int load(byte[] byArray, int n, long l, int n2) throws ZipException {
        Object object;
        int n3 = n;
        this.version = ZipFile.get16(byArray, n3 + 6);
        this.flag = ZipFile.get16(byArray, n3 + 8);
        this.method = ZipFile.get16(byArray, n3 + 10);
        this.time = ZipFile.get32(byArray, n3 + 12);
        this.crc = ZipFile.get32(byArray, n3 + 24);
        this.size = ZipFile.get32(byArray, n3 + 12);
        this.csize = ZipFile.get32(byArray, n3 + 20);
        this.offset = ZipFile.get32(byArray, n3 + 42);
        this.time = ZipFile.get32(byArray, n3 + 12);
        long l2 = this.offset;
        long l3 = this.csize;
        if (l2 + l3 > l) {
            throw new ZipException("invalid CEN entry size");
        }
        int n4 = n3;
        int n5 = ZipFile.get16(byArray, n4 + 28);
        if (n5 == 0 || (n3 += 46) + n5 > n2) {
            throw new ZipException("invalid CEN entry name");
        }
        try {
            object = new String(byArray, n3, n5, DEFAULT_ENCODING);
            this.name = object;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.UNREACHABLE();
        }
        n3 += n5;
        n5 = ZipFile.get16(byArray, n4 + 30);
        if (n5 > 0) {
            if (n3 + n5 > n2) {
                throw new ZipException("invalid CEN entry extra data");
            }
            object = new byte[n5];
            this.extra = (byte[])object;
            System.arraycopy(byArray, n3, object, 0, n5);
            n3 += n5;
        }
        if ((n5 = ZipFile.get16(byArray, n4 + 32)) > 0) {
            if (n3 + n5 > n2) {
                throw new ZipException("invalid CEN entry comment");
            }
            try {
                this.comment = object = new String(byArray, n3, n5, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.UNREACHABLE();
            }
            n3 += n5;
        }
        return n3 - n;
    }

    private static final void initIDs() {
    }

    public long getOffset() {
        return this.offset;
    }

    public native int getMethod();

    public native long getCompressedSize();

    public native String getName();

    ZipEntry() {
    }
}

