/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.DeflaterHuffman;
import ClassLib.Common.java.util.zip.StreamManipulator;
import java.util.zip.DataFormatException;

class InflaterHuffmanTree {
    private static final int MAX_BITLEN = 15;
    public static InflaterHuffmanTree defLitLenTree;
    public static InflaterHuffmanTree defDistTree;
    private short[] tree;

    private final void buildTree(byte[] byArray) throws DataFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        int n6 = 0;
        while (n6 < byArray.length) {
            n5 = byArray[n6];
            if (n5 > 0) {
                int n7 = n5;
                nArray[n7] = nArray[n7] + 1;
            }
            ++n6;
        }
        n6 = 0;
        n5 = 512;
        int n8 = 1;
        while (n8 <= 15) {
            nArray2[n8] = n6;
            n6 += nArray[n8] << 16 - n8;
            if (n8 >= 10) {
                n4 = nArray2[n8] & 0x1FF80;
                n3 = n6 & 0x1FF80;
                n5 += n3 - n4 >> 16 - n8;
            }
            ++n8;
        }
        if (n6 != 65536) {
            throw new DataFormatException("Code lengths don't add up properly.");
        }
        this.tree = new short[n5];
        n8 = 512;
        n4 = 15;
        while (n4 >= 10) {
            n3 = n6 & 0x1FF80;
            n = n2 = (n6 -= nArray[n4] << 16 - n4) & 0x1FF80;
            while (n < n3) {
                this.tree[DeflaterHuffman.bitReverse((int)n)] = (short)(-n8 << 4 | n4);
                n8 += 1 << n4 - 9;
                n += 128;
            }
            --n4;
        }
        n4 = 0;
        while (n4 < byArray.length) {
            n3 = byArray[n4];
            if (n3 != 0) {
                n6 = nArray2[n3];
                n2 = DeflaterHuffman.bitReverse(n6);
                if (n3 <= 9) {
                    do {
                        this.tree[n2] = (short)(n4 << 4 | n3);
                    } while ((n2 += 1 << n3) < 512);
                } else {
                    n = this.tree[n2 & 0x1FF];
                    int n9 = 1 << (n & 0xF);
                    n = -(n >> 4);
                    do {
                        this.tree[n | n2 >> 9] = (short)(n4 << 4 | n3);
                    } while ((n2 += 1 << n3) < n9);
                }
                nArray2[n3] = n6 + (1 << 16 - n3);
            }
            ++n4;
        }
    }

    public int getSymbol(StreamManipulator streamManipulator) throws DataFormatException {
        int n = streamManipulator.peekBits(9);
        if (n >= 0) {
            short s = this.tree[n];
            if (s >= 0) {
                streamManipulator.dropBits(s & 0xF);
                return s >> 4;
            }
            int n2 = -(s >> 4);
            int n3 = s & 0xF;
            n = streamManipulator.peekBits(n3);
            if (n >= 0) {
                s = this.tree[n2 | n >> 9];
                streamManipulator.dropBits(s & 0xF);
                return s >> 4;
            }
            int n4 = streamManipulator.getAvailableBits();
            n = streamManipulator.peekBits(n4);
            s = this.tree[n2 | n >> 9];
            if ((s & 0xF) <= n4) {
                streamManipulator.dropBits(s & 0xF);
                return s >> 4;
            }
            return -1;
        }
        int n5 = streamManipulator.getAvailableBits();
        n = streamManipulator.peekBits(n5);
        short s = this.tree[n];
        if (s >= 0 && (s & 0xF) <= n5) {
            streamManipulator.dropBits(s & 0xF);
            return s >> 4;
        }
        return -1;
    }

    public InflaterHuffmanTree(byte[] byArray) throws DataFormatException {
        this.buildTree(byArray);
    }

    static {
        try {
            byte[] byArray = new byte[288];
            int n = 0;
            while (n < 144) {
                byArray[n++] = 8;
            }
            while (n < 256) {
                byArray[n++] = 9;
            }
            while (n < 280) {
                byArray[n++] = 7;
            }
            while (n < 288) {
                byArray[n++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(byArray);
            byArray = new byte[32];
            n = 0;
            while (n < 32) {
                byArray[n++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(byArray);
        }
        catch (DataFormatException dataFormatException) {
            throw new InternalError("InflaterHuffmanTree: static tree length illegal");
        }
    }
}

