/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.Adler32;
import ClassLib.Common.java.util.zip.InflaterDynHeader;
import ClassLib.Common.java.util.zip.InflaterHuffmanTree;
import ClassLib.Common.java.util.zip.OutputWindow;
import ClassLib.Common.java.util.zip.StreamManipulator;
import java.util.zip.DataFormatException;

public class Inflater {
    private static final int[] CPLENS = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258};
    private static final int[] CPLEXT;
    private static final int[] CPDIST;
    private static final int[] CPDEXT;
    private static final int DECODE_HEADER = 0;
    private static final int DECODE_DICT = 1;
    private static final int DECODE_BLOCKS = 2;
    private static final int DECODE_STORED_LEN1 = 3;
    private static final int DECODE_STORED_LEN2 = 4;
    private static final int DECODE_STORED = 5;
    private static final int DECODE_DYN_HEADER = 6;
    private static final int DECODE_HUFFMAN = 7;
    private static final int DECODE_HUFFMAN_LENBITS = 8;
    private static final int DECODE_HUFFMAN_DIST = 9;
    private static final int DECODE_HUFFMAN_DISTBITS = 10;
    private static final int DECODE_CHKSUM = 11;
    private static final int FINISHED = 12;
    private int mode;
    private int readAdler;
    private int neededBits;
    private int repLength;
    private int repDist;
    private int uncomprLen;
    private boolean isLastBlock;
    private int totalOut;
    private int totalIn;
    private boolean nowrap;
    private StreamManipulator input;
    private OutputWindow outputWindow;
    private InflaterDynHeader dynHeader;
    private InflaterHuffmanTree litlenTree;
    private InflaterHuffmanTree distTree;
    private Adler32 adler;

    private static final void initIDs() {
    }

    public void __init__(boolean bl) {
        this.nowrap = bl;
        this.adler = new Adler32();
        this.input = new StreamManipulator();
        this.outputWindow = new OutputWindow();
        this.mode = bl ? 2 : 0;
    }

    public void reset() {
        this.mode = this.nowrap ? 2 : 0;
        this.totalOut = 0;
        this.totalIn = 0;
        this.input.reset();
        this.outputWindow.reset();
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.isLastBlock = false;
        this.adler.reset();
    }

    private final boolean decodeHeader() throws DataFormatException {
        int n = this.input.peekBits(16);
        if (n < 0) {
            return false;
        }
        this.input.dropBits(16);
        n = (n << 8 | n >> 8) & (char)-1;
        if (n % 31 != 0) {
            throw new DataFormatException("Header checksum illegal");
        }
        if ((n & 0xF00) != 2048) {
            throw new DataFormatException("Compression Method unknown");
        }
        if ((n & 0x20) == 0) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.neededBits = 32;
        }
        return true;
    }

    private final boolean decodeDict() {
        while (this.neededBits > 0) {
            int n = this.input.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n;
            this.neededBits -= 8;
        }
        return false;
    }

    private final boolean decodeHuffman() throws DataFormatException {
        int n = this.outputWindow.getFreeSpace();
        while (n >= 258) {
            switch (this.mode) {
                case 7: {
                    int n2;
                    while (((n2 = this.litlenTree.getSymbol(this.input)) & 0xFFFFFF00) == 0) {
                        this.outputWindow.write(n2);
                        if (--n >= 258) continue;
                        return true;
                    }
                    if (n2 < 257) {
                        if (n2 < 0) {
                            return false;
                        }
                        this.distTree = null;
                        this.litlenTree = null;
                        this.mode = 2;
                        return true;
                    }
                    try {
                        this.repLength = CPLENS[n2 - 257];
                        this.neededBits = CPLEXT[n2 - 257];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep length code");
                    }
                }
                case 8: {
                    int n3;
                    if (this.neededBits > 0) {
                        this.mode = 8;
                        n3 = this.input.peekBits(this.neededBits);
                        if (n3 < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repLength += n3;
                    }
                    this.mode = 9;
                }
                case 9: {
                    int n2 = this.distTree.getSymbol(this.input);
                    if (n2 < 0) {
                        return false;
                    }
                    try {
                        this.repDist = CPDIST[n2];
                        this.neededBits = CPDEXT[n2];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw new DataFormatException("Illegal rep dist code");
                    }
                }
                case 10: {
                    int n3;
                    if (this.neededBits > 0) {
                        this.mode = 10;
                        n3 = this.input.peekBits(this.neededBits);
                        if (n3 < 0) {
                            return false;
                        }
                        this.input.dropBits(this.neededBits);
                        this.repDist += n3;
                    }
                    this.outputWindow.repeat(this.repLength, this.repDist);
                    n -= this.repLength;
                    this.mode = 7;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return true;
    }

    private final boolean decodeChksum() throws DataFormatException {
        while (this.neededBits > 0) {
            int n = this.input.peekBits(8);
            if (n < 0) {
                return false;
            }
            this.input.dropBits(8);
            this.readAdler = this.readAdler << 8 | n;
            this.neededBits -= 8;
        }
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new DataFormatException("Adler chksum doesn't match: " + Integer.toHexString((int)this.adler.getValue()) + " vs. " + Integer.toHexString(this.readAdler));
        }
        this.mode = 12;
        return false;
    }

    private final boolean decode() throws DataFormatException {
        switch (this.mode) {
            case 0: {
                return this.decodeHeader();
            }
            case 1: {
                return this.decodeDict();
            }
            case 11: {
                return this.decodeChksum();
            }
            case 2: {
                if (this.isLastBlock) {
                    if (this.nowrap) {
                        this.mode = 12;
                        return false;
                    }
                    this.input.skipToByteBoundary();
                    this.neededBits = 32;
                    this.mode = 11;
                    return true;
                }
                int n = this.input.peekBits(3);
                if (n < 0) {
                    return false;
                }
                this.input.dropBits(3);
                if ((n & 1) != 0) {
                    this.isLastBlock = true;
                }
                switch (n >> 1) {
                    case 0: {
                        this.input.skipToByteBoundary();
                        this.mode = 3;
                        break;
                    }
                    case 1: {
                        this.litlenTree = InflaterHuffmanTree.defLitLenTree;
                        this.distTree = InflaterHuffmanTree.defDistTree;
                        this.mode = 7;
                        break;
                    }
                    case 2: {
                        this.dynHeader = new InflaterDynHeader();
                        this.mode = 6;
                        break;
                    }
                    default: {
                        throw new DataFormatException("Unknown block type " + n);
                    }
                }
                return true;
            }
            case 3: {
                this.uncomprLen = this.input.peekBits(16);
                if (this.uncomprLen < 0) {
                    return false;
                }
                this.input.dropBits(16);
                this.mode = 4;
            }
            case 4: {
                int n = this.input.peekBits(16);
                if (n < 0) {
                    return false;
                }
                this.input.dropBits(16);
                if (n != (this.uncomprLen ^ (char)-1)) {
                    throw new DataFormatException("broken uncompressed block");
                }
                this.mode = 5;
            }
            case 5: {
                int n = this.outputWindow.copyStored(this.input, this.uncomprLen);
                this.uncomprLen -= n;
                if (this.uncomprLen == 0) {
                    this.mode = 2;
                    return true;
                }
                return this.input.needsInput() ^ true;
            }
            case 6: {
                if (!this.dynHeader.decode(this.input)) {
                    return false;
                }
                this.litlenTree = this.dynHeader.buildLitLenTree();
                this.distTree = this.dynHeader.buildDistTree();
                this.mode = 7;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.decodeHuffman();
            }
            case 12: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    public void setDictionary(byte[] byArray) {
        this.setDictionary(byArray, 0, byArray.length);
    }

    public void setDictionary(byte[] byArray, int n, int n2) {
        if (!this.needsDictionary()) {
            throw new IllegalStateException();
        }
        this.adler.update(byArray, n, n2);
        if ((int)this.adler.getValue() != this.readAdler) {
            throw new IllegalArgumentException("Wrong adler checksum");
        }
        this.adler.reset();
        this.outputWindow.copyDict(byArray, n, n2);
        this.mode = 2;
    }

    public void setInput(byte[] byArray) {
        this.setInput(byArray, 0, byArray.length);
    }

    public void setInput(byte[] byArray, int n, int n2) {
        this.input.setInput(byArray, n, n2);
        this.totalIn += n2;
    }

    public int inflate(byte[] byArray) throws DataFormatException {
        return this.inflate(byArray, 0, byArray.length);
    }

    public int inflate(byte[] byArray, int n, int n2) throws DataFormatException {
        if (n2 == 0) {
            return 0;
        }
        if (n < 0 || n > n + n2 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        do {
            if (this.mode == 11) continue;
            int n4 = this.outputWindow.copyOutput(byArray, n, n2);
            this.adler.update(byArray, n, n4);
            n += n4;
            n3 += n4;
            this.totalOut += n4;
            if ((n2 -= n4) != 0) continue;
            return n3;
        } while (this.decode() || this.outputWindow.getAvailable() > 0 && this.mode != 11);
        return n3;
    }

    public boolean needsInput() {
        return this.input.needsInput();
    }

    public boolean needsDictionary() {
        boolean bl = false;
        if (this.mode == 1 && this.neededBits == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean finished() {
        boolean bl = false;
        if (this.mode == 12 && this.outputWindow.getAvailable() == 0) {
            bl = true;
        }
        return bl;
    }

    public int getAdler() {
        return this.needsDictionary() ? this.readAdler : (int)this.adler.getValue();
    }

    public int getTotalOut() {
        return this.totalOut;
    }

    public int getTotalIn() {
        return this.totalIn - this.getRemaining();
    }

    public int getRemaining() {
        return this.input.getAvailableBytes();
    }

    public void end() {
        this.outputWindow = null;
        this.input = null;
        this.dynHeader = null;
        this.litlenTree = null;
        this.distTree = null;
        this.adler = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public Inflater() {
        this(false);
    }

    public Inflater(boolean bl) {
        this.__init__(bl);
    }

    static {
        int[] nArray = new int[29];
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 3;
        nArray[18] = 3;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        CPLEXT = nArray;
        CPDIST = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        int[] nArray2 = new int[30];
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 3;
        nArray2[9] = 3;
        nArray2[10] = 4;
        nArray2[11] = 4;
        nArray2[12] = 5;
        nArray2[13] = 5;
        nArray2[14] = 6;
        nArray2[15] = 6;
        nArray2[16] = 7;
        nArray2[17] = 7;
        nArray2[18] = 8;
        nArray2[19] = 8;
        nArray2[20] = 9;
        nArray2[21] = 9;
        nArray2[22] = 10;
        nArray2[23] = 10;
        nArray2[24] = 11;
        nArray2[25] = 11;
        nArray2[26] = 12;
        nArray2[27] = 12;
        nArray2[28] = 13;
        nArray2[29] = 13;
        CPDEXT = nArray2;
    }
}

