/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util.zip;

import ClassLib.Common.java.util.zip.DeflaterPending;

class DeflaterHuffman {
    private static final int BUFSIZE = 16384;
    private static final int LITERAL_NUM = 286;
    private static final int DIST_NUM = 30;
    private static final int BITLEN_NUM = 19;
    private static final int REP_3_6 = 16;
    private static final int REP_3_10 = 17;
    private static final int REP_11_138 = 18;
    private static final int EOF_SYMBOL = 256;
    private static final int[] BL_ORDER;
    private static final String bit4Reverse = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";
    private static short[] staticLCodes;
    private static byte[] staticLLength;
    private static short[] staticDCodes;
    private static byte[] staticDLength;
    DeflaterPending pending;
    private Tree literalTree;
    private Tree distTree;
    private Tree blTree;
    private short[] d_buf;
    private byte[] l_buf;
    private int last_lit;
    private int extra_bits;

    static short bitReverse(int n) {
        return (short)(bit4Reverse.charAt(n & 0xF) << 12 | bit4Reverse.charAt(n >> 4 & 0xF) << 8 | bit4Reverse.charAt(n >> 8 & 0xF) << 4 | bit4Reverse.charAt(n >> 12));
    }

    public final void reset() {
        this.last_lit = 0;
        this.extra_bits = 0;
        this.literalTree.reset();
        this.distTree.reset();
        this.blTree.reset();
    }

    private final int l_code(int n) {
        if (n == 255) {
            return 285;
        }
        int n2 = 257;
        while (n >= 8) {
            n2 += 4;
            n >>= 1;
        }
        return n2 + n;
    }

    private final int d_code(int n) {
        int n2 = 0;
        while (n >= 4) {
            n2 += 2;
            n >>= 1;
        }
        return n2 + n;
    }

    public void sendAllTrees(int n) {
        this.blTree.buildCodes();
        this.literalTree.buildCodes();
        this.distTree.buildCodes();
        this.pending.writeBits(this.literalTree.numCodes - 257, 5);
        this.pending.writeBits(this.distTree.numCodes - 1, 5);
        this.pending.writeBits(n - 4, 4);
        int n2 = 0;
        while (n2 < n) {
            this.pending.writeBits(this.blTree.length[BL_ORDER[n2]], 3);
            ++n2;
        }
        this.literalTree.writeTree(this.blTree);
        this.distTree.writeTree(this.blTree);
    }

    public void compressBlock() {
        int n = 0;
        while (n < this.last_lit) {
            int n2 = this.l_buf[n] & 0xFF;
            int n3 = this.d_buf[n];
            if (n3-- != 0) {
                int n4 = this.l_code(n2);
                this.literalTree.writeSymbol(n4);
                int n5 = (n4 - 261) / 4;
                if (n5 > 0 && n5 <= 5) {
                    this.pending.writeBits(n2 & (1 << n5) - 1, n5);
                }
                int n6 = this.d_code(n3);
                this.distTree.writeSymbol(n6);
                n5 = n6 / 2 - 1;
                if (n5 > 0) {
                    this.pending.writeBits(n3 & (1 << n5) - 1, n5);
                }
            } else {
                this.literalTree.writeSymbol(n2);
            }
            ++n;
        }
        this.literalTree.writeSymbol(256);
    }

    public void flushStoredBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.pending.writeBits(bl ? 1 : 0, 3);
        this.pending.alignToByte();
        this.pending.writeShort(n2);
        this.pending.writeShort(~n2);
        this.pending.writeBlock(byArray, n, n2);
        this.reset();
    }

    public void flushBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.literalTree.freqs[256] = (short)(this.literalTree.freqs[256] + 1);
        this.literalTree.buildTree();
        this.distTree.buildTree();
        this.literalTree.calcBLFreq(this.blTree);
        this.distTree.calcBLFreq(this.blTree);
        this.blTree.buildTree();
        int n3 = 4;
        int n4 = 18;
        while (n4 > n3) {
            if (this.blTree.length[BL_ORDER[n4]] > 0) {
                n3 = n4 + 1;
            }
            --n4;
        }
        n4 = 14 + n3 * 3 + this.blTree.getEncodedLength() + this.literalTree.getEncodedLength() + this.distTree.getEncodedLength() + this.extra_bits;
        int n5 = this.extra_bits;
        int n6 = 0;
        while (n6 < 286) {
            n5 += this.literalTree.freqs[n6] * staticLLength[n6];
            ++n6;
        }
        n6 = 0;
        while (n6 < 30) {
            n5 += this.distTree.freqs[n6] * staticDLength[n6];
            ++n6;
        }
        if (n4 >= n5) {
            n4 = n5;
        }
        if (n >= 0 && n2 + 4 < n4 >> 3) {
            this.flushStoredBlock(byArray, n, n2, bl);
        } else if (n4 == n5) {
            this.pending.writeBits(2 + bl, 3);
            this.literalTree.setStaticCodes(staticLCodes, staticLLength);
            this.distTree.setStaticCodes(staticDCodes, staticDLength);
            this.compressBlock();
            this.reset();
        } else {
            this.pending.writeBits(4 + bl, 3);
            this.sendAllTrees(n3);
            this.compressBlock();
            this.reset();
        }
    }

    public final boolean isFull() {
        boolean bl = false;
        if (this.last_lit == 16384) {
            bl = true;
        }
        return bl;
    }

    public final boolean tallyLit(int n) {
        this.d_buf[this.last_lit] = 0;
        this.l_buf[this.last_lit++] = (byte)n;
        int n2 = n;
        this.literalTree.freqs[n2] = (short)(this.literalTree.freqs[n2] + 1);
        boolean bl = false;
        if (this.last_lit == 16384) {
            bl = true;
        }
        return bl;
    }

    public final boolean tallyDist(int n, int n2) {
        int n3;
        int n4;
        this.d_buf[this.last_lit] = (short)n;
        this.l_buf[this.last_lit++] = (byte)(n2 - 3);
        int n5 = n4 = this.l_code(n2 - 3);
        this.literalTree.freqs[n5] = (short)(this.literalTree.freqs[n5] + 1);
        if (n4 >= 265 && n4 < 285) {
            this.extra_bits += (n4 - 261) / 4;
        }
        int n6 = n3 = this.d_code(n - 1);
        this.distTree.freqs[n6] = (short)(this.distTree.freqs[n6] + 1);
        if (n3 >= 4) {
            this.extra_bits += n3 / 2 - 1;
        }
        boolean bl = false;
        if (this.last_lit == 16384) {
            bl = true;
        }
        return bl;
    }

    public DeflaterHuffman(DeflaterPending deflaterPending) {
        this.pending = deflaterPending;
        this.literalTree = new Tree(286, 257, 15);
        this.distTree = new Tree(30, 1, 15);
        this.blTree = new Tree(19, 4, 7);
        this.d_buf = new short[16384];
        this.l_buf = new byte[16384];
    }

    static {
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        BL_ORDER = nArray;
        staticLCodes = new short[286];
        staticLLength = new byte[286];
        int n = 0;
        while (n < 144) {
            DeflaterHuffman.staticLCodes[n] = DeflaterHuffman.bitReverse(48 + n << 8);
            DeflaterHuffman.staticLLength[n++] = 8;
        }
        while (n < 256) {
            DeflaterHuffman.staticLCodes[n] = DeflaterHuffman.bitReverse(256 + n << 7);
            DeflaterHuffman.staticLLength[n++] = 9;
        }
        while (n < 280) {
            DeflaterHuffman.staticLCodes[n] = DeflaterHuffman.bitReverse(-256 + n << 9);
            DeflaterHuffman.staticLLength[n++] = 7;
        }
        while (n < 286) {
            DeflaterHuffman.staticLCodes[n] = DeflaterHuffman.bitReverse(-88 + n << 8);
            DeflaterHuffman.staticLLength[n++] = 8;
        }
        staticDCodes = new short[30];
        staticDLength = new byte[30];
        n = 0;
        while (n < 30) {
            DeflaterHuffman.staticDCodes[n] = DeflaterHuffman.bitReverse(n << 11);
            DeflaterHuffman.staticDLength[n] = 5;
            ++n;
        }
    }

    class Tree {
        short[] freqs;
        short[] codes;
        byte[] length;
        int[] bl_counts;
        int minNumCodes;
        int numCodes;
        int maxLength;

        void reset() {
            int n = 0;
            while (n < this.freqs.length) {
                this.freqs[n] = 0;
                ++n;
            }
            this.codes = null;
            this.length = null;
        }

        final void writeSymbol(int n) {
            DeflaterHuffman.this.pending.writeBits(this.codes[n] & (char)-1, this.length[n]);
        }

        final void checkEmpty() {
            boolean bl = true;
            int n = 0;
            while (n < this.freqs.length) {
                if (this.freqs[n] != 0) {
                    System.err.println("freqs[" + n + "] == " + this.freqs[n]);
                    bl = false;
                }
                ++n;
            }
            if (!bl) {
                throw new InternalError();
            }
            System.err.println("checkEmpty suceeded!");
        }

        void setStaticCodes(short[] sArray, byte[] byArray) {
            this.codes = sArray;
            this.length = byArray;
        }

        public void buildCodes() {
            int[] nArray = new int[this.maxLength];
            int n = 0;
            this.codes = new short[this.freqs.length];
            int n2 = 0;
            while (n2 < this.maxLength) {
                nArray[n2] = n;
                n += this.bl_counts[n2] << 15 - n2;
                ++n2;
            }
            n2 = 0;
            while (n2 < this.numCodes) {
                byte by = this.length[n2];
                if (by > 0) {
                    this.codes[n2] = DeflaterHuffman.bitReverse(nArray[by - 1]);
                    int n3 = by - 1;
                    nArray[n3] = nArray[n3] + (1 << 16 - by);
                }
                ++n2;
            }
        }

        private final void buildLength(int[] nArray) {
            int n;
            this.length = new byte[this.freqs.length];
            int n2 = nArray.length / 2;
            int n3 = (n2 + 1) / 2;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.maxLength) {
                this.bl_counts[n5] = 0;
                ++n5;
            }
            int[] nArray2 = new int[n2];
            nArray2[n2 - 1] = 0;
            int n6 = n2 - 1;
            while (n6 >= 0) {
                if (nArray[2 * n6 + 1] != -1) {
                    n = nArray2[n6] + 1;
                    if (n > this.maxLength) {
                        n = this.maxLength;
                        ++n4;
                    }
                    int n7 = n;
                    nArray2[nArray[2 * n6 + 1]] = n7;
                    nArray2[nArray[2 * n6]] = n7;
                } else {
                    n = nArray2[n6];
                    int n8 = n - 1;
                    this.bl_counts[n8] = this.bl_counts[n8] + 1;
                    this.length[nArray[2 * n6]] = (byte)nArray2[n6];
                }
                --n6;
            }
            if (n4 == 0) {
                return;
            }
            n6 = this.maxLength - 1;
            while (true) {
                if (this.bl_counts[--n6] == 0) {
                    continue;
                }
                do {
                    int n9 = n6++;
                    this.bl_counts[n9] = this.bl_counts[n9] - 1;
                    int n10 = n6;
                    this.bl_counts[n10] = this.bl_counts[n10] + 1;
                } while ((n4 -= 1 << this.maxLength - 1 - n6) > 0 && n6 < this.maxLength - 1);
                if (n4 <= 0) break;
            }
            int n11 = this.maxLength - 1;
            this.bl_counts[n11] = this.bl_counts[n11] + n4;
            int n12 = this.maxLength - 2;
            this.bl_counts[n12] = this.bl_counts[n12] - n4;
            n = 2 * n3;
            int n13 = this.maxLength;
            while (n13 != 0) {
                int n14 = this.bl_counts[n13 - 1];
                while (n14 > 0) {
                    int n15;
                    if (nArray[(n15 = 2 * nArray[n++]) + 1] != -1) continue;
                    this.length[nArray[n15]] = (byte)n13;
                    --n14;
                }
                --n13;
            }
        }

        void buildTree() {
            int n;
            int n2;
            int n3 = this.freqs.length;
            int[] nArray = new int[n3];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                short s = this.freqs[n6];
                if (s != 0) {
                    int n7 = n4++;
                    while (n7 > 0 && this.freqs[nArray[n2 = (n7 - 1) / 2]] > s) {
                        nArray[n7] = nArray[n2];
                        n7 = n2;
                    }
                    nArray[n7] = n6;
                    n5 = n6;
                }
                ++n6;
            }
            while (n4 < 2) {
                int n8 = 0;
                if (n5 < 2) {
                    n8 = ++n5;
                }
                n6 = n8;
                nArray[n4++] = n6;
            }
            this.numCodes = Math.max(n5 + 1, this.minNumCodes);
            n6 = n4;
            int[] nArray2 = new int[4 * n4 - 2];
            int[] nArray3 = new int[2 * n4 - 1];
            n2 = n6;
            int n9 = 0;
            while (n9 < n4) {
                nArray2[2 * n9] = n = nArray[n9];
                nArray2[2 * n9 + 1] = -1;
                nArray3[n9] = this.freqs[n] << 8;
                nArray[n9] = n9;
                ++n9;
            }
            do {
                n9 = nArray[0];
                n = nArray[--n4];
                int n10 = 0;
                int n11 = 1;
                while (n11 < n4) {
                    if (n11 + 1 < n4 && nArray3[nArray[n11]] > nArray3[nArray[n11 + 1]]) {
                        ++n11;
                    }
                    nArray[n10] = nArray[n11];
                    n10 = n11;
                    n11 = n11 * 2 + 1;
                }
                int n12 = nArray3[n];
                while ((n11 = n10) > 0 && nArray3[nArray[n10 = (n11 - 1) / 2]] > n12) {
                    nArray[n11] = nArray[n10];
                }
                nArray[n11] = n;
                int n13 = nArray[0];
                n = n2++;
                nArray2[2 * n] = n9;
                nArray2[2 * n + 1] = n13;
                int n14 = Math.min(nArray3[n9] & 0xFF, nArray3[n13] & 0xFF);
                nArray3[n] = n12 = nArray3[n9] + nArray3[n13] - n14 + 1;
                n10 = 0;
                n11 = 1;
                while (n11 < n4) {
                    if (n11 + 1 < n4 && nArray3[nArray[n11]] > nArray3[nArray[n11 + 1]]) {
                        ++n11;
                    }
                    nArray[n10] = nArray[n11];
                    n10 = n11;
                    n11 = n10 * 2 + 1;
                }
                while ((n11 = n10) > 0 && nArray3[nArray[n10 = (n11 - 1) / 2]] > n12) {
                    nArray[n11] = nArray[n10];
                }
                nArray[n11] = n;
            } while (n4 > 1);
            if (nArray[0] != nArray2.length / 2 - 1) {
                throw new RuntimeException("Weird!");
            }
            this.buildLength(nArray2);
        }

        int getEncodedLength() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.freqs.length) {
                n += this.freqs[n2] * this.length[n2];
                ++n2;
            }
            return n;
        }

        void calcBLFreq(Tree tree) {
            byte by = -1;
            int n = 0;
            while (n < this.numCodes) {
                int n2;
                int n3;
                int n4 = 1;
                byte by2 = this.length[n];
                if (by2 == 0) {
                    n3 = 138;
                    n2 = 3;
                } else {
                    n3 = 6;
                    n2 = 3;
                    if (by != by2) {
                        byte by3 = by2;
                        tree.freqs[by3] = (short)(tree.freqs[by3] + 1);
                        n4 = 0;
                    }
                }
                by = by2;
                ++n;
                while (n < this.numCodes && by == this.length[n]) {
                    ++n;
                    if (++n4 >= n3) break;
                }
                if (n4 < n2) {
                    byte by4 = by;
                    tree.freqs[by4] = (short)(tree.freqs[by4] + n4);
                    continue;
                }
                if (by != 0) {
                    tree.freqs[16] = (short)(tree.freqs[16] + 1);
                    continue;
                }
                if (n4 <= 10) {
                    tree.freqs[17] = (short)(tree.freqs[17] + 1);
                    continue;
                }
                tree.freqs[18] = (short)(tree.freqs[18] + 1);
            }
        }

        void writeTree(Tree tree) {
            byte by = -1;
            int n = 0;
            while (n < this.numCodes) {
                int n2;
                int n3;
                int n4 = 1;
                byte by2 = this.length[n];
                if (by2 == 0) {
                    n3 = 138;
                    n2 = 3;
                } else {
                    n3 = 6;
                    n2 = 3;
                    if (by != by2) {
                        tree.writeSymbol(by2);
                        n4 = 0;
                    }
                }
                by = by2;
                ++n;
                while (n < this.numCodes && by == this.length[n]) {
                    ++n;
                    if (++n4 >= n3) break;
                }
                if (n4 < n2) {
                    while (n4-- > 0) {
                        tree.writeSymbol(by);
                    }
                    continue;
                }
                if (by != 0) {
                    tree.writeSymbol(16);
                    DeflaterHuffman.this.pending.writeBits(n4 - 3, 2);
                    continue;
                }
                if (n4 <= 10) {
                    tree.writeSymbol(17);
                    DeflaterHuffman.this.pending.writeBits(n4 - 3, 3);
                    continue;
                }
                tree.writeSymbol(18);
                DeflaterHuffman.this.pending.writeBits(n4 - 11, 7);
            }
        }

        Tree(int n, int n2, int n3) {
            this.minNumCodes = n2;
            this.maxLength = n3;
            this.freqs = new short[n];
            this.bl_counts = new int[n3];
        }
    }
}

