/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.util;

import Bootstrap.MethodInvocation;
import Clazz.jq_Class;
import Clazz.jq_DontAlign;
import Clazz.jq_NameAndDesc;
import Clazz.jq_StaticMethod;
import Main.jq;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Util.Assert;

abstract class TimeZone {
    public static TimeZoneInformation cachedTimeZone;
    public static int cachedTimeZoneId;
    public static final int TIME_ZONE_ID_UNKNOWN = 0;
    public static final int TIME_ZONE_ID_STANDARD = 1;
    public static final int TIME_ZONE_ID_DAYLIGHT = 2;
    public static final int TIME_ZONE_ID_INVALID = -1;
    public static SystemInterface.ExternalLink GetTimeZoneInformation;
    static /* synthetic */ Class class$java$util$TimeZone;

    private static final String getSystemTimeZoneID(String string, String string2) {
        Object object;
        if (cachedTimeZone == null) {
            object = new TimeZoneInformation();
            int n = TimeZone.get_time_zone_information((TimeZoneInformation)object);
            if (n == -1) {
                return null;
            }
            cachedTimeZone = object;
            cachedTimeZoneId = n;
        }
        switch (cachedTimeZoneId) {
            case 0: 
            case 1: {
                object = cachedTimeZone.getStandardName();
                break;
            }
            case 2: {
                object = cachedTimeZone.getDaylightName();
                break;
            }
            default: {
                return null;
            }
        }
        if (((String)object).equals("Pacific Standard Time") || ((String)object).equals("Pacific Daylight Time")) {
            return "America/Los Angeles";
        }
        return "America/Los Angeles";
    }

    private static final String getSystemGMTOffsetID() {
        String string;
        int n;
        if (cachedTimeZone == null) {
            TimeZoneInformation timeZoneInformation = new TimeZoneInformation();
            n = TimeZone.get_time_zone_information(timeZoneInformation);
            if (n == -1) {
                return null;
            }
            cachedTimeZone = timeZoneInformation;
            cachedTimeZoneId = n;
        }
        int n2 = -TimeZone.cachedTimeZone.Bias;
        n = n2 / 60;
        int n3 = Math.abs(n2 % 60);
        if (n >= 0) {
            string = n <= 9 ? "+0" + n : "+" + n;
        } else {
            n = -n;
            n3 = -n3;
            string = n <= 9 ? "-0" + n : "-" + n;
        }
        boolean bl = false;
        if (n3 >= 0) {
            bl = true;
        }
        Assert._assert(bl);
        String string2 = n3 <= 9 ? ":0" + n3 : ":" + n3;
        return "GMT" + string + string2;
    }

    public static int get_time_zone_information(TimeZoneInformation timeZoneInformation) {
        try {
            CodeAddress codeAddress = GetTimeZoneInformation.resolve();
            HeapAddress heapAddress = HeapAddress.addressOf(timeZoneInformation);
            Unsafe.pushArgA(heapAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(codeAddress);
            Unsafe.getThreadBlock().enableThreadSwitch();
            return n;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0;
        }
    }

    public static void boot() {
        SystemInterface.Library library = SystemInterface.registerLibrary("kernel32");
        GetTimeZoneInformation = library != null ? library.resolve("GetTimeZoneInformation") : null;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    TimeZone() {
    }

    static {
        if (jq.RunningNative) {
            TimeZone.boot();
        } else if (jq.on_vm_startup != null) {
            Class clazz = class$java$util$TimeZone;
            if (clazz == null) {
                clazz = class$java$util$TimeZone = TimeZone.class$("[Ljava.util.TimeZone;", false);
            }
            jq_Class jq_Class2 = (jq_Class)Reflection.getJQType(clazz);
            jq_StaticMethod jq_StaticMethod2 = jq_Class2.getDeclaredStaticMethod(new jq_NameAndDesc("boot", "()V"));
            MethodInvocation methodInvocation = new MethodInvocation(jq_StaticMethod2, null);
            jq.on_vm_startup.add(methodInvocation);
        }
    }

    public static class TimeZoneInformation
    implements jq_DontAlign {
        int Bias;
        long StandardName0;
        long StandardName1;
        long StandardName2;
        long StandardName3;
        short StandardDate_wYear;
        short StandardDate_wMonth;
        short StandardDate_wDayOfWeek;
        short StandardDate_wDay;
        short StandardDate_wHour;
        short StandardDate_wMinute;
        short StandardDate_wSecond;
        short StandardDate_wMilliseconds;
        int StandardBias;
        long DaylightName0;
        long DaylightName1;
        long DaylightName2;
        long DaylightName3;
        short DaylightDate_wYear;
        short DaylightDate_wMonth;
        short DaylightDate_wDayOfWeek;
        short DaylightDate_wDay;
        short DaylightDate_wHour;
        short DaylightDate_wMinute;
        short DaylightDate_wSecond;
        short DaylightDate_wMilliseconds;
        int DaylightBias;

        public void dump() {
            Debug.writeln("Bias=", this.Bias);
            Debug.write("StandardName=");
            HeapAddress heapAddress = this.getStandardNameAddress();
            try {
                Unsafe.pushArg(TimeZoneInformation.strlen(heapAddress));
                Unsafe.pushArgA(heapAddress);
                Unsafe.invoke(SystemInterface.debugwwriteln_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.write("StandardDate={ wYear=", (int)this.StandardDate_wYear);
            Debug.write(", wMonth=", (int)this.StandardDate_wMonth);
            Debug.write(", wDayOfWeek=", (int)this.StandardDate_wDayOfWeek);
            Debug.write(", wDay=", (int)this.StandardDate_wDay);
            Debug.write(", wHour=", (int)this.StandardDate_wHour);
            Debug.write(", wMinute=", (int)this.StandardDate_wMinute);
            Debug.write(", wSecond=", (int)this.StandardDate_wSecond);
            Debug.write(", wMilliseconds=", (int)this.StandardDate_wMilliseconds);
            Debug.writeln(" }");
            Debug.writeln("StandardBias=", this.StandardBias);
            Debug.write("DaylightName=");
            heapAddress = this.getDaylightNameAddress();
            try {
                Unsafe.pushArg(TimeZoneInformation.strlen(heapAddress));
                Unsafe.pushArgA(heapAddress);
                Unsafe.invoke(SystemInterface.debugwwriteln_8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Debug.write("DaylightDate={ wYear=", (int)this.DaylightDate_wYear);
            Debug.write(", wMonth=", (int)this.DaylightDate_wMonth);
            Debug.write(", wDayOfWeek=", (int)this.DaylightDate_wDayOfWeek);
            Debug.write(", wDay=", (int)this.DaylightDate_wDay);
            Debug.write(", wHour=", (int)this.DaylightDate_wHour);
            Debug.write(", wMinute=", (int)this.DaylightDate_wMinute);
            Debug.write(", wSecond=", (int)this.DaylightDate_wSecond);
            Debug.write(", wMilliseconds=", (int)this.DaylightDate_wMilliseconds);
            Debug.writeln(" }");
            Debug.writeln("DaylightBias=", this.Bias);
        }

        public String getStandardName() {
            HeapAddress heapAddress = this.getStandardNameAddress();
            return TimeZoneInformation.fromCString(heapAddress);
        }

        HeapAddress getStandardNameAddress() {
            return (HeapAddress)HeapAddress.addressOf(this).offset(4);
        }

        public String getDaylightName() {
            HeapAddress heapAddress = this.getDaylightNameAddress();
            return TimeZoneInformation.fromCString(heapAddress);
        }

        HeapAddress getDaylightNameAddress() {
            return (HeapAddress)HeapAddress.addressOf(this).offset(56);
        }

        static String fromCString(HeapAddress heapAddress) {
            char c;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while ((c = (char)heapAddress.peek2()) != '\u0000' && n < 32) {
                stringBuffer.append(c);
                ++n;
                heapAddress = (HeapAddress)heapAddress.offset(2);
            }
            return stringBuffer.toString();
        }

        static int strlen(HeapAddress heapAddress) {
            int n = 0;
            while (heapAddress.peek2() != 0 && n < 32) {
                ++n;
                heapAddress = (HeapAddress)heapAddress.offset(2);
            }
            return n;
        }
    }
}

