/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.lang.reflect;

import ClassLib.ClassLibInterface;
import ClassLib.Common.ClassUtils;
import ClassLib.Common.java.lang.reflect.AccessibleObject;
import Clazz.jq_Class;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Main.jq;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import UTF.Utf8;
import Util.Assert;
import java.lang.reflect.Modifier;

public class Field
extends AccessibleObject {
    public final jq_Field jq_field;
    private Class clazz;
    private String name;
    private Class type;
    private int modifiers;
    private int slot;

    public Class getDeclaringClass() {
        jq_Field jq_Field2 = this.jq_field;
        return jq_Field2.getDeclaringClass().getJavaLangClassObject();
    }

    public String getName() {
        jq_Field jq_Field2 = this.jq_field;
        return jq_Field2.getName().toString();
    }

    public int getModifiers() {
        jq_Field jq_Field2 = this.jq_field;
        return jq_Field2.getAccessFlags();
    }

    public Class getType() {
        jq_Field jq_Field2 = this.jq_field;
        return jq_Field2.getType().getJavaLangClassObject();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        return bl;
    }

    public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2.isReferenceType()) {
                return Reflection.getstatic_A(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return new Integer(Reflection.getstatic_I(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return new Float(Reflection.getstatic_F(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return new Long(Reflection.getstatic_L(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                return new Double(Reflection.getstatic_D(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                return new Boolean(Reflection.getstatic_Z(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return new Byte(Reflection.getstatic_B(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return new Short(Reflection.getstatic_S(jq_StaticField2));
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return new Character(Reflection.getstatic_C(jq_StaticField2));
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2.isReferenceType()) {
                return Reflection.getfield_A(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return new Integer(Reflection.getfield_I(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return new Float(Reflection.getfield_F(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return new Long(Reflection.getfield_L(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                return new Double(Reflection.getfield_D(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                return new Boolean(Reflection.getfield_Z(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return new Byte(Reflection.getfield_B(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return new Short(Reflection.getfield_S(object, jq_InstanceField2));
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return new Character(Reflection.getfield_C(object, jq_InstanceField2));
            }
        }
        Assert.UNREACHABLE();
        return null;
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                return Reflection.getstatic_Z(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                return Reflection.getfield_Z(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return false;
    }

    public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0;
    }

    public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getstatic_C(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getfield_C(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return '\u0000';
    }

    public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getstatic_S(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getfield_S(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0;
    }

    public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getstatic_I(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getstatic_S(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getstatic_C(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getfield_I(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getfield_S(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getfield_C(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0;
    }

    public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getstatic_L(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getstatic_S(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getstatic_C(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getstatic_I(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getfield_L(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getfield_S(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getfield_C(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getfield_I(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0L;
    }

    public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return Reflection.getstatic_F(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getstatic_S(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getstatic_C(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getstatic_I(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getstatic_L(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return Reflection.getfield_F(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getfield_S(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getfield_C(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getfield_I(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getfield_L(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0.0f;
    }

    public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                return Reflection.getstatic_D(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getstatic_B(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getstatic_S(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getstatic_C(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getstatic_I(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getstatic_L(jq_StaticField2);
            }
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return Reflection.getstatic_L(jq_StaticField2);
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                return Reflection.getfield_F(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.BYTE) {
                return Reflection.getfield_B(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.SHORT) {
                return Reflection.getfield_S(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.CHAR) {
                return Reflection.getfield_C(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.INT) {
                return Reflection.getfield_I(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return Reflection.getfield_L(object, jq_InstanceField2);
            }
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return Reflection.getfield_L(object, jq_InstanceField2);
            }
        }
        Assert.UNREACHABLE();
        return 0.0;
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2.isReferenceType()) {
                Reflection.putstatic_A(jq_StaticField2, object2);
            } else if (jq_Type2 == jq_Primitive.INT) {
                int n = Reflection.unwrapToInt(object2);
                Reflection.putstatic_I(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                float f = Reflection.unwrapToFloat(object2);
                Reflection.putstatic_F(jq_StaticField2, f);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                long l = Reflection.unwrapToLong(object2);
                Reflection.putstatic_L(jq_StaticField2, l);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                double d = Reflection.unwrapToDouble(object2);
                Reflection.putstatic_D(jq_StaticField2, d);
            } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                boolean bl = Reflection.unwrapToBoolean(object2);
                Reflection.putstatic_Z(jq_StaticField2, bl);
            } else if (jq_Type2 == jq_Primitive.BYTE) {
                byte by = Reflection.unwrapToByte(object2);
                Reflection.putstatic_B(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                short s = Reflection.unwrapToShort(object2);
                Reflection.putstatic_S(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.CHAR) {
                char c = Reflection.unwrapToChar(object2);
                Reflection.putstatic_C(jq_StaticField2, c);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2.isReferenceType()) {
                Reflection.getfield_A(object, jq_InstanceField2);
            } else if (jq_Type2 == jq_Primitive.INT) {
                int n = Reflection.unwrapToInt(object2);
                Reflection.putfield_I(object, jq_InstanceField2, n);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                float f = Reflection.unwrapToFloat(object2);
                Reflection.putfield_F(object, jq_InstanceField2, f);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                long l = Reflection.unwrapToLong(object2);
                Reflection.putfield_L(object, jq_InstanceField2, l);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                double d = Reflection.unwrapToDouble(object2);
                Reflection.putfield_D(object, jq_InstanceField2, d);
            } else if (jq_Type2 == jq_Primitive.BOOLEAN) {
                boolean bl = Reflection.unwrapToBoolean(object2);
                Reflection.putfield_Z(object, jq_InstanceField2, bl);
            } else if (jq_Type2 == jq_Primitive.BYTE) {
                byte by = Reflection.unwrapToByte(object2);
                Reflection.putfield_B(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                short s = Reflection.unwrapToShort(object2);
                Reflection.putfield_S(object, jq_InstanceField2, s);
            } else if (jq_Type2 == jq_Primitive.CHAR) {
                char c = Reflection.unwrapToChar(object2);
                Reflection.putfield_C(object, jq_InstanceField2, c);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                Reflection.putstatic_Z(jq_StaticField2, bl);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BOOLEAN) {
                Reflection.putfield_Z(object, jq_InstanceField2, bl);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BYTE) {
                Reflection.putstatic_B(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                Reflection.putstatic_S(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putstatic_I(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putstatic_L(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, by);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, by);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.BYTE) {
                Reflection.putfield_B(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.SHORT) {
                Reflection.putfield_S(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putfield_I(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putfield_L(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, by);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, by);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.CHAR) {
                Reflection.putstatic_C(jq_StaticField2, c);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putstatic_I(jq_StaticField2, c);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putstatic_L(jq_StaticField2, c);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, c);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, c);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.CHAR) {
                Reflection.putfield_C(object, jq_InstanceField2, c);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putfield_I(object, jq_InstanceField2, c);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putfield_L(object, jq_InstanceField2, c);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, c);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, c);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.SHORT) {
                Reflection.putstatic_S(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putstatic_I(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putstatic_L(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, s);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, s);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.SHORT) {
                Reflection.putfield_S(object, jq_InstanceField2, s);
            } else if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putfield_I(object, jq_InstanceField2, s);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putfield_L(object, jq_InstanceField2, s);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, s);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, s);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putstatic_I(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putstatic_L(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, n);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, n);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.INT) {
                Reflection.putfield_I(object, jq_InstanceField2, n);
            } else if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putfield_L(object, jq_InstanceField2, n);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, n);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, n);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, f);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, f);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, f);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, f);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putstatic_L(jq_StaticField2, l);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putstatic_F(jq_StaticField2, l);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, l);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.LONG) {
                Reflection.putfield_L(object, jq_InstanceField2, l);
            } else if (jq_Type2 == jq_Primitive.FLOAT) {
                Reflection.putfield_F(object, jq_InstanceField2, l);
            } else if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, l);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        jq_Field jq_Field2 = this.jq_field;
        jq_Type jq_Type2 = jq_Field2.getType();
        if (jq_Field2.isStatic()) {
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_StaticField jq_StaticField2 = (jq_StaticField)jq_Field2;
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putstatic_D(jq_StaticField2, d);
            } else {
                Assert.UNREACHABLE();
            }
        } else {
            jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
            if (!TypeCheck.isAssignable(jq_Reference2, jq_Field2.getDeclaringClass())) {
                throw new IllegalArgumentException();
            }
            if (!this.isAccessible()) {
                ClassUtils.checkCallerAccess(jq_Field2, 2);
            }
            if (!jq_Field2.isFinal()) {
                throw new IllegalAccessException();
            }
            jq_InstanceField jq_InstanceField2 = (jq_InstanceField)jq_Field2;
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                Reflection.putfield_D(object, jq_InstanceField2, d);
            } else {
                Assert.UNREACHABLE();
            }
        }
    }

    public static java.lang.reflect.Field createNewField(jq_Field jq_Field2) {
        Field field = new Field(jq_Field2);
        return (java.lang.reflect.Field)((Object)field);
    }

    public static void initNewField(Field field, jq_Field jq_Field2) {
        String string;
        if (!jq.RunningNative) {
            return;
        }
        field.name = string = jq_Field2.getName().toString();
        Class clazz = jq_Field2.getDeclaringClass().getJavaLangClassObject();
        boolean bl = false;
        if (clazz != null) {
            bl = true;
        }
        Assert._assert(bl);
        field.clazz = clazz;
        Class clazz2 = Reflection.getJDKType(jq_Field2.getType());
        boolean bl2 = false;
        if (clazz2 != null) {
            bl2 = true;
        }
        Assert._assert(bl2);
        field.type = clazz2;
        char c = jq_Field2.getAccessFlags();
        field.modifiers = c;
    }

    private Field(jq_Field jq_Field2) {
        this.jq_field = jq_Field2;
    }

    private Field(Class clazz, String string, Class clazz2, int n, int n2) {
        this.clazz = clazz;
        this.name = string;
        this.type = clazz2;
        this.modifiers = n;
        this.slot = n2;
        jq_Class jq_Class2 = (jq_Class)Reflection.getJQType(clazz);
        jq_NameAndDesc jq_NameAndDesc2 = new jq_NameAndDesc(Utf8.get(string), Reflection.getJQType(clazz2).getDesc());
        jq_NameAndDesc2 = ClassLibInterface.convertClassLibNameAndDesc(jq_Class2, jq_NameAndDesc2);
        jq_Field jq_Field2 = (jq_Field)jq_Class2.getDeclaredMember(jq_NameAndDesc2);
        if (jq_Field2 == null) {
            jq_Field2 = Modifier.isStatic(n) ? jq_Class2.getOrCreateStaticField(jq_NameAndDesc2) : jq_Class2.getOrCreateInstanceField(jq_NameAndDesc2);
        }
        this.jq_field = jq_Field2;
    }
}

