/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.lang.reflect;

import ClassLib.ClassLibInterface;
import Clazz.jq_Array;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_Type;
import Memory.HeapAddress;
import Run_Time.Arrays;

public abstract class Array {
    public static int getLength(Object object) throws IllegalArgumentException {
        if (!jq_Reference.getTypeOf(object).isArrayType()) {
            throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
        }
        return HeapAddress.addressOf(object).offset(-12).peek4();
    }

    public static Object get(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof int[]) {
            return new Integer(((int[])object)[n]);
        }
        if (object instanceof long[]) {
            return new Long(((long[])object)[n]);
        }
        if (object instanceof float[]) {
            return new Float(((float[])object)[n]);
        }
        if (object instanceof double[]) {
            return new Double(((double[])object)[n]);
        }
        if (object instanceof boolean[]) {
            return new Boolean(((boolean[])object)[n]);
        }
        if (object instanceof byte[]) {
            return new Byte(((byte[])object)[n]);
        }
        if (object instanceof short[]) {
            return new Short(((short[])object)[n]);
        }
        if (object instanceof char[]) {
            return new Character(((char[])object)[n]);
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static boolean getBoolean(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static byte getByte(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static char getChar(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static short getShort(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static int getInt(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static long getLong(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static float getFloat(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof float[]) {
            return ((float[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static double getDouble(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof double[]) {
            return ((double[])object)[n];
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void set(Object object, int n, Object object2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Object[]) {
            ((Object[])object)[n] = object2;
            return;
        }
        if (object instanceof boolean[]) {
            if (!(object2 instanceof Boolean)) {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            boolean bl = (Boolean)object2;
            ((boolean[])object)[n] = bl;
            return;
        }
        if (object instanceof byte[]) {
            if (!(object2 instanceof Byte)) {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            byte by = (Byte)object2;
            ((byte[])object)[n] = by;
            return;
        }
        if (object instanceof short[]) {
            short s;
            if (object2 instanceof Short) {
                s = (Short)object2;
            } else if (object2 instanceof Byte) {
                s = ((Byte)object2).byteValue();
            } else {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            ((short[])object)[n] = s;
            return;
        }
        if (object instanceof char[]) {
            char c;
            if (object2 instanceof Character) {
                c = ((Character)object2).charValue();
            } else if (object2 instanceof Byte) {
                c = (char)((Byte)object2).byteValue();
            } else {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            ((char[])object)[n] = c;
            return;
        }
        if (object instanceof int[]) {
            int n2;
            if (object2 instanceof Integer) {
                n2 = (Integer)object2;
            } else if (object2 instanceof Character) {
                n2 = ((Character)object2).charValue();
            } else if (object2 instanceof Short) {
                n2 = ((Short)object2).shortValue();
            } else if (object2 instanceof Byte) {
                n2 = ((Byte)object2).byteValue();
            } else {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            ((int[])object)[n] = n2;
            return;
        }
        if (object instanceof long[]) {
            if (!(object2 instanceof Long)) {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            long l = (Long)object2;
            ((long[])object)[n] = l;
            return;
        }
        if (object instanceof float[]) {
            if (!(object2 instanceof Float)) {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            float f = ((Float)object2).floatValue();
            ((float[])object)[n] = f;
            return;
        }
        if (object instanceof double[]) {
            if (!(object2 instanceof Double)) {
                throw new IllegalArgumentException("cannot store value of type " + jq_Reference.getTypeOf(object2) + " into array of type " + jq_Reference.getTypeOf(object));
            }
            double d = (Double)object2;
            ((double[])object)[n] = d;
            return;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setBoolean(Object object, int n, boolean bl) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof boolean[]) {
            ((boolean[])object)[n] = bl;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setByte(Object object, int n, byte by) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof byte[]) {
            ((byte[])object)[n] = by;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setChar(Object object, int n, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof char[]) {
            ((char[])object)[n] = c;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setShort(Object object, int n, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof short[]) {
            ((short[])object)[n] = s;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setInt(Object object, int n, int n2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof int[]) {
            ((int[])object)[n] = n2;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setLong(Object object, int n, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof long[]) {
            ((long[])object)[n] = l;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setFloat(Object object, int n, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = f;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    public static void setDouble(Object object, int n, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = d;
        }
        throw new IllegalArgumentException(jq_Reference.getTypeOf(object).toString());
    }

    private static final Object newArray(Class clazz, int n) throws NegativeArraySizeException {
        jq_Type jq_Type2 = ClassLibInterface.DEFAULT.getJQType(clazz);
        if (jq_Type2 == jq_Primitive.VOID) {
            throw new IllegalArgumentException("cannot create a void array");
        }
        jq_Array jq_Array2 = jq_Type2.getArrayTypeForElementType();
        jq_Array2.cls_initialize();
        return jq_Array2.newInstance(n);
    }

    private static final Object multiNewArray(Class clazz, int[] nArray) throws IllegalArgumentException, NegativeArraySizeException {
        jq_Type jq_Type2 = ClassLibInterface.DEFAULT.getJQType(clazz);
        if (jq_Type2 == jq_Primitive.VOID) {
            throw new IllegalArgumentException("cannot create a void array");
        }
        if (nArray.length == 0) {
            throw new IllegalArgumentException("dimensions array is zero");
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                throw new NegativeArraySizeException("dim " + n + ": " + nArray[n] + " < 0");
            }
            jq_Type2 = jq_Type2.getArrayTypeForElementType();
            jq_Type2.cls_initialize();
            ++n;
        }
        return Arrays.multinewarray_helper(nArray, 0, (jq_Array)jq_Type2);
    }
}

