/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.io;

import ClassLib.Common.java.io.FileDescriptor;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import Util.Assert;
import java.io.FileNotFoundException;
import java.io.IOException;

public abstract class RandomAccessFile {
    private FileDescriptor fd;

    public void open(String string, boolean bl) throws FileNotFoundException {
        int n = bl ? 33026 : 32768;
        int n2 = SystemInterface.file_open(string, n, 0);
        if (n2 == -1) {
            throw new FileNotFoundException(string);
        }
        this.fd.fd = n2;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.readBytes(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        if (n != 1) {
            throw new IOException();
        }
        return byArray[0] & 0xFF;
    }

    private final int readBytes(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2, this.fd);
    }

    private final int readBytes(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        int n3 = fileDescriptor.fd;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte by = byArray[n + n2 - 1];
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(byArray).offset(n);
        int n4 = SystemInterface.file_readbytes(n3, heapAddress, n2);
        if (n4 == 0) {
            return -1;
        }
        if (n4 == -1) {
            throw new IOException();
        }
        return n4;
    }

    public void write(int n) throws IOException {
        int n2 = this.fd.fd;
        int n3 = SystemInterface.file_writebyte(n2, n);
        if (n3 != 1) {
            throw new IOException();
        }
    }

    private final void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2, this.fd);
    }

    private final void writeBytes(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        int n3 = fileDescriptor.fd;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte by = byArray[n + n2 - 1];
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(byArray).offset(n);
        int n4 = SystemInterface.file_writebytes(n3, heapAddress, n2);
        if (n4 != n2) {
            throw new IOException();
        }
    }

    public long getFilePointer() throws IOException {
        int n = this.fd.fd;
        long l = SystemInterface.file_seek(n, 0L, 1);
        if (l == (long)-1) {
            throw new IOException();
        }
        return l;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException(l + " < 0");
        }
        int n = this.fd.fd;
        long l2 = SystemInterface.file_seek(n, l, 0);
        if (l2 == (long)-1) {
            throw new IOException();
        }
    }

    public long length() throws IOException {
        int n = this.fd.fd;
        long l = SystemInterface.file_seek(n, 0L, 1);
        if (l == (long)-1) {
            throw new IOException();
        }
        long l2 = SystemInterface.file_seek(n, 0L, 2);
        if (l2 == (long)-1) {
            throw new IOException();
        }
        long l3 = SystemInterface.file_seek(n, l, 0);
        if (l3 == (long)-1) {
            throw new IOException();
        }
        return l2;
    }

    public void setLength(long l) throws IOException {
        Assert.TODO();
    }

    public void close() throws IOException {
        int n = this.fd.fd;
        int n2 = SystemInterface.file_close(n);
    }

    private static final void initIDs() {
    }
}

