/*
 * Decompiled with CFR 0.152.
 */
package ClassLib.Common.java.io;

import ClassLib.Common.java.io.FileDescriptor;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import java.io.FileNotFoundException;
import java.io.IOException;

abstract class FileInputStream {
    private FileDescriptor fd;

    private final void open(String string) throws FileNotFoundException {
        int n = SystemInterface.file_open(string, 32768, 0);
        if (n == -1) {
            throw new FileNotFoundException(string);
        }
        this.fd.fd = n;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.readBytes(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        if (n != 1) {
            throw new IOException();
        }
        return byArray[0] & 0xFF;
    }

    private final int readBytes(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2, this.fd);
    }

    private final int readBytes(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        int n3 = fileDescriptor.fd;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte by = byArray[n + n2 - 1];
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(byArray).offset(n);
        int n4 = SystemInterface.file_readbytes(n3, heapAddress, n2);
        if (n4 == 0) {
            return -1;
        }
        if (n4 == -1) {
            throw new IOException();
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        int n = this.fd.fd;
        long l2 = SystemInterface.file_seek(n, 0L, 1);
        long l3 = SystemInterface.file_seek(n, l, 1);
        if (l3 == (long)-1) {
            throw new IOException();
        }
        return l3 - l2;
    }

    public int available() throws IOException {
        int n = this.fd.fd;
        if (n == 0) {
            int n2 = SystemInterface.console_available();
            if (n2 == -1) {
                throw new IOException();
            }
            return n2;
        }
        long l = SystemInterface.file_seek(n, 0L, 1);
        if (l == (long)-1) {
            throw new IOException();
        }
        long l2 = SystemInterface.file_seek(n, 0L, 2);
        if (l2 == (long)-1) {
            throw new IOException();
        }
        long l3 = SystemInterface.file_seek(n, l, 0);
        if (l3 == (long)-1) {
            throw new IOException();
        }
        if (l2 - l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(l2 - l);
    }

    public void close() throws IOException {
        int n = this.fd.fd;
        int n2 = SystemInterface.file_close(n);
    }

    private static final void initIDs() {
    }

    FileInputStream() {
    }
}

