/*
 * Decompiled with CFR 0.152.
 */
package Bootstrap;

import ClassLib.ClassLibInterface;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_Member;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Main.jq;
import UTF.Utf8;
import Util.Assert;
import Util.Collections.AppendIterator;
import Util.Collections.FilterIterator;
import Util.Collections.UnmodifiableIterator;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PrimordialClassLoader
extends ClassLoader
implements jq_ClassFileConstants {
    public static boolean TRACE = false;
    public static final PrintStream out = System.out;
    public static final String pathsep = System.getProperty("path.separator");
    public static final String filesep = System.getProperty("file.separator");
    public static final PrimordialClassLoader loader = new PrimordialClassLoader();
    public static final jq_Class JavaLangObject;
    public static final jq_Class JavaLangClass;
    public static final jq_Class JavaLangString;
    public static final jq_Class JavaLangSystem;
    public static final jq_Class JavaLangThrowable;
    private final List classpathList;
    private final Map bs_desc2type = new HashMap();

    public void addToClasspath(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.classpathList);
        Iterator iterator = PrimordialClassLoader.classpaths(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            if (string2.toLowerCase().endsWith(".zip") || string2.toLowerCase().endsWith(".jar")) {
                try {
                    if (TRACE) {
                        out.println("Adding zip file " + string2 + " to classpath");
                    }
                    this.classpathList.add(new ZipFileElement(new ZipFile(string2)));
                }
                catch (IOException iOException) {}
                continue;
            }
            if (TRACE) {
                out.println("Adding path " + string2 + " to classpath");
            }
            this.classpathList.add(new PathElement(string2));
        }
        ((ArrayList)this.classpathList).trimToSize();
    }

    public static final Iterator classpaths(String string) {
        if (!string.startsWith(pathsep)) {
            string = pathsep + string;
        }
        if (!string.endsWith(pathsep)) {
            string = string + pathsep;
        }
        String string2 = string;
        return new UnmodifiableIterator(string2){
            int i;
            final /* synthetic */ String val$cp;

            public final boolean hasNext() {
                boolean bl = false;
                if (this.val$cp.length() > this.i + pathsep.length()) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                this.i += pathsep.length();
                String string = this.val$cp.substring(this.i, this.val$cp.indexOf(pathsep, this.i));
                this.i += string.length();
                return string;
            }

            private final /* synthetic */ void this() {
                this.i = 0;
            }
            {
                this.val$cp = string;
                this.this();
            }
        };
    }

    public Iterator listPackage(String string) {
        return this.listPackage(string, false);
    }

    public Iterator listPackage(String string, boolean bl) {
        Iterator iterator = null;
        Iterator iterator2 = this.classpathList.iterator();
        while (iterator2.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator2.next();
            Iterator iterator3 = classpathElement.listPackage(string, bl);
            if (!iterator3.hasNext()) continue;
            Iterator iterator4 = iterator = iterator == null ? iterator3 : new AppendIterator(iterator3, iterator);
        }
        if (iterator == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return iterator;
    }

    public Iterator listPackages() {
        Iterator iterator = null;
        Iterator iterator2 = this.classpathList.iterator();
        while (iterator2.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator2.next();
            Iterator iterator3 = classpathElement.listPackages();
            if (!iterator3.hasNext()) continue;
            Iterator iterator4 = iterator = iterator == null ? iterator3 : new AppendIterator(iterator3, iterator);
        }
        if (iterator == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return iterator;
    }

    public String classpathToString() {
        StringBuffer stringBuffer = new StringBuffer(pathsep);
        Iterator iterator = this.classpathList.iterator();
        while (iterator.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator.next();
            stringBuffer.append(classpathElement.toString());
            stringBuffer.append(pathsep);
        }
        return stringBuffer.toString();
    }

    public static String descriptorToResource(String string) {
        boolean bl = false;
        if (string.charAt(0) == 'L') {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (string.charAt(string.length() - 1) == ';') {
            bl2 = true;
        }
        Assert._assert(bl2);
        boolean bl3 = false;
        if (string.indexOf(46) == -1) {
            bl3 = true;
        }
        Assert._assert(bl3);
        return string.substring(1, string.length() - 1) + ".class";
    }

    public static String classnameToResource(String string) {
        boolean bl = false;
        if (string.indexOf(47) == -1) {
            bl = true;
        }
        Assert._assert(bl);
        return string.replace('.', filesep.charAt(0)) + ".class";
    }

    public String getResourcePath(String string) {
        Iterator iterator = this.classpathList.iterator();
        while (iterator.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator.next();
            if (!classpathElement.containsResource(string)) continue;
            return classpathElement.toString();
        }
        return null;
    }

    public String getPackagePath(String string) {
        Iterator iterator = this.classpathList.iterator();
        while (iterator.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator.next();
            Iterator iterator2 = classpathElement.listPackages();
            while (iterator2.hasNext()) {
                if (!string.equals(iterator2.next())) continue;
                return classpathElement.toString();
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        Iterator iterator = this.classpathList.iterator();
        while (iterator.hasNext()) {
            ClasspathElement classpathElement = (ClasspathElement)iterator.next();
            InputStream inputStream = classpathElement.getResourceAsStream(string);
            if (inputStream == null) continue;
            return inputStream;
        }
        return null;
    }

    private static final void initPrimitiveTypes() {
        loader.getOrCreateBSType(jq_Primitive.BYTE.getDesc());
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.BYTE_ARRAY.getDesc(), jq_Array.BYTE_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.CHAR_ARRAY.getDesc(), jq_Array.CHAR_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.DOUBLE_ARRAY.getDesc(), jq_Array.DOUBLE_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.FLOAT_ARRAY.getDesc(), jq_Array.FLOAT_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.INT_ARRAY.getDesc(), jq_Array.INT_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.LONG_ARRAY.getDesc(), jq_Array.LONG_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.SHORT_ARRAY.getDesc(), jq_Array.SHORT_ARRAY);
        PrimordialClassLoader.loader.bs_desc2type.put(jq_Array.BOOLEAN_ARRAY.getDesc(), jq_Array.BOOLEAN_ARRAY);
    }

    public DataInputStream getClassFileStream(Utf8 utf8) throws IOException {
        String string = PrimordialClassLoader.descriptorToResource(utf8.toString());
        InputStream inputStream = this.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        return new DataInputStream(inputStream);
    }

    public static jq_Class getJavaLangObject() {
        return JavaLangObject;
    }

    public static jq_Class getJavaLangClass() {
        return JavaLangClass;
    }

    public static jq_Class getJavaLangString() {
        return JavaLangString;
    }

    public static jq_Class getJavaLangSystem() {
        return JavaLangSystem;
    }

    public static jq_Class getJavaLangThrowable() {
        return JavaLangThrowable;
    }

    public static jq_Class getJavaLangException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/Exception;");
    }

    public static jq_Class getJavaLangError() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/Error;");
    }

    public static jq_Class getJavaLangRuntimeException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/RuntimeException;");
    }

    public static jq_Class getJavaLangNullPointerException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/NullPointerException;");
    }

    public static jq_Class getJavaLangIndexOutOfBoundsException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/IndexOutOfBoundsException;");
    }

    public static jq_Class getJavaLangArrayIndexOutOfBoundsException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ArrayIndexOutOfBoundsException;");
    }

    public static jq_Class getJavaLangArrayStoreException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ArrayStoreException;");
    }

    public static jq_Class getJavaLangNegativeArraySizeException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/NegativeArraySizeException;");
    }

    public static jq_Class getJavaLangArithmeticException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ArithmeticException;");
    }

    public static jq_Class getJavaLangIllegalMonitorStateException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/IllegalMonitorStateException;");
    }

    public static jq_Class getJavaLangClassCastException() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ClassCastException;");
    }

    public static jq_Class getJavaLangClassLoader() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ClassLoader;");
    }

    public static jq_Class getJavaLangReflectField() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/reflect/Field;");
    }

    public static jq_Class getJavaLangReflectMethod() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/reflect/Method;");
    }

    public static jq_Class getJavaLangReflectConstructor() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/reflect/Constructor;");
    }

    public static jq_Class getJavaLangThread() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/Thread;");
    }

    public static jq_Class getJavaLangRefFinalizer() {
        return (jq_Class)loader.getOrCreateBSType("Ljava/lang/ref/Finalizer;");
    }

    public Collection getAllTypes() {
        return this.bs_desc2type.values();
    }

    public final Set getClassesThatReference(jq_Member jq_Member2) {
        Iterator iterator = this.bs_desc2type.entrySet().iterator();
        HashSet<jq_Class> hashSet = new HashSet<jq_Class>();
        while (iterator.hasNext()) {
            jq_Class jq_Class2;
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof jq_Class) || !(jq_Class2 = (jq_Class)entry.getValue()).doesConstantPoolContain(jq_Member2)) continue;
            hashSet.add(jq_Class2);
        }
        return hashSet;
    }

    public final jq_Class getOrCreateClass(String string, DataInput dataInput) {
        jq_Class jq_Class2 = (jq_Class)this.getOrCreateBSType(Utf8.get(string));
        jq_Class2.load(dataInput);
        return jq_Class2;
    }

    public final jq_Type getBSType(String string) {
        return this.getBSType(Utf8.get(string));
    }

    public final jq_Type getBSType(Utf8 utf8) {
        return (jq_Type)this.bs_desc2type.get(utf8);
    }

    public final jq_Type getOrCreateBSType(String string) {
        return this.getOrCreateBSType(Utf8.get(string));
    }

    public final jq_Type getOrCreateBSType(Utf8 utf8) {
        if (jq.RunningNative) {
            return ClassLibInterface.DEFAULT.getOrCreateType(this, utf8);
        }
        jq_Type jq_Type2 = (jq_Type)this.bs_desc2type.get(utf8);
        if (jq_Type2 == null) {
            Object object;
            if (utf8.isDescriptor((byte)76)) {
                if (TRACE) {
                    out.println("Adding class type " + utf8);
                }
                jq_Type2 = jq_Class.newClass(this, utf8);
            } else if (utf8.isDescriptor((byte)91)) {
                if (TRACE) {
                    out.println("Adding array type " + utf8);
                }
                object = utf8.getArrayElementDescriptor();
                jq_Type jq_Type3 = this.getOrCreateBSType((Utf8)object);
                jq_Type2 = jq_Array.newArray(utf8, this, jq_Type3);
            } else if (utf8 == Utf8.BYTE_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "byte", 1);
            } else if (utf8 == Utf8.CHAR_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "char", 2);
            } else if (utf8 == Utf8.DOUBLE_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "double", 8);
            } else if (utf8 == Utf8.FLOAT_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "float", 4);
            } else if (utf8 == Utf8.INT_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "int", 4);
            } else if (utf8 == Utf8.LONG_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "long", 8);
            } else if (utf8 == Utf8.SHORT_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "short", 2);
            } else if (utf8 == Utf8.BOOLEAN_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "boolean", 1);
            } else if (utf8 == Utf8.VOID_DESC) {
                jq_Type2 = jq_Primitive.newPrimitive(utf8, "void", 0);
            } else {
                Assert.UNREACHABLE("bad descriptor! " + utf8);
            }
            object = this.bs_desc2type.put(utf8, jq_Type2);
            boolean bl = false;
            if (object == null) {
                bl = true;
            }
            Assert._assert(bl);
        }
        return jq_Type2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void replaceClass(String string) {
        Utf8 utf8 = Utf8.get("L" + string.replace('.', '/') + ';');
        jq_Type jq_Type2 = PrimordialClassLoader.getOrCreateType(this, utf8);
        boolean bl = false;
        if (jq_Type2 != null) {
            bl = true;
        }
        Assert._assert(bl);
        Assert._assert(utf8.isDescriptor((byte)76));
        Utf8 utf82 = Utf8.get("LREPLACE" + string.replace('.', '/') + ';');
        jq_Class jq_Class2 = jq_Class.newClass(this, utf82);
        this.bs_desc2type.put(utf82, jq_Class2);
        DataInputStream dataInputStream = null;
        try {
            try {
                dataInputStream = this.getClassFileStream(utf8);
                if (dataInputStream == null) {
                    throw new NoClassDefFoundError(jq_Class.className(utf8));
                }
                jq_Class2.load(dataInputStream);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ClassFormatError(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (dataInputStream == null) throw throwable;
                dataInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (dataInputStream == null) return;
        dataInputStream.close();
    }

    public void unloadBSType(jq_Type jq_Type2) {
        this.bs_desc2type.remove(jq_Type2.getDesc());
    }

    public static final jq_Type getOrCreateType(ClassLoader classLoader, Utf8 utf8) {
        if (jq.RunningNative) {
            return ClassLibInterface.DEFAULT.getOrCreateType(classLoader, utf8);
        }
        boolean bl = false;
        if (classLoader == loader) {
            bl = true;
        }
        Assert._assert(bl);
        return loader.getOrCreateBSType(utf8);
    }

    public static final void unloadType(ClassLoader classLoader, jq_Type jq_Type2) {
        if (jq.RunningNative) {
            ClassLibInterface.DEFAULT.unloadType(classLoader, jq_Type2);
            return;
        }
        boolean bl = false;
        if (classLoader == loader) {
            bl = true;
        }
        Assert._assert(bl);
        loader.unloadBSType(jq_Type2);
    }

    private PrimordialClassLoader() {
        this.classpathList = new ArrayList();
    }

    static {
        PrimordialClassLoader.initPrimitiveTypes();
        JavaLangObject = (jq_Class)loader.getOrCreateBSType("Ljava/lang/Object;");
        JavaLangClass = (jq_Class)loader.getOrCreateBSType("Ljava/lang/Class;");
        JavaLangString = (jq_Class)loader.getOrCreateBSType("Ljava/lang/String;");
        JavaLangSystem = (jq_Class)loader.getOrCreateBSType("Ljava/lang/System;");
        JavaLangThrowable = (jq_Class)loader.getOrCreateBSType("Ljava/lang/Throwable;");
    }

    static abstract class ClasspathElement {
        abstract InputStream getResourceAsStream(String var1);

        abstract boolean containsResource(String var1);

        Iterator listPackage(String string) {
            return this.listPackage(string, false);
        }

        abstract Iterator listPackage(String var1, boolean var2);

        abstract Iterator listPackages();

        ClasspathElement() {
        }
    }

    static class ZipFileElement
    extends ClasspathElement {
        ZipFile zf;
        Map entries;

        void initializeEntryMap() {
            int n = this.zf.size();
            this.entries = new HashMap(n + (n >> 1));
            if (n > 0) {
                Enumeration<? extends ZipEntry> enumeration = this.zf.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    this.entries.put(zipEntry.getName(), zipEntry);
                }
            }
            if (TRACE) {
                out.println(this + " contains: " + this.entries.keySet());
            }
        }

        public String toString() {
            return this.zf.getName();
        }

        InputStream getResourceAsStream(String string) {
            if (TRACE) {
                out.println("Getting resource for " + string + " in zip file " + this.zf.getName());
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            ZipEntry zipEntry = (ZipEntry)this.entries.get(string);
            try {
                return zipEntry == null ? null : this.zf.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        boolean containsResource(String string) {
            if (TRACE) {
                out.println("Searching for " + string + " in zip file " + this.zf.getName());
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            return this.entries.containsKey(string);
        }

        Iterator listPackage(String string, boolean bl) {
            if (TRACE) {
                out.println("Listing package " + string + " of zip file " + this.zf.getName());
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            return new FilterIterator(this.entries.values().iterator(), new FilterIterator.Filter(this, string, bl){
                final /* synthetic */ ZipFileElement this$0;
                final /* synthetic */ String val$pathname;
                final /* synthetic */ boolean val$recursive;

                public final boolean isElement(Object object) {
                    ZipEntry zipEntry = (ZipEntry)object;
                    String string = zipEntry.getName();
                    if (TRACE) {
                        out.println("Checking if zipentry " + string + " is in package " + this.val$pathname);
                    }
                    boolean bl = false;
                    if (!zipEntry.isDirectory() && string.startsWith(this.val$pathname) && string.endsWith(".class") && (this.val$recursive || string.lastIndexOf("/") == this.val$pathname.length() - 1)) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object map(Object object) {
                    return ((ZipEntry)object).getName();
                }
                {
                    this.this$0 = zipFileElement;
                    this.val$pathname = string;
                    this.val$recursive = bl;
                }
            });
        }

        Iterator listPackages() {
            if (TRACE) {
                out.println("Listing packages of zip file " + this.zf.getName());
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            Iterator iterator = this.entries.values().iterator();
            while (iterator.hasNext()) {
                String string;
                ZipEntry zipEntry = (ZipEntry)iterator.next();
                if (zipEntry.isDirectory() || !(string = zipEntry.getName()).endsWith(".class")) continue;
                int n = string.lastIndexOf(47);
                linkedHashSet.add(string.substring(0, n + 1));
            }
            if (TRACE) {
                out.println("Result: " + linkedHashSet);
            }
            return linkedHashSet.iterator();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                if (this.zf != null) {
                    this.zf.close();
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            {
                Object var2_3 = null;
            }
            super.finalize();
        }

        ZipFileElement(ZipFile zipFile) {
            this.zf = zipFile;
        }
    }

    static class PathElement
    extends ClasspathElement {
        String path;
        Set entries;

        void initializeEntryMap() {
            this.entries = new HashSet();
            this.buildEntries(null);
            if (TRACE) {
                out.println(this + " contains: " + this.entries);
            }
        }

        public String toString() {
            return this.path;
        }

        InputStream getResourceAsStream(String string) {
            if (TRACE) {
                out.println("Getting resource for " + string + " in path " + this.path);
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            if (!this.entries.contains(string)) {
                return null;
            }
            if (filesep.charAt(0) != '/') {
                string = string.replace('/', filesep.charAt(0));
            }
            try {
                File file = new File(this.path, string);
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }

        boolean containsResource(String string) {
            if (TRACE) {
                out.println("Searching for " + string + " in path " + this.path);
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            return this.entries.contains(string);
        }

        Iterator listPackage(String string, boolean bl) {
            if (TRACE) {
                out.println("Listing package " + string + " in path " + this.path);
            }
            if (this.entries == null) {
                this.initializeEntryMap();
            }
            return new FilterIterator(this.entries.iterator(), new FilterIterator.Filter(this, string, bl){
                final /* synthetic */ PathElement this$0;
                final /* synthetic */ String val$pathn;
                final /* synthetic */ boolean val$recursive;

                public final boolean isElement(Object object) {
                    String string = (String)object;
                    if (TRACE) {
                        out.println("Checking if file " + string + " is in package " + this.val$pathn);
                    }
                    boolean bl = false;
                    if (string.startsWith(this.val$pathn) && string.endsWith(".class") && (this.val$recursive || string.lastIndexOf("/") == this.val$pathn.length() - 1)) {
                        bl = true;
                    }
                    return bl;
                }
                {
                    this.this$0 = pathElement;
                    this.val$pathn = string;
                    this.val$recursive = bl;
                }
            });
        }

        Iterator listPackages() {
            if (TRACE) {
                out.println("Listing packages of path " + this.path);
            }
            HashSet hashSet = new HashSet();
            this.listPackages(null, hashSet);
            return hashSet.iterator();
        }

        private final void listPackages(String string, HashSet hashSet) {
            File file;
            File file2 = file = string == null ? new File(this.path) : new File(this.path, string);
            if (!file.exists() || !file.isDirectory()) {
                return;
            }
            String[] stringArray = file.list(new FilenameFilter(this, string, hashSet){
                final /* synthetic */ PathElement this$0;
                final /* synthetic */ String val$dir;
                final /* synthetic */ HashSet val$pkgs;

                public final boolean accept(File file, String string) {
                    if (this.val$dir != null && string.endsWith(".class")) {
                        this.val$pkgs.add(this.val$dir);
                    }
                    return new File(file, string).isDirectory();
                }
                {
                    this.this$0 = pathElement;
                    this.val$dir = string;
                    this.val$pkgs = hashSet;
                }
            });
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string != null) {
                    string2 = string + filesep + string2;
                }
                this.listPackages(string2, hashSet);
                ++n;
            }
        }

        private final void buildEntries(String string) {
            String[] stringArray;
            File file = string == null ? new File(this.path) : (filesep.charAt(0) == '/' ? new File(this.path, string) : new File(this.path, string.replace('/', filesep.charAt(0))));
            if (!file.exists() || !file.isDirectory()) {
                return;
            }
            String[] stringArray2 = file.list(new FilenameFilter(this){
                final /* synthetic */ PathElement this$0;

                public final boolean accept(File file, String string) {
                    return new File(file, string).isDirectory() ^ true;
                }
                {
                    this.this$0 = pathElement;
                }
            });
            if (stringArray2 != null) {
                int n = 0;
                while (n < stringArray2.length) {
                    String string2 = string == null ? stringArray2[n] : string + stringArray2[n];
                    this.entries.add(string2);
                    ++n;
                }
            }
            if ((stringArray = file.list(new FilenameFilter(this){
                final /* synthetic */ PathElement this$0;

                public final boolean accept(File file, String string) {
                    return new File(file, string).isDirectory();
                }
                {
                    this.this$0 = pathElement;
                }
            })) != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string3 = stringArray[n];
                    if (string != null) {
                        string3 = string + string3;
                    }
                    this.buildEntries(string3 + '/');
                    ++n;
                }
            }
        }

        PathElement(String string) {
            this.path = string;
        }
    }
}

