/*
 * Decompiled with CFR 0.152.
 */
package Bootstrap;

import Allocator.SimpleAllocator;
import Assembler.x86.Heap2HeapReference;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassInitializer;
import Clazz.jq_Field;
import Clazz.jq_FieldVisitor;
import Clazz.jq_Initializer;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_MethodVisitor;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Clazz.jq_TypeVisitor;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.ExceptionDeliverer;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_InterrupterThread;
import Scheduler.jq_NativeThread;
import Util.Assert;
import Util.Collections.IdentityHashCodeWrapper;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public class BootstrapRootSet {
    public static boolean TRACE = false;
    public static final PrintStream out = System.out;
    protected final Set instantiatedTypes = new HashSet();
    protected final Set necessaryTypes = new HashSet();
    protected final Set necessaryFields = new HashSet();
    protected final Set necessaryMethods = new HashSet();
    protected final LinkedHashSet visitedObjects = new LinkedHashSet();
    protected List instantiatedTypesListeners;
    protected List necessaryTypesListeners;
    protected List necessaryFieldsListeners;
    protected List necessaryMethodsListeners;
    public boolean AddAllFields;

    public Set getInstantiatedTypes() {
        return this.instantiatedTypes;
    }

    public Set getNecessaryTypes() {
        return this.necessaryTypes;
    }

    public Set getNecessaryFields() {
        return this.necessaryFields;
    }

    public Set getNecessaryMethods() {
        return this.necessaryMethods;
    }

    public void registerInstantiatedTypeListener(jq_TypeVisitor jq_TypeVisitor2) {
        if (this.instantiatedTypesListeners == null) {
            this.instantiatedTypesListeners = new LinkedList();
        }
        this.instantiatedTypesListeners.add(jq_TypeVisitor2);
    }

    public void unregisterInstantiatedTypeListener(jq_TypeVisitor jq_TypeVisitor2) {
        this.instantiatedTypesListeners.remove(jq_TypeVisitor2);
    }

    public void registerNecessaryTypeListener(jq_TypeVisitor jq_TypeVisitor2) {
        if (this.necessaryTypesListeners == null) {
            this.necessaryTypesListeners = new LinkedList();
        }
        this.necessaryTypesListeners.add(jq_TypeVisitor2);
    }

    public void unregisterNecessaryTypeListener(jq_TypeVisitor jq_TypeVisitor2) {
        this.necessaryTypesListeners.remove(jq_TypeVisitor2);
    }

    public void registerNecessaryFieldListener(jq_FieldVisitor jq_FieldVisitor2) {
        if (this.necessaryFieldsListeners == null) {
            this.necessaryFieldsListeners = new LinkedList();
        }
        this.necessaryFieldsListeners.add(jq_FieldVisitor2);
    }

    public void unregisterNecessaryFieldListener(jq_FieldVisitor jq_FieldVisitor2) {
        this.necessaryFieldsListeners.remove(jq_FieldVisitor2);
    }

    public void registerNecessaryMethodListener(jq_MethodVisitor jq_MethodVisitor2) {
        if (this.necessaryMethodsListeners == null) {
            this.necessaryMethodsListeners = new LinkedList();
        }
        this.necessaryMethodsListeners.add(jq_MethodVisitor2);
    }

    public void unregisterNecessaryMethodListener(jq_MethodVisitor jq_MethodVisitor2) {
        this.necessaryMethodsListeners.remove(jq_MethodVisitor2);
    }

    public boolean addInstantiatedType(jq_Type jq_Type2) {
        boolean bl = false;
        if (jq_Type2 != null) {
            bl = true;
        }
        Assert._assert(bl);
        this.addNecessaryType(jq_Type2);
        boolean bl2 = this.instantiatedTypes.add(jq_Type2);
        if (bl2) {
            if (TRACE) {
                out.println("New instantiated type: " + jq_Type2);
            }
            if (this.instantiatedTypesListeners != null) {
                Iterator iterator = this.instantiatedTypesListeners.iterator();
                while (iterator.hasNext()) {
                    jq_TypeVisitor jq_TypeVisitor2 = (jq_TypeVisitor)iterator.next();
                    jq_Type2.accept(jq_TypeVisitor2);
                }
            }
        }
        return bl2;
    }

    public jq_Type addNecessaryType(String string) {
        String string2 = string.substring(1, string.length() - 1).replace('/', '.');
        try {
            Class.forName(string2);
            jq_Type jq_Type2 = null;
            try {
                jq_Type2 = PrimordialClassLoader.loader.getOrCreateBSType(string);
                jq_Type2.load();
                this.addNecessaryType(jq_Type2);
                return jq_Type2;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println("Note: Cannot load class " + jq_Type2 + " present in host Jvm");
                PrimordialClassLoader.unloadType(PrimordialClassLoader.loader, jq_Type2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public boolean addNecessaryType(jq_Type jq_Type2) {
        if (jq_Type2 == null) {
            return false;
        }
        jq_Type2.prepare();
        boolean bl = this.necessaryTypes.add(jq_Type2);
        if (bl) {
            jq_StaticField[] jq_StaticFieldArray;
            Object object;
            if (TRACE) {
                out.println("New necessary type: " + jq_Type2);
            }
            if (this.necessaryTypesListeners != null) {
                object = this.necessaryTypesListeners.iterator();
                while (object.hasNext()) {
                    jq_StaticFieldArray = (jq_StaticField[])object.next();
                    jq_Type2.accept((jq_TypeVisitor)jq_StaticFieldArray);
                }
            }
            if (jq_Type2 instanceof jq_Class) {
                object = (jq_Class)jq_Type2;
                if (this.AddAllFields) {
                    jq_StaticFieldArray = ((jq_Class)object).getDeclaredStaticFields();
                    int n = 0;
                    while (n < jq_StaticFieldArray.length) {
                        this.addNecessaryField(jq_StaticFieldArray[n]);
                        ++n;
                    }
                }
                this.addNecessaryType(((jq_Class)object).getSuperclass());
            }
        }
        return bl;
    }

    public jq_StaticField addNecessaryStaticField(jq_Class jq_Class2, String string, String string2) {
        if (jq_Class2 == null) {
            return null;
        }
        jq_StaticField jq_StaticField2 = jq_Class2.getOrCreateStaticField(string, string2);
        this.addNecessaryField(jq_StaticField2);
        return jq_StaticField2;
    }

    public jq_InstanceField addNecessaryInstanceField(jq_Class jq_Class2, String string, String string2) {
        if (jq_Class2 == null) {
            return null;
        }
        jq_InstanceField jq_InstanceField2 = jq_Class2.getOrCreateInstanceField(string, string2);
        this.addNecessaryField(jq_InstanceField2);
        return jq_InstanceField2;
    }

    public boolean addNecessaryField(jq_Field jq_Field2) {
        this.addNecessaryType(jq_Field2.getDeclaringClass());
        boolean bl = this.necessaryFields.add(jq_Field2);
        if (bl) {
            if (TRACE) {
                out.println("New necessary field: " + jq_Field2);
            }
            if (this.necessaryFieldsListeners != null) {
                Iterator iterator = this.necessaryFieldsListeners.iterator();
                while (iterator.hasNext()) {
                    jq_FieldVisitor jq_FieldVisitor2 = (jq_FieldVisitor)iterator.next();
                    jq_Field2.accept(jq_FieldVisitor2);
                }
            }
        }
        return bl;
    }

    public jq_StaticMethod addNecessaryStaticMethod(jq_Class jq_Class2, String string, String string2) {
        if (jq_Class2 == null) {
            return null;
        }
        jq_StaticMethod jq_StaticMethod2 = jq_Class2.getOrCreateStaticMethod(string, string2);
        this.addNecessaryMethod(jq_StaticMethod2);
        return jq_StaticMethod2;
    }

    public jq_InstanceMethod addNecessaryInstanceMethod(jq_Class jq_Class2, String string, String string2) {
        if (jq_Class2 == null) {
            return null;
        }
        jq_InstanceMethod jq_InstanceMethod2 = jq_Class2.getOrCreateInstanceMethod(string, string2);
        this.addNecessaryMethod(jq_InstanceMethod2);
        return jq_InstanceMethod2;
    }

    public boolean addNecessaryMethod(jq_Method jq_Method2) {
        this.addNecessaryType(jq_Method2.getDeclaringClass());
        boolean bl = this.necessaryMethods.add(jq_Method2);
        if (bl) {
            if (TRACE) {
                out.println("New necessary method: " + jq_Method2);
            }
            if (this.necessaryMethodsListeners != null) {
                Iterator iterator = this.necessaryMethodsListeners.iterator();
                while (iterator.hasNext()) {
                    jq_MethodVisitor jq_MethodVisitor2 = (jq_MethodVisitor)iterator.next();
                    jq_Method2.accept(jq_MethodVisitor2);
                }
            }
        }
        return bl;
    }

    public void addDefaultRoots() {
        this.addNecessaryType(jq_Class._class);
        this.addNecessaryType(jq_Primitive._class);
        this.addNecessaryType(jq_Array._class);
        this.addNecessaryType(jq_InstanceField._class);
        this.addNecessaryType(jq_StaticField._class);
        this.addNecessaryType(jq_InstanceMethod._class);
        this.addNecessaryType(jq_StaticMethod._class);
        this.addNecessaryType(jq_Initializer._class);
        this.addNecessaryType(jq_ClassInitializer._class);
        this.addNecessaryType(CodeAddress._class);
        this.addNecessaryType(HeapAddress._class);
        this.addNecessaryType(StackAddress._class);
        this.addNecessaryField(jq_Reference._vtable);
        SystemInterface._class.load();
        jq_StaticField[] jq_StaticFieldArray = SystemInterface._class.getDeclaredStaticFields();
        int n = 0;
        while (n < jq_StaticFieldArray.length) {
            this.addNecessaryField(jq_StaticFieldArray[n]);
            ++n;
        }
        Unsafe._class.load();
        jq_StaticMethod[] jq_StaticMethodArray = Unsafe._class.getDeclaredStaticMethods();
        int n2 = 0;
        while (n2 < jq_StaticMethodArray.length) {
            if (!(jq_StaticMethodArray[n2] instanceof jq_ClassInitializer)) {
                this.addNecessaryMethod(jq_StaticMethodArray[n2]);
            }
            ++n2;
        }
        this.addNecessaryType(SimpleAllocator._class);
        this.addNecessaryType(PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/RuntimeCodeAllocator;"));
        jq_Class jq_Class2 = PrimordialClassLoader.getJavaLangSystem();
        this.addNecessaryStaticField(jq_Class2, "in", "Ljava/io/InputStream;");
        this.addNecessaryStaticField(jq_Class2, "out", "Ljava/io/PrintStream;");
        this.addNecessaryStaticField(jq_Class2, "err", "Ljava/io/PrintStream;");
        this.addNecessaryStaticMethod(jq_Class2, "initializeSystemClass", "()V");
        jq_Class2 = (jq_Class)Reflection.getJQType(CharToByteConverter.getDefault().getClass());
        this.addNecessaryInstanceMethod(jq_Class2, "<init>", "()V");
        jq_Class2 = (jq_Class)Reflection.getJQType(ByteToCharConverter.getDefault().getClass());
        this.addNecessaryInstanceMethod(jq_Class2, "<init>", "()V");
        jq_StaticMethod jq_StaticMethod2 = ExceptionDeliverer._trap_handler;
        this.addNecessaryMethod(jq_StaticMethod2);
        jq_InstanceMethod jq_InstanceMethod2 = jq_Method._compile;
        this.addNecessaryMethod(jq_InstanceMethod2);
        this.addNecessaryMethod(jq_NativeThread._nativeThreadEntry);
        this.addNecessaryMethod(jq_NativeThread._threadSwitch);
        this.addNecessaryMethod(jq_NativeThread._ctrl_break_handler);
        this.addNecessaryMethod(jq_InterrupterThread._run);
        this.addNecessaryType(Heap2HeapReference._class);
        try {
            jq_Class2 = (jq_Class)Reflection.getJQType(ByteToCharConverter.getConverter((String)"ISO-8859-1").getClass());
            this.addNecessaryInstanceMethod(jq_Class2, "<init>", "()V");
            jq_Class2 = (jq_Class)Reflection.getJQType(CharToByteConverter.getConverter((String)"ISO-8859-1").getClass());
            this.addNecessaryInstanceMethod(jq_Class2, "<init>", "()V");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        jq_Class2 = (jq_Class)this.addNecessaryType("Lsun/nio/cs/ISO_8859_1;");
        this.addNecessaryInstanceMethod(jq_Class2, "<init>", "()V");
        this.addNecessaryType("Lsun/nio/cs/ISO_8859_1$Encoder;");
        this.addNecessaryType("Lsun/nio/cs/ISO_8859_1$Decoder;");
        this.addNecessaryType("Lsun/nio/cs/ISO_8859_1$1;");
        this.addNecessaryType("Lsun/net/www/protocol/jar/Handler;");
        this.addNecessaryType("Ljava/util/logging/LogManager$Cleaner;");
    }

    public boolean addObjectAndSubfields(Object object) {
        return this.addObjectAndSubfields(object, this.visitedObjects);
    }

    private final boolean addObjectAndSubfields(Object object, LinkedHashSet linkedHashSet) {
        block9: {
            jq_Reference jq_Reference2;
            block8: {
                if (object == null) {
                    return false;
                }
                IdentityHashCodeWrapper identityHashCodeWrapper = IdentityHashCodeWrapper.create(object);
                if (this.visitedObjects.contains(identityHashCodeWrapper) || linkedHashSet.contains(identityHashCodeWrapper)) {
                    return false;
                }
                linkedHashSet.add(identityHashCodeWrapper);
                Class<?> clazz = object.getClass();
                jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
                if (TRACE) {
                    out.println("Adding object of type " + jq_Reference2 + ": " + object);
                }
                this.addInstantiatedType(jq_Reference2);
                if (!jq_Reference2.isArrayType()) break block8;
                jq_Type jq_Type2 = ((jq_Array)jq_Reference2).getElementType();
                if (jq_Type2.isAddressType() || !jq_Type2.isReferenceType()) break block9;
                int n = Array.getLength(object);
                Object[] objectArray = (Object[])object;
                if (TRACE) {
                    out.println("Visiting " + jq_Reference2 + " of " + n + " elements");
                }
                int n2 = 0;
                while (n2 < n) {
                    Object object2 = Reflection.arrayload_A(objectArray, n2);
                    this.addObjectAndSubfields(object2, linkedHashSet);
                    ++n2;
                }
                break block9;
            }
            Assert._assert(jq_Reference2.isClassType());
            jq_Class jq_Class2 = (jq_Class)jq_Reference2;
            jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
            int n = 0;
            while (n < jq_InstanceFieldArray.length) {
                jq_Type jq_Type3;
                jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n];
                if ((this.AddAllFields || this.necessaryFields.contains(jq_InstanceField2)) && !(jq_Type3 = jq_InstanceField2.getType()).isAddressType() && jq_Type3.isReferenceType()) {
                    if (TRACE) {
                        out.println("Visiting field " + jq_InstanceField2);
                    }
                    Object object3 = Reflection.getfield_A(object, jq_InstanceField2);
                    this.addObjectAndSubfields(object3, linkedHashSet);
                }
                ++n;
            }
        }
        return true;
    }

    public void addNecessarySubfieldsOfVisitedObjects() {
        if (this.AddAllFields) {
            return;
        }
        LinkedHashSet linkedHashSet = this.visitedObjects;
        while (true) {
            LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            boolean bl = false;
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                Object object = ((IdentityHashCodeWrapper)iterator.next()).getObject();
                Class<?> clazz = object.getClass();
                jq_Reference jq_Reference2 = (jq_Reference)Reflection.getJQType(clazz);
                if (jq_Reference2.isArrayType()) continue;
                Assert._assert(jq_Reference2.isClassType());
                jq_Class jq_Class2 = (jq_Class)jq_Reference2;
                jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getInstanceFields();
                int n = 0;
                while (n < jq_InstanceFieldArray.length) {
                    jq_Type jq_Type2;
                    jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n];
                    if (this.necessaryFields.contains(jq_InstanceField2) && !(jq_Type2 = jq_InstanceField2.getType()).isAddressType() && jq_Type2.isReferenceType()) {
                        Object object2;
                        if (TRACE) {
                            out.println("Visiting field " + jq_InstanceField2 + " of object of type " + jq_Class2);
                        }
                        if (this.addObjectAndSubfields(object2 = Reflection.getfield_A(object, jq_InstanceField2), linkedHashSet2)) {
                            bl = true;
                        }
                    }
                    ++n;
                }
            }
            if (!bl) break;
            if (TRACE) {
                out.println("Objects added: " + linkedHashSet2.size() + ", iterating over those objects.");
            }
            this.visitedObjects.addAll(linkedHashSet2);
            linkedHashSet = linkedHashSet2;
        }
    }

    public void addAllInterfaceMethodImplementations(jq_InstanceMethod jq_InstanceMethod2) {
        this.addNecessaryMethod(jq_InstanceMethod2);
        jq_Class jq_Class2 = jq_InstanceMethod2.getDeclaringClass();
        Assert._assert(jq_Class2.isInterface());
        Iterator iterator = this.necessaryTypes.iterator();
        while (iterator.hasNext()) {
            jq_Reference jq_Reference2;
            jq_Type jq_Type2 = (jq_Type)iterator.next();
            if (!jq_Type2.isReferenceType() || jq_Type2.isAddressType() || !(jq_Reference2 = (jq_Reference)jq_Type2).implementsInterface(jq_Class2)) continue;
            jq_InstanceMethod jq_InstanceMethod3 = jq_Reference2.getVirtualMethod(jq_InstanceMethod2.getNameAndDesc());
            if (jq_InstanceMethod3 == null) {
                if (!TRACE) continue;
                out.println("Error: class " + jq_Reference2 + " does not implement interface method " + jq_InstanceMethod2);
                continue;
            }
            this.addNecessaryMethod(jq_InstanceMethod3);
        }
    }

    public void addAllVirtualMethodImplementations(jq_InstanceMethod jq_InstanceMethod2) {
        this.addNecessaryMethod(jq_InstanceMethod2);
        this.addAllVirtualMethodImplementations(jq_InstanceMethod2.getDeclaringClass(), jq_InstanceMethod2);
    }

    public void addAllVirtualMethodImplementations(jq_Class jq_Class2, jq_InstanceMethod jq_InstanceMethod2) {
        if (!jq_InstanceMethod2.isOverridden()) {
            return;
        }
        jq_Class[] jq_ClassArray = jq_Class2.getSubClasses();
        int n = 0;
        while (n < jq_ClassArray.length) {
            jq_Class jq_Class3 = jq_ClassArray[n];
            jq_Class3.prepare();
            jq_Method jq_Method2 = (jq_Method)jq_Class3.getDeclaredMember(jq_InstanceMethod2.getNameAndDesc());
            if (jq_Method2 != null && !jq_Method2.isStatic()) {
                this.addNecessaryMethod(jq_Method2);
            }
            this.addAllVirtualMethodImplementations(jq_Class3, jq_InstanceMethod2);
            ++n;
        }
    }

    public void trimClass(jq_Class jq_Class2) {
        jq_Method jq_Method2;
        jq_Member jq_Member2;
        Assert._assert(jq_Class2.isPrepared());
        jq_Class jq_Class3 = jq_Class2.getSuperclass();
        if (jq_Class3 != null) {
            this.trimClass(jq_Class3);
        }
        Set set = this.getNecessaryFields();
        Set set2 = this.getNecessaryMethods();
        Iterator iterator = jq_Class2.getMembers().iterator();
        while (iterator.hasNext()) {
            jq_Member jq_Member3 = (jq_Member)iterator.next();
            if (jq_Member3 instanceof jq_Field) {
                if (set.contains(jq_Member3)) continue;
                if (TRACE) {
                    out.println("Eliminating field: " + jq_Member3);
                }
                iterator.remove();
                continue;
            }
            Assert._assert(jq_Member3 instanceof jq_Method);
            if (set2.contains(jq_Member3)) continue;
            if (TRACE) {
                out.println("Eliminating method: " + jq_Member3);
            }
            iterator.remove();
        }
        int n = 0;
        jq_InstanceField[] jq_InstanceFieldArray = jq_Class2.getDeclaredInstanceFields();
        int n2 = 0;
        while (n2 < jq_InstanceFieldArray.length) {
            jq_InstanceField jq_InstanceField2 = jq_InstanceFieldArray[n2];
            jq_InstanceField2.unprepare();
            if (set2.contains(jq_InstanceField2)) {
                ++n;
            }
            ++n2;
        }
        jq_InstanceField[] jq_InstanceFieldArray2 = new jq_InstanceField[n];
        int n3 = 0;
        int n4 = -1;
        while (n4 < n - 1) {
            jq_InstanceField jq_InstanceField3 = jq_InstanceFieldArray[n3];
            if (set.contains(jq_InstanceField3)) {
                jq_InstanceFieldArray2[++n4] = jq_InstanceField3;
                ++jq_Class.NumOfIFieldsKept;
            } else {
                if (TRACE) {
                    out.println("Eliminating instance field: " + jq_InstanceField3);
                }
                ++jq_Class.NumOfIFieldsEliminated;
            }
            ++n3;
        }
        jq_Class2.setDeclaredInstanceFields(jq_InstanceFieldArray2);
        jq_StaticField[] jq_StaticFieldArray = jq_Class2.getDeclaredStaticFields();
        n4 = 0;
        n = 0;
        int n5 = 0;
        while (n5 < jq_StaticFieldArray.length) {
            jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n5];
            jq_StaticField2.unprepare();
            if (set.contains(jq_StaticField2)) {
                ++n;
            }
            ++n5;
        }
        jq_StaticField[] jq_StaticFieldArray2 = new jq_StaticField[n];
        int n6 = 0;
        int n7 = -1;
        while (n7 < n - 1) {
            jq_Member2 = jq_StaticFieldArray[n6];
            if (set.contains(jq_Member2)) {
                jq_StaticFieldArray2[++n7] = jq_Member2;
                n4 += ((jq_StaticField)jq_Member2).getWidth();
                ++jq_Class.NumOfSFieldsKept;
            } else {
                if (TRACE) {
                    out.println("Eliminating static field: " + jq_Member2);
                }
                ++jq_Class.NumOfSFieldsEliminated;
            }
            ++n6;
        }
        jq_Class2.setDeclaredStaticFields(jq_StaticFieldArray2);
        n = 0;
        jq_InstanceMethod[] jq_InstanceMethodArray = jq_Class2.getDeclaredInstanceMethods();
        n7 = 0;
        while (n7 < jq_InstanceMethodArray.length) {
            jq_Member2 = jq_InstanceMethodArray[n7];
            ((jq_InstanceMethod)jq_Member2).unprepare();
            ((jq_InstanceMethod)jq_Member2).clearOverrideFlags();
            if (set2.contains(jq_Member2)) {
                ++n;
            }
            ++n7;
        }
        jq_InstanceMethod[] jq_InstanceMethodArray2 = new jq_InstanceMethod[n];
        int n8 = 0;
        int n9 = -1;
        while (n9 < n - 1) {
            jq_Method2 = jq_InstanceMethodArray[n8];
            if (set2.contains(jq_Method2)) {
                jq_InstanceMethodArray2[++n9] = jq_Method2;
                ++jq_Class.NumOfIMethodsKept;
            } else {
                if (TRACE) {
                    out.println("Eliminating instance method: " + jq_Method2);
                }
                ++jq_Class.NumOfIMethodsEliminated;
            }
            ++n8;
        }
        jq_Class2.setDeclaredInstanceMethods(jq_InstanceMethodArray2);
        n = 0;
        jq_StaticMethod[] jq_StaticMethodArray = jq_Class2.getDeclaredStaticMethods();
        n9 = 0;
        while (n9 < jq_StaticMethodArray.length) {
            jq_Method2 = jq_StaticMethodArray[n9];
            ((jq_StaticMethod)jq_Method2).unprepare();
            if (set2.contains(jq_Method2)) {
                ++n;
            }
            ++n9;
        }
        jq_StaticMethod[] jq_StaticMethodArray2 = new jq_StaticMethod[n];
        int n10 = 0;
        int n11 = -1;
        while (n11 < n - 1) {
            jq_StaticMethod jq_StaticMethod2 = jq_StaticMethodArray[n10];
            if (set2.contains(jq_StaticMethod2)) {
                jq_StaticMethodArray2[++n11] = jq_StaticMethod2;
                ++jq_Class.NumOfSMethodsKept;
            } else {
                if (TRACE) {
                    out.println("Eliminating static method: " + jq_StaticMethod2);
                }
                ++jq_Class.NumOfSMethodsEliminated;
            }
            ++n10;
        }
        jq_Class2.setDeclaredStaticMethods(jq_StaticMethodArray2);
        jq_Class2.getCP().trim(set, set2);
        jq_Class2.prepare();
    }

    public BootstrapRootSet(boolean bl) {
        this.AddAllFields = bl;
    }
}

