/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Allocator.CodeAllocator;
import Allocator.DefaultCodeAllocator;
import Assembler.x86.x86;
import Assembler.x86.x86Constants;
import Main.jq;
import Memory.CodeAddress;
import Util.Assert;
import Util.Collections.LightRelation;
import Util.Collections.Relation;
import Util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class x86Assembler
implements x86Constants {
    public static boolean TRACE = false;
    private int ip;
    private CodeAllocator.x86CodeBuffer mc;
    private Map branchtargetmap;
    private Relation branches_to_patch;
    private int dynPatchStart;
    private int dynPatchSize;

    public CodeAllocator.x86CodeBuffer getCodeBuffer() {
        if (!this.branches_to_patch.isEmpty()) {
            System.out.println("Error: unresolved forward branches!");
        }
        return this.mc;
    }

    public int getCurrentOffset() {
        return this.mc.getCurrentOffset();
    }

    public CodeAddress getCurrentAddress() {
        return this.mc.getCurrentAddress();
    }

    public CodeAddress getStartAddress() {
        return this.mc.getStartAddress();
    }

    public void patch1(int n, byte by) {
        this.mc.put1(n, by);
    }

    public void patch4_endian(int n, int n2) {
        this.mc.put4_endian(n, n2);
    }

    public boolean containsTarget(Object object) {
        return this.branchtargetmap.containsKey(object);
    }

    public void recordBranchTarget(Object object) {
        boolean bl = false;
        if (this.ip == this.mc.getCurrentOffset()) {
            bl = true;
        }
        Assert._assert(bl);
        this.branchtargetmap.put(object, new Integer(this.ip));
    }

    public int getBranchTarget(Object object) {
        Integer n = (Integer)this.branchtargetmap.get(object);
        if (n == null) {
            Assert.UNREACHABLE("Invalid branch target: " + object + " offset " + this.getCurrentOffset());
        }
        return n;
    }

    public Map getBranchTargetMap() {
        return this.branchtargetmap;
    }

    public void recordForwardBranch(int n, Object object) {
        if (TRACE) {
            System.out.println("recording forward branch from " + Strings.hex(this.ip) + " (size " + n + ") to " + object);
        }
        this.branches_to_patch.add(object, new PatchInfo(this.ip, n));
    }

    public void recordAbsoluteReference(int n, Object object) {
        if (TRACE) {
            System.out.println("recording absolute reference from " + Strings.hex(this.ip) + " (size " + n + ") to " + object);
        }
        this.branches_to_patch.add(object, new AbsPatchInfo(this.ip, n));
    }

    public void resolveForwardBranches(Object object) {
        Iterator iterator = this.branches_to_patch.getValues(object).iterator();
        while (iterator.hasNext()) {
            PatchInfo patchInfo = (PatchInfo)iterator.next();
            if (TRACE) {
                System.out.println("patching branch to " + object + " (" + patchInfo + ") to point to " + Strings.hex(this.ip));
            }
            patchInfo.patchTo(this.mc, this.ip);
        }
        this.branches_to_patch.removeKey(object);
    }

    public void startDynamicPatch(int n) {
        if (jq.SMP) {
            int n2 = this.ip + n;
            int n3 = 255;
            while ((this.ip & n3) != (n2 & n3)) {
                this.emit1(x86.NOP);
            }
        }
        this.dynPatchStart = this.ip;
        this.dynPatchSize = n;
    }

    public void endDynamicPatch() {
        boolean bl = false;
        if (this.ip <= this.dynPatchStart + this.dynPatchSize) {
            bl = true;
        }
        Assert._assert(bl);
        while (this.ip < this.dynPatchStart + this.dynPatchSize) {
            this.emit1(x86.NOP);
        }
        this.dynPatchSize = 0;
    }

    public void emitprefix(byte by) {
        this.mc.add1(by);
        ++this.ip;
    }

    public void emitPUSH_i(int n) {
        this.ip = x86Assembler.fits(n, 8) ? (this.ip += x86.PUSH_i8.emit1_Imm8(this.mc, n)) : (this.ip += x86.PUSH_i32.emit1_Imm32(this.mc, n));
    }

    public void emit2_SHIFT_Mem_Imm8(x86 x862, int n, int n2, byte by) {
        this.ip = n2 == 4 ? (n == 0 ? (by == 1 ? (this.ip += x862.emit2_Once_SIB_EA(this.mc, 4, 4, 0)) : (this.ip += x862.emit2_SIB_EA_Imm8(this.mc, 4, 4, 0, by))) : (x86Assembler.fits_signed(n, 8) ? (by == 1 ? (this.ip += x862.emit2_Once_SIB_DISP8(this.mc, 4, 4, 0, (byte)n)) : (this.ip += x862.emit2_SIB_DISP8_Imm8(this.mc, 4, 4, 0, (byte)n, by))) : (by == 1 ? (this.ip += x862.emit2_Once_SIB_DISP32(this.mc, 4, 4, 0, n)) : (this.ip += x862.emit2_SIB_DISP32_Imm8(this.mc, 4, 4, 0, n, by))))) : (n == 0 && n2 != 5 ? (by == 1 ? (this.ip += x862.emit2_Once_EA(this.mc, n2)) : (this.ip += x862.emit2_EA_Imm8(this.mc, n2, by))) : (x86Assembler.fits_signed(n, 8) ? (by == 1 ? (this.ip += x862.emit2_Once_DISP8(this.mc, (byte)n, n2)) : (this.ip += x862.emit2_DISP8_Imm8(this.mc, (byte)n, n2, by))) : (by == 1 ? (this.ip += x862.emit2_Once_DISP32(this.mc, n, n2)) : (this.ip += x862.emit2_DISP32_Imm8(this.mc, n, n2, by)))));
    }

    public void emit2_SHIFT_Reg_Imm8(x86 x862, int n, byte by) {
        this.ip = by == 1 ? (this.ip += x862.emit2_Once_Reg(this.mc, n)) : (this.ip += x862.emit2_Reg_Imm8(this.mc, n, by));
    }

    public void emitSHLD_r_r_rc(int n, int n2) {
        this.ip += x86.SHLD_r_r_rc.emit3_Reg_Reg(this.mc, n2, n);
    }

    public void emitSHRD_r_r_rc(int n, int n2) {
        this.ip += x86.SHRD_r_r_rc.emit3_Reg_Reg(this.mc, n2, n);
    }

    public void emitShort_Reg(x86 x862, int n) {
        this.ip += x862.emitShort_Reg(this.mc, n);
    }

    public void emitShort_Reg_Imm(x86 x862, int n, int n2) {
        this.ip += x862.emitShort_Reg_Imm32(this.mc, n, n2);
    }

    public void emit1(x86 x862) {
        this.ip += x862.emit1(this.mc);
    }

    public void emit1_Imm8(x86 x862, byte by) {
        this.ip += x862.emit1_Imm8(this.mc, by);
    }

    public void emit1_Imm16(x86 x862, char c) {
        this.ip += x862.emit1_Imm16(this.mc, c);
    }

    public void emit1_Imm32(x86 x862, int n) {
        this.ip += x862.emit1_Imm32(this.mc, n);
    }

    public void emit2(x86 x862) {
        this.ip += x862.emit2(this.mc);
    }

    public void emit2_FPReg(x86 x862, int n) {
        this.ip += x862.emit2_FPReg(this.mc, n);
    }

    public void emit2_Mem(x86 x862, int n) {
        this.ip += x862.emit2_Abs32(this.mc, n);
    }

    public void emit2_Mem(x86 x862, int n, int n2) {
        this.ip = n2 == 4 ? (n == 0 ? (this.ip += x862.emit2_SIB_EA(this.mc, 4, 4, 0)) : (x86Assembler.fits_signed(n, 8) ? (this.ip += x862.emit2_SIB_DISP8(this.mc, 4, 4, 0, (byte)n)) : (this.ip += x862.emit2_SIB_DISP32(this.mc, 4, 4, 0, n)))) : (n == 0 && n2 != 5 ? (this.ip += x862.emit2_EA(this.mc, n2)) : (x86Assembler.fits_signed(n, 8) ? (this.ip += x862.emit2_DISP8(this.mc, (byte)n, n2)) : (this.ip += x862.emit2_DISP32(this.mc, n, n2))));
    }

    public void emit2_Mem(x86 x862, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n2 != 4) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (n != 4) {
            bl2 = true;
        }
        Assert._assert(bl2);
        this.ip = n4 == 0 ? (this.ip += x862.emit2_SIB_EA(this.mc, n, n2, n3)) : (x86Assembler.fits_signed(n4, 8) ? (this.ip += x862.emit2_SIB_DISP8(this.mc, n, n2, n3, (byte)n4)) : (this.ip += x862.emit2_SIB_DISP32(this.mc, n, n2, n3, n4)));
    }

    public void emit2_Mem_Imm(x86 x862, int n, int n2, int n3) {
        this.ip = n2 == 4 ? (n == 0 ? (this.ip += x862.emit2_SIB_EA_Imm32(this.mc, 4, 4, 0, n3)) : (x86Assembler.fits_signed(n, 8) ? (this.ip += x862.emit2_SIB_DISP8_Imm32(this.mc, 4, 4, 0, (byte)n, n3)) : (this.ip += x862.emit2_SIB_DISP32_Imm32(this.mc, 4, 4, 0, n, n3)))) : (n == 0 && n2 != 5 ? (this.ip += x862.emit2_EA_Imm32(this.mc, n2, n3)) : (x86Assembler.fits_signed(n, 8) ? (this.ip += x862.emit2_DISP8_Imm32(this.mc, (byte)n, n2, n3)) : (this.ip += x862.emit2_DISP32_Imm32(this.mc, n, n2, n3))));
    }

    public void emit2_Reg(x86 x862, int n) {
        this.ip += x862.emit2_Reg(this.mc, n);
    }

    public void emit2_Reg_Mem(x86 x862, int n, int n2) {
        this.ip += x862.emit2_Reg_Abs32(this.mc, n, n2);
    }

    public void emit2_Reg_Mem(x86 x862, int n, int n2, int n3) {
        this.ip = n3 == 4 ? (n2 == 0 ? (this.ip += x862.emit2_Reg_SIB_EA(this.mc, n, 4, 4, 0)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit2_Reg_SIB_DISP8(this.mc, n, 4, 4, 0, (byte)n2)) : (this.ip += x862.emit2_Reg_SIB_DISP32(this.mc, n, 4, 4, 0, n2)))) : (n2 == 0 && n3 != 5 ? (this.ip += x862.emit2_Reg_EA(this.mc, n, n3)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit2_Reg_DISP8(this.mc, n, (byte)n2, n3)) : (this.ip += x862.emit2_Reg_DISP32(this.mc, n, n2, n3))));
    }

    public void emit2_Reg_Mem(x86 x862, int n, int n2, int n3, int n4, int n5) {
        this.ip = n5 == 0 ? (this.ip += x862.emit2_Reg_SIB_EA(this.mc, n, n2, n3, n4)) : (x86Assembler.fits_signed(n5, 8) ? (this.ip += x862.emit2_Reg_SIB_DISP8(this.mc, n, n2, n3, n4, (byte)n5)) : (this.ip += x862.emit2_Reg_SIB_DISP32(this.mc, n, n2, n3, n4, n5)));
    }

    public void emit2_Reg_Reg(x86 x862, int n, int n2) {
        this.ip += x862.emit2_Reg_Reg(this.mc, n, n2);
    }

    public void emit3_Reg_Reg(x86 x862, int n, int n2) {
        this.ip += x862.emit3_Reg_Reg(this.mc, n, n2);
    }

    public void emit3_Reg_Mem(x86 x862, int n, int n2) {
        this.ip += x862.emit3_Reg_Abs32(this.mc, n, n2);
    }

    public void emit3_Reg_Mem(x86 x862, int n, int n2, int n3) {
        this.ip = n3 == 4 ? (n2 == 0 ? (this.ip += x862.emit3_Reg_SIB_EA(this.mc, n, 4, 4, 0)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit3_Reg_SIB_DISP8(this.mc, n, 4, 4, 0, (byte)n2)) : (this.ip += x862.emit3_Reg_SIB_DISP32(this.mc, n, 4, 4, 0, n2)))) : (n2 == 0 && n3 != 5 ? (this.ip += x862.emit3_Reg_EA(this.mc, n, n3)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit3_Reg_DISP8(this.mc, n, (byte)n2, n3)) : (this.ip += x862.emit3_Reg_DISP32(this.mc, n, n2, n3))));
    }

    public void emit3_Reg_Mem(x86 x862, int n, int n2, int n3, int n4, int n5) {
        this.ip = n5 == 0 ? (this.ip += x862.emit3_Reg_SIB_EA(this.mc, n, n2, n3, n4)) : (x86Assembler.fits_signed(n5, 8) ? (this.ip += x862.emit3_Reg_SIB_DISP8(this.mc, n, n2, n3, n4, (byte)n5)) : (this.ip += x862.emit3_Reg_SIB_DISP32(this.mc, n, n2, n3, n4, n5)));
    }

    public void emitARITH_Mem_Imm(x86 x862, int n, int n2, int n3) {
        this.ip = n2 == 4 ? (n == 0 ? (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_SIB_EA_SEImm8(this.mc, 4, 4, 0, (byte)n3)) : (this.ip += x862.emit2_SIB_EA_Imm32(this.mc, 4, 4, 0, n3))) : (x86Assembler.fits_signed(n, 8) ? (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_SIB_DISP8_SEImm8(this.mc, 4, 4, 0, (byte)n, (byte)n3)) : (this.ip += x862.emit2_SIB_DISP8_Imm32(this.mc, 4, 4, 0, (byte)n, n3))) : (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_SIB_DISP32_SEImm8(this.mc, 4, 4, 0, n, (byte)n3)) : (this.ip += x862.emit2_SIB_DISP32_Imm32(this.mc, 4, 4, 0, n, n3))))) : (n == 0 && n2 != 5 ? (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_EA_SEImm8(this.mc, n2, (byte)n3)) : (this.ip += x862.emit2_EA_Imm32(this.mc, n2, n3))) : (x86Assembler.fits_signed(n, 8) ? (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_DISP8_SEImm8(this.mc, (byte)n, n2, (byte)n3)) : (this.ip += x862.emit2_DISP8_Imm32(this.mc, (byte)n, n2, n3))) : (x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n3, 8) ? (this.ip += x862.emit2_DISP32_SEImm8(this.mc, n, n2, (byte)n3)) : (this.ip += x862.emit2_DISP32_Imm32(this.mc, n, n2, n3)))));
    }

    public void emitARITH_Reg_Imm(x86 x862, int n, int n2) {
        this.ip = x862 != x86.TEST_r_i32 && x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit2_Reg_SEImm8(this.mc, n, (byte)n2)) : (this.ip += x862.emit2_Reg_Imm32(this.mc, n, n2));
    }

    public void emitARITH_Reg_Reg(x86 x862, int n, int n2) {
        this.ip += x862.emit2_Reg_Reg(this.mc, n, n2);
    }

    public void emitARITH_Reg_Mem(x86 x862, int n, int n2, int n3) {
        this.ip = n3 == 4 ? (n2 == 0 ? (this.ip += x862.emit2_Reg_SIB_EA(this.mc, n, 4, 4, 0)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit2_Reg_SIB_DISP8(this.mc, n, 4, 4, 0, (byte)n2)) : (this.ip += x862.emit2_Reg_SIB_DISP32(this.mc, n, 4, 4, 0, n2)))) : (n2 == 0 && n3 != 5 ? (this.ip += x862.emit2_Reg_EA(this.mc, n, n3)) : (x86Assembler.fits_signed(n2, 8) ? (this.ip += x862.emit2_Reg_DISP8(this.mc, n, (byte)n2, n3)) : (this.ip += x862.emit2_Reg_DISP32(this.mc, n, n2, n3))));
    }

    public void emitCJUMP_Back(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        int n = this.getBranchTarget(object) - this.ip - 2;
        if (n >= -128) {
            if (TRACE) {
                System.out.println("Short cjump back from offset " + Strings.hex(this.ip + 2) + " to " + object + " offset " + this.getBranchTarget(object) + " (relative offset " + Strings.shex(n) + ')');
            }
            this.ip += x862.emitCJump_Short(this.mc, (byte)n);
        } else {
            if (TRACE) {
                System.out.println("Near cjump back from offset " + Strings.hex(this.ip + 6) + " to " + object + " offset " + this.getBranchTarget(object) + " (relative offset " + Strings.shex(n - 4) + ')');
            }
            this.ip += x862.emitCJump_Near(this.mc, n - 4);
        }
    }

    public void emitCJUMP_Short(x86 x862, byte by) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitCJump_Short(this.mc, by);
    }

    public void emitCJUMP_Forw_Short(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitCJump_Short(this.mc, (byte)0);
        this.recordForwardBranch(1, object);
    }

    public void emitCJUMP_Forw(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitCJump_Near(this.mc, 0x66666666);
        this.recordForwardBranch(4, object);
    }

    public void emitJUMP_Back(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        int n = this.getBranchTarget(object) - this.ip - 2;
        if (n >= -128) {
            if (TRACE) {
                System.out.println("Short jump back from offset " + Strings.hex(this.ip + 2) + " to " + object + " offset " + this.getBranchTarget(object) + " (relative offset " + Strings.shex(n) + ')');
            }
            this.ip += x862.emitJump_Short(this.mc, (byte)n);
        } else {
            if (TRACE) {
                System.out.println("Near jump back from offset " + Strings.hex(this.ip + 5) + " to " + object + " offset " + this.getBranchTarget(object) + " (relative offset " + Strings.shex(n - 3) + ')');
            }
            this.ip += x862.emitJump_Near(this.mc, n - 3);
        }
    }

    public void emitJUMP_Short(x86 x862, byte by) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitJump_Short(this.mc, by);
    }

    public void emitJUMP_Forw_Short(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitJump_Short(this.mc, (byte)0);
        this.recordForwardBranch(1, object);
    }

    public void emitJUMP_Forw(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitJump_Near(this.mc, 0x55555555);
        this.recordForwardBranch(4, object);
    }

    public void emitCALL_rel32(x86 x862, int n) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitCall_Near(this.mc, n);
    }

    public void emitCALL_Back(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        int n = this.getBranchTarget(object) - this.ip - 5;
        this.ip += x862.emitCall_Near(this.mc, n);
    }

    public void emitCALL_Forw(x86 x862, Object object) {
        boolean bl = false;
        if (x862.length == 1) {
            bl = true;
        }
        Assert._assert(bl);
        this.ip += x862.emitCall_Near(this.mc, 0x44444444);
        this.recordForwardBranch(4, object);
    }

    public void emitDATA(int n) {
        this.mc.add4_endian(n);
        this.ip += 4;
    }

    public void skip(int n) {
        if (TRACE) {
            System.out.println("skipping " + n + " bytes");
        }
        this.mc.skip(n);
        this.ip += n;
    }

    public void setEntrypoint() {
        this.mc.setEntrypoint();
    }

    public static boolean fits(int n, int n2) {
        boolean bl = false;
        if ((n >>= n2 - 1) == 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean fits_signed(int n, int n2) {
        boolean bl = false;
        if ((n >>= n2 - 1) == 0 || n == -1) {
            bl = true;
        }
        return bl;
    }

    public x86Assembler(int n, int n2, int n3, int n4) {
        this.mc = DefaultCodeAllocator.getCodeBuffer(n2, n3, n4);
        if (TRACE) {
            System.out.println("Assembler start address: " + this.mc.getCurrentAddress().stringRep());
        }
        this.branchtargetmap = new HashMap();
        this.branches_to_patch = new LightRelation();
    }

    static class PatchInfo {
        int patchLocation;
        int patchSize;

        void patchTo(CodeAllocator.x86CodeBuffer x86CodeBuffer2, int n) {
            if (this.patchSize == 4) {
                int n2 = x86CodeBuffer2.get4_endian(this.patchLocation - 4);
                boolean bl = false;
                if (n2 == 0x44444444 || n2 == 0x55555555 || n2 == 0x66666666 || n2 == 0x77777777) {
                    bl = true;
                }
                Assert._assert(bl, "Location: " + Strings.hex(this.patchLocation - 4) + " value: " + Strings.hex8(n2));
                x86CodeBuffer2.put4_endian(this.patchLocation - 4, n - this.patchLocation);
            } else if (this.patchSize == 1) {
                byte by = x86CodeBuffer2.get1(this.patchLocation - 1);
                boolean bl = false;
                if (by == 0) {
                    bl = true;
                }
                Assert._assert(bl);
                boolean bl2 = false;
                if (n - this.patchLocation <= 127) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                boolean bl3 = false;
                if (n - this.patchLocation >= -128) {
                    bl3 = true;
                }
                Assert._assert(bl3);
                x86CodeBuffer2.put1(this.patchLocation - 1, (byte)(n - this.patchLocation));
            } else {
                Assert.TODO();
            }
        }

        public String toString() {
            return "loc:" + Strings.hex(this.patchLocation) + " size:" + this.patchSize;
        }

        PatchInfo(int n, int n2) {
            this.patchLocation = n;
            this.patchSize = n2;
        }
    }

    static class AbsPatchInfo
    extends PatchInfo {
        void patchTo(CodeAllocator.x86CodeBuffer x86CodeBuffer2, int n) {
            if (this.patchSize == 4) {
                int n2 = x86CodeBuffer2.get4_endian(this.patchLocation - 4);
                boolean bl = false;
                if (n2 == 0x44444444 || n2 == 0x55555555 || n2 == 0x66666666 || n2 == 0x77777777) {
                    bl = true;
                }
                Assert._assert(bl, "Location: " + Strings.hex(this.patchLocation - 4) + " value: " + Strings.hex8(n2));
                x86CodeBuffer2.put4_endian(this.patchLocation - 4, x86CodeBuffer2.getStartAddress().offset(n).to32BitValue());
            } else {
                Assert.TODO();
            }
        }

        public String toString() {
            return "loc:" + Strings.hex(this.patchLocation) + " size:" + this.patchSize + " (abs)";
        }

        AbsPatchInfo(int n, int n2) {
            super(n, n2);
        }
    }
}

