/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Assembler.x86.Reloc;
import Memory.CodeAddress;
import Memory.HeapAddress;
import java.io.DataOutput;
import java.io.IOException;

public class Code2HeapReference
extends Reloc {
    private CodeAddress from_codeloc;
    private HeapAddress to_heaploc;

    public CodeAddress getFrom() {
        return this.from_codeloc;
    }

    public HeapAddress getTo() {
        return this.to_heaploc;
    }

    public void patch() {
        this.from_codeloc.poke(this.to_heaploc);
    }

    public void dumpCOFF(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.from_codeloc.to32BitValue());
        dataOutput.writeInt(1);
        dataOutput.writeChar(6);
    }

    public String toString() {
        return "from code:" + this.from_codeloc.stringRep() + " to heap:" + this.to_heaploc.stringRep();
    }

    public Code2HeapReference(CodeAddress codeAddress, HeapAddress heapAddress) {
        this.from_codeloc = codeAddress;
        this.to_heaploc = heapAddress;
    }
}

