/*
 * Decompiled with CFR 0.152.
 */
package Assembler.x86;

import Allocator.DefaultCodeAllocator;
import Assembler.x86.Reloc;
import Memory.CodeAddress;
import java.io.DataOutput;
import java.io.IOException;

public class Code2CodeReference
extends Reloc {
    private CodeAddress from_codeloc;
    private CodeAddress to_codeloc;

    public CodeAddress getFrom() {
        return this.from_codeloc;
    }

    public CodeAddress getTo() {
        return this.to_codeloc;
    }

    public void patch() {
        if (this.to_codeloc != null) {
            DefaultCodeAllocator.patchAbsolute(this.from_codeloc, this.to_codeloc);
        }
    }

    public void dumpCOFF(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.from_codeloc.to32BitValue());
        dataOutput.writeInt(0);
        dataOutput.writeChar(6);
    }

    public String toString() {
        return "from code:" + this.from_codeloc.stringRep() + " to code:" + this.to_codeloc.stringRep();
    }

    public Code2CodeReference(CodeAddress codeAddress, CodeAddress codeAddress2) {
        this.from_codeloc = codeAddress;
        this.to_codeloc = codeAddress2;
    }
}

