/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Allocator.FreeMemManager;
import Allocator.HeapAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_InstanceMethod;
import GC.GCBits;
import Memory.Address;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import Util.Assert;

public class SimpleAllocator
extends HeapAllocator {
    public static final int BLOCK_SIZE = 0x200000;
    public static int MAX_MEMORY = 0x4000000;
    public static final int LARGE_THRESHOLD = 262144;
    public static final jq_Class _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/SimpleAllocator;");
    public static final jq_InstanceMethod _allocateObject = _class.getOrCreateInstanceMethod("allocateObject", "(ILjava/lang/Object;)Ljava/lang/Object;");
    public static final jq_InstanceMethod _allocateObjectAlign8 = _class.getOrCreateInstanceMethod("allocateObjectAlign8", "(ILjava/lang/Object;)Ljava/lang/Object;");
    public static final jq_InstanceMethod _allocateArray = _class.getOrCreateInstanceMethod("allocateArray", "(IILjava/lang/Object;)Ljava/lang/Object;");
    public static final jq_InstanceMethod _allocateArrayAlign8 = _class.getOrCreateInstanceMethod("allocateArrayAlign8", "(IILjava/lang/Object;)Ljava/lang/Object;");
    private HeapAddress heapFirst;
    private HeapAddress heapCurrent;
    private HeapAddress heapEnd;
    private GCBits gcBits;

    public final void init() throws OutOfMemoryError {
        this.heapCurrent = this.heapFirst = (HeapAddress)SystemInterface.syscalloc(0x200000);
        if (this.heapCurrent.isNull()) {
            HeapAllocator.outOfMemory();
        }
        this.heapEnd = (HeapAddress)this.heapFirst.offset(0x200000 - 2 * HeapAddress.size());
        this.installGCBits();
    }

    private final void allocateNewBlock() {
        if (this.totalMemory() >= MAX_MEMORY) {
            HeapAllocator.outOfMemory();
        }
        this.heapCurrent = (HeapAddress)SystemInterface.syscalloc(0x200000);
        if (this.heapCurrent.isNull()) {
            HeapAllocator.outOfMemory();
        }
        this.heapEnd.offset(HeapAddress.size()).poke(this.heapCurrent);
        this.heapEnd = (HeapAddress)this.heapCurrent.offset(0x200000 - 2 * HeapAddress.size());
        this.installGCBits();
    }

    private final void installGCBits() {
        this.gcBits = null;
        this.gcBits = new GCBits(this.heapCurrent, this.heapEnd);
        this.heapEnd.poke(HeapAddress.addressOf(this.gcBits));
    }

    public final int freeMemory() {
        return this.heapEnd.difference(this.heapCurrent);
    }

    public final int totalMemory() {
        int n = 0;
        HeapAddress heapAddress = this.heapFirst;
        while (!heapAddress.isNull()) {
            n += 0x200000;
            heapAddress = (HeapAddress)heapAddress.offset(0x200000 - HeapAddress.size()).peek();
        }
        return n;
    }

    public final Object allocateObject(int n, Object object) throws OutOfMemoryError {
        if (n < 8) {
            HeapAllocator.outOfMemory();
        }
        n = n + 3 & 0xFFFFFFFC;
        HeapAddress heapAddress = (HeapAddress)this.heapCurrent.offset(8);
        this.heapCurrent = (HeapAddress)this.heapCurrent.offset(n);
        if (this.heapEnd.difference(this.heapCurrent) < 0) {
            boolean bl = false;
            if (n < 0x200000 - 2 * HeapAddress.size()) {
                bl = true;
            }
            Assert._assert(bl);
            this.heapCurrent = (HeapAddress)this.heapCurrent.offset(-n);
            heapAddress = (HeapAddress)FreeMemManager.getFreeMem(n + 8);
            if (heapAddress != null) {
                heapAddress = (HeapAddress)heapAddress.offset(8);
            } else {
                this.allocateNewBlock();
                heapAddress = (HeapAddress)this.heapCurrent.offset(8);
                this.heapCurrent = (HeapAddress)this.heapCurrent.offset(n);
            }
        }
        heapAddress.offset(-4).poke(HeapAddress.addressOf(object));
        if (this.gcBits != null) {
            this.gcBits.set((HeapAddress)heapAddress.offset(-8));
        }
        return heapAddress.asObject();
    }

    public final Object allocateObjectAlign8(int n, Object object) throws OutOfMemoryError {
        this.heapCurrent = (HeapAddress)this.heapCurrent.offset(8).align(3).offset(-8);
        return this.allocateObject(n, object);
    }

    public final Object allocateArray(int n, int n2, Object object) throws OutOfMemoryError, NegativeArraySizeException {
        if (n < 0) {
            throw new NegativeArraySizeException(n + " < 0");
        }
        if (n2 < 12) {
            HeapAllocator.outOfMemory();
        }
        n2 = n2 + 3 & 0xFFFFFFFC;
        HeapAddress heapAddress = (HeapAddress)this.heapCurrent.offset(12);
        this.heapCurrent = (HeapAddress)this.heapCurrent.offset(n2);
        if (this.heapEnd.difference(this.heapCurrent) < 0) {
            this.heapCurrent = (HeapAddress)this.heapCurrent.offset(-n2);
            if (n2 > 262144) {
                heapAddress = (HeapAddress)SystemInterface.syscalloc(n2);
                if (heapAddress.isNull()) {
                    SimpleAllocator.outOfMemory();
                }
                heapAddress = (HeapAddress)heapAddress.offset(12);
                heapAddress.offset(-12).poke4(n);
                heapAddress.offset(-4).poke(HeapAddress.addressOf(object));
                return heapAddress.asObject();
            }
            boolean bl = false;
            if (n2 < 0x200000 - 2 * HeapAddress.size()) {
                bl = true;
            }
            Assert._assert(bl);
            heapAddress = (HeapAddress)FreeMemManager.getFreeMem(n2 + 8);
            if (heapAddress != null) {
                heapAddress = (HeapAddress)heapAddress.offset(12);
            } else {
                this.allocateNewBlock();
                heapAddress = (HeapAddress)this.heapCurrent.offset(12);
                this.heapCurrent = (HeapAddress)this.heapCurrent.offset(n2);
            }
        }
        heapAddress.offset(-12).poke4(n);
        heapAddress.offset(-4).poke(HeapAddress.addressOf(object));
        if (this.gcBits != null) {
            this.gcBits.set((HeapAddress)heapAddress.offset(-12));
        }
        return heapAddress.asObject();
    }

    public final Object allocateArrayAlign8(int n, int n2, Object object) throws OutOfMemoryError, NegativeArraySizeException {
        this.heapCurrent = (HeapAddress)this.heapCurrent.offset(12).align(3).offset(-12);
        return this.allocateArray(n, n2, object);
    }

    public final void collect() {
    }

    public final void processPtrField(Address address) {
    }
}

