/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_Reference;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Memory.Address;
import Memory.Heap.Heap;
import Memory.HeapAddress;
import Run_Time.SystemInterface;
import Util.Assert;
import java.lang.reflect.Array;

public abstract class HeapAllocator
implements jq_ClassFileConstants {
    private static boolean isOutOfMemory = false;
    private static final OutOfMemoryError outofmemoryerror = new OutOfMemoryError();
    public static final jq_StaticMethod _clsinitAndAllocateObject;

    public abstract void init() throws OutOfMemoryError;

    public abstract Object allocateObject(int var1, Object var2) throws OutOfMemoryError;

    public abstract Object allocateObjectAlign8(int var1, Object var2) throws OutOfMemoryError;

    public abstract Object allocateArray(int var1, int var2, Object var3) throws OutOfMemoryError, NegativeArraySizeException;

    public abstract Object allocateArrayAlign8(int var1, int var2, Object var3) throws OutOfMemoryError, NegativeArraySizeException;

    public abstract int freeMemory();

    public abstract int totalMemory();

    public abstract void collect();

    public abstract void processPtrField(Address var1);

    public static Object clsinitAndAllocateObject(jq_Type jq_Type2) throws VerifyError {
        if (!jq_Type2.isClassType()) {
            throw new VerifyError();
        }
        jq_Class jq_Class2 = (jq_Class)jq_Type2;
        jq_Class2.cls_initialize();
        return jq_Class2.newInstance();
    }

    public static Object clone(Object object) throws OutOfMemoryError {
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(object);
        if (jq_Reference2.isClassType()) {
            jq_Class jq_Class2 = (jq_Class)jq_Reference2;
            Object object2 = jq_Class2.newInstance();
            if (jq_Class2.getInstanceSize() - 8 > 0) {
                SystemInterface.mem_cpy(HeapAddress.addressOf(object2), HeapAddress.addressOf(object), jq_Class2.getInstanceSize() - 8);
            }
            return object2;
        }
        Assert._assert(jq_Reference2.isArrayType());
        jq_Array jq_Array2 = (jq_Array)jq_Reference2;
        int n = Array.getLength(object);
        Object object3 = jq_Array2.newInstance(n);
        if (n > 0) {
            SystemInterface.mem_cpy(HeapAddress.addressOf(object3), HeapAddress.addressOf(object), jq_Array2.getInstanceSize(n) - 12);
        }
        return object3;
    }

    public static void heapExhausted(Heap heap, int n, int n2) throws OutOfMemoryError {
        if (n2 > 3) {
            HeapAllocator.outOfMemory();
        }
    }

    public static void outOfMemory() throws OutOfMemoryError {
        if (isOutOfMemory) {
            SystemInterface.die(-1);
        }
        isOutOfMemory = true;
        SystemInterface.debugwriteln("Out of memory!");
        throw outofmemoryerror;
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/HeapAllocator;");
        _clsinitAndAllocateObject = jq_Class2.getOrCreateStaticMethod("clsinitAndAllocateObject", "(LClazz/jq_Type;)Ljava/lang/Object;");
    }

    public static class HeapPointer
    implements Comparable {
        private final HeapAddress ip;

        public HeapAddress get() {
            return this.ip;
        }

        public int compareTo(HeapPointer heapPointer) {
            if (this.ip.difference(heapPointer.ip) < 0) {
                return -1;
            }
            if (this.ip.difference(heapPointer.ip) > 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object object) {
            return this.compareTo((HeapPointer)object);
        }

        public boolean equals(HeapPointer heapPointer) {
            boolean bl = false;
            if (this.ip.difference(heapPointer.ip) == 0) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            return this.equals((HeapPointer)object);
        }

        public int hashCode() {
            return this.ip.to32BitValue();
        }

        public HeapPointer(HeapAddress heapAddress) {
            this.ip = heapAddress;
        }
    }
}

