/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Allocator.BestFitStrategy;
import Allocator.FreeMemStrategy;
import Allocator.MemUnit;
import Memory.Address;

public class FreeMemManager {
    private static FreeMemStrategy defaultStrategy;
    private static FreeMemStrategy strategy;

    public static void setFreeMemStrategy(FreeMemStrategy freeMemStrategy) {
        strategy = freeMemStrategy;
    }

    public static void addFreeMem(MemUnit memUnit) {
        strategy.addFreeMem(memUnit);
    }

    public static Address getFreeMem(int n) {
        MemUnit memUnit = strategy.getFreeMem(n);
        if (memUnit == null) {
            return null;
        }
        Address address = memUnit.getHead().offset(n);
        int n2 = memUnit.getByteLength() - n;
        if (n2 > 0) {
            strategy.addFreeMem(new MemUnit(address, n2));
        }
        return address;
    }

    static {
        strategy = defaultStrategy = new BestFitStrategy();
    }
}

