/*
 * Decompiled with CFR 0.152.
 */
package Allocator;

import Allocator.HeapAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_StaticMethod;
import Memory.Address;
import Run_Time.Unsafe;

public abstract class DefaultHeapAllocator {
    public static final jq_StaticMethod _allocateObject;
    public static final jq_StaticMethod _allocateObjectAlign8;
    public static final jq_StaticMethod _allocateArray;
    public static final jq_StaticMethod _allocateArrayAlign8;

    public static final HeapAllocator def() {
        return Unsafe.getThreadBlock().getNativeThread().getHeapAllocator();
    }

    public static final void init() throws OutOfMemoryError {
        DefaultHeapAllocator.def().init();
    }

    public static final Object allocateObject(int n, Object object) throws OutOfMemoryError {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object2 = DefaultHeapAllocator.def().allocateObject(n, object);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object2;
    }

    public static final Object allocateObjectAlign8(int n, Object object) throws OutOfMemoryError {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object2 = DefaultHeapAllocator.def().allocateObjectAlign8(n, object);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object2;
    }

    public static final Object allocateArray(int n, int n2, Object object) throws OutOfMemoryError, NegativeArraySizeException {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object2 = DefaultHeapAllocator.def().allocateArray(n, n2, object);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object2;
    }

    public static final Object allocateArrayAlign8(int n, int n2, Object object) throws OutOfMemoryError, NegativeArraySizeException {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object2 = DefaultHeapAllocator.def().allocateArrayAlign8(n, n2, object);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object2;
    }

    public static final int freeMemory() {
        return DefaultHeapAllocator.def().freeMemory();
    }

    public static final int totalMemory() {
        return DefaultHeapAllocator.def().totalMemory();
    }

    public static final void collect() {
        Unsafe.getThreadBlock().disableThreadSwitch();
        DefaultHeapAllocator.def().collect();
        Unsafe.getThreadBlock().enableThreadSwitch();
    }

    public static final void processPtrField(Address address) {
        DefaultHeapAllocator.def().processPtrField(address);
    }

    static {
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LAllocator/DefaultHeapAllocator;");
        _allocateObject = jq_Class2.getOrCreateStaticMethod("allocateObject", "(ILjava/lang/Object;)Ljava/lang/Object;");
        _allocateObjectAlign8 = jq_Class2.getOrCreateStaticMethod("allocateObjectAlign8", "(ILjava/lang/Object;)Ljava/lang/Object;");
        _allocateArray = jq_Class2.getOrCreateStaticMethod("allocateArray", "(IILjava/lang/Object;)Ljava/lang/Object;");
        _allocateArrayAlign8 = jq_Class2.getOrCreateStaticMethod("allocateArrayAlign8", "(IILjava/lang/Object;)Ljava/lang/Object;");
    }
}

